/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.common.util.tests;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.wst.jsdt.js.node.common.json.objects.PackageJson;
import org.eclipse.wst.jsdt.js.node.common.tests.utils.ResourceUtils;
import org.eclipse.wst.jsdt.js.node.common.util.PackageJsonUtil;
import org.junit.Assert;
import org.junit.Test;

public class PackageJsonUtilTest {
    public static final String RESOURCE_PACKAGE_JSON = "resources/package.json";
    public static final String NAME_ATTR = "name";
    public static final String EMAIL_ATTR = "email";
    public static final String FIRST_CONTRIBUTOR_NAME = "John Smith";
    public static final String FIRST_CONTRIBUTOR_EMAIL = "jsmith@gmail.com";
    public static final String SECOND_CONTRIBUTOR_NAME = "Chris Jones";
    public static final String SECOND_CONTRIBUTOR_EMAIL = "cjones@gmail.com";
    public static final String NAME_VALUE = "test name";
    public static final String AUTHOR_VALUE = "test author";
    public static final String DESCRIPTION_VALUE = "test description";
    public static final String LICENSE_VALUE = "test license";

    @Test
    public void testReadPackageJsonFromFileString() {
        try {
            File resourcePath = ResourceUtils.getResource(RESOURCE_PACKAGE_JSON);
            PackageJson packageJson = PackageJsonUtil.readPackageJsonFromFile((String)resourcePath.getAbsolutePath());
            Assert.assertTrue((String)"Package.json name attribute is wrong.", (boolean)packageJson.getName().equals(NAME_VALUE));
            Assert.assertTrue((String)"Package.json author attribute is wrong.", (boolean)packageJson.getAuthor().equals(AUTHOR_VALUE));
            Assert.assertTrue((String)"Package.json first contributor name is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(0)).get(NAME_ATTR)).equals(FIRST_CONTRIBUTOR_NAME));
            Assert.assertTrue((String)"Package.json first contributor email is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(0)).get(EMAIL_ATTR)).equals(FIRST_CONTRIBUTOR_EMAIL));
            Assert.assertTrue((String)"Package.json second contributor name is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(1)).get(NAME_ATTR)).equals(SECOND_CONTRIBUTOR_NAME));
            Assert.assertTrue((String)"Package.json second contributor email is wrong.", (boolean)((String)((Map)packageJson.getContributors().get(1)).get(EMAIL_ATTR)).equals(SECOND_CONTRIBUTOR_EMAIL));
            Assert.assertTrue((String)"Package.json description attribute is wrong.", (boolean)packageJson.getDescription().equals(DESCRIPTION_VALUE));
            Assert.assertTrue((String)"Package.json license attribute is wrong.", (boolean)packageJson.getLicense().equals(LICENSE_VALUE));
            Assert.assertTrue((String)"Package.json private attribute is wrong.", (boolean)packageJson.getIsPrivate());
        }
        catch (IOException iOException) {
            Assert.fail((String)"Could not read file.");
        }
    }
}

