/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui;

import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableUtils {
    public static final IStructuredContentProvider OBJECT_ARRAY_CONTENT_PROVIDER = new IStructuredContentProvider(){

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    public static <T> ValueAdapter<Object, T> createCastAdapter(final Class<T> type) {
        return new ValueAdapter<Object, T>(){

            @Override
            public T convert(Object from) {
                return type.cast(from);
            }
        };
    }

    public static class ColumnBasedLabelProvider<ROW>
    implements ITableLabelProvider {
        private final List<? extends ColumnData<ROW, ?>> columns;
        private final ValueAdapter<Object, ROW> rowElementAdpater;

        public ColumnBasedLabelProvider(ValueAdapter<Object, ROW> rowElementAdpater, List<? extends ColumnData<ROW, ?>> columns) {
            this.rowElementAdpater = rowElementAdpater;
            this.columns = columns;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ROW rowElement = this.rowElementAdpater.convert(element);
            ColumnData<ROW, ?> data = this.columns.get(columnIndex);
            return this.getImageImpl(data, rowElement);
        }

        private <C> Image getImageImpl(ColumnData<ROW, C> data, ROW rowElement) {
            C columnValue = data.getColumnValueConverter().convert(rowElement);
            return data.getLabelProvider().getColumnImage(columnValue);
        }

        public String getColumnText(Object element, int columnIndex) {
            ROW rowElement = this.rowElementAdpater.convert(element);
            ColumnData<ROW, ?> data = this.columns.get(columnIndex);
            return this.getTextImpl(data, rowElement);
        }

        private <C> String getTextImpl(ColumnData<ROW, C> data, ROW rowElement) {
            C columnValue = data.getColumnValueConverter().convert(rowElement);
            return data.getLabelProvider().getColumnText(columnValue);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void setUpColumns(Table table) {
            for (ColumnData<ROW, ?> column : this.columns) {
                column.getLabelProvider().createColumn(table);
            }
        }

        public void dispose() {
            for (ColumnData<ROW, ?> column : this.columns) {
                column.getLabelProvider().dispose();
            }
        }
    }

    public static class ColumnData<R, C> {
        private final ValueAdapter<R, C> columnValueConverter;
        private final ColumnLabelProvider<C> labelProvider;

        public static <R, C> ColumnData<R, C> create(ValueAdapter<R, C> columnValueConverter, ColumnLabelProvider<C> labelProvider) {
            return new ColumnData<R, C>(columnValueConverter, labelProvider);
        }

        public ColumnData(ValueAdapter<R, C> columnValueConverter, ColumnLabelProvider<C> labelProvider) {
            this.columnValueConverter = columnValueConverter;
            this.labelProvider = labelProvider;
        }

        public ValueAdapter<R, C> getColumnValueConverter() {
            return this.columnValueConverter;
        }

        public ColumnLabelProvider<C> getLabelProvider() {
            return this.labelProvider;
        }
    }

    public static abstract class ColumnLabelProvider<C> {
        public abstract Image getColumnImage(C var1);

        public abstract String getColumnText(C var1);

        public abstract TableColumn createColumn(Table var1);

        public void dispose() {
        }
    }

    public static class TrivialAdapter<T>
    implements ValueAdapter<T, T> {
        @Override
        public T convert(T from) {
            return from;
        }
    }

    public static interface ValueAdapter<F, T> {
        public T convert(F var1);
    }
}

