/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.internal.debug.ui.Messages;
import org.eclipse.wst.xsl.internal.debug.ui.XMLProcessingInstructionSniffer;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.XslOutputMethodSniffer;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.InputFileBlock;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.TransformsBlock;
import org.eclipse.wst.xsl.launching.config.BaseLaunchHelper;
import org.eclipse.wst.xsl.launching.config.LaunchPipeline;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLLaunchShortcut
implements ILaunchShortcut {
    private static final String XML_STYLESHEET_PI = "xml-stylesheet";
    private IFile xmlFile;
    private IPath xmlFilePath;
    private IFile[] xslFiles;
    private String xslFilePath;
    private LaunchPipeline pipeline;

    public void launch(ISelection selection, String mode) {
        Adapters.of((Object)selection, IStructuredSelection.class).ifPresent(ssel -> this.searchAndLaunch(ssel.toArray(), mode));
    }

    public void launch(IEditorPart editor, String mode) {
        IFile file;
        IEditorInput input = editor.getEditorInput();
        if (input != null && (file = (IFile)input.getAdapter(IFile.class)) != null) {
            this.searchAndLaunch(new Object[]{file}, mode);
        }
    }

    private void searchAndLaunch(Object[] objects, String mode) {
        if (this.fillFiles(objects)) {
            if (this.xmlFile == null) {
                this.promptForInput();
            }
            if (this.xslFiles == null || this.xslFiles.length == 0 && this.xslFilePath == null) {
                this.promptForStylesheet();
            }
            if (this.xmlFile != null || this.xmlFilePath != null) {
                this.launch(mode);
            }
        }
    }

    private void promptForInput() {
        StatusDialog dialog = new StatusDialog(this.getShell()){
            private InputFileBlock inputFileBlock;
            {
                this.inputFileBlock = new InputFileBlock(null);
            }

            protected Control createDialogArea(Composite parent) {
                Composite comp = (Composite)super.createDialogArea(parent);
                comp.setFont(parent.getFont());
                GridLayout layout = new GridLayout(1, false);
                comp.setLayout((Layout)layout);
                Label label = new Label(comp, 0);
                label.setFont(comp.getFont());
                GridData gd = new GridData();
                gd.horizontalIndent = 5;
                gd.verticalIndent = 5;
                gd.widthHint = 380;
                label.setLayoutData((Object)gd);
                label.setText(Messages.XSLLaunchShortcut_0);
                this.inputFileBlock.createControl(comp);
                return comp;
            }

            protected void okPressed() {
                this.saveSelectedXmlFile();
                super.okPressed();
            }

            private void saveSelectedXmlFile() {
                IResource res = this.inputFileBlock.getResource();
                if (res == null) {
                    XSLLaunchShortcut.this.xmlFilePath = new Path(this.inputFileBlock.getText());
                } else if (ResourcesPlugin.getWorkspace().getRoot().exists(res.getFullPath()) && res.getType() == 1) {
                    XSLLaunchShortcut.this.xmlFile = (IFile)Adapters.adapt((Object)res, IFile.class);
                }
            }
        };
        dialog.setHelpAvailable(false);
        dialog.setStatusLineAboveButtons(true);
        dialog.setTitle(Messages.XSLLaunchShortcut_1);
        dialog.open();
    }

    private void promptForStylesheet() {
        final LaunchPipeline promptedPipeline = new LaunchPipeline();
        StatusDialog dialog = new StatusDialog(this.getShell()){
            private TransformsBlock transformsBlock;
            {
                super($anonymous0);
                this.transformsBlock = new TransformsBlock();
            }

            protected Control createDialogArea(Composite parent) {
                Composite comp = (Composite)super.createDialogArea(parent);
                comp.setFont(parent.getFont());
                GridLayout layout = new GridLayout(1, false);
                comp.setLayout((Layout)layout);
                Label label = new Label(comp, 0);
                label.setFont(comp.getFont());
                GridData gd = new GridData();
                gd.horizontalIndent = 5;
                gd.verticalIndent = 5;
                gd.widthHint = 380;
                label.setLayoutData((Object)gd);
                label.setText(Messages.XSLLaunchShortcut_7);
                promptedPipeline.setTransformDefs(new ArrayList());
                this.transformsBlock.setPipeline(promptedPipeline);
                this.transformsBlock.createControl(comp);
                this.transformsBlock.initializeFrom(null);
                return comp;
            }

            protected void okPressed() {
                this.savePipeline();
                super.okPressed();
            }

            private void savePipeline() {
                XSLLaunchShortcut.this.pipeline = promptedPipeline;
            }
        };
        dialog.setHelpAvailable(false);
        dialog.setStatusLineAboveButtons(true);
        dialog.setTitle(Messages.XSLLaunchShortcut_1);
        dialog.open();
    }

    private boolean fillFiles(Object[] selections) {
        this.xmlFile = null;
        this.xmlFilePath = null;
        ArrayList<IFile> xslFileList = new ArrayList<IFile>();
        this.xslFilePath = null;
        Object[] objectArray = selections;
        int n = selections.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            Object object = objectArray[n2];
            IResource resource = (IResource)Adapters.adapt((Object)object, IResource.class);
            if (resource != null && resource.getType() == 1 && (file = (IFile)Adapters.adapt((Object)resource, IFile.class)) != null && XSLCore.isXMLFile((IFile)file)) {
                if (XSLCore.isXSLFile((IFile)file)) {
                    xslFileList.add(file);
                } else if (this.xmlFile == null) {
                    this.xmlFile = file;
                } else {
                    return false;
                }
            }
            ++n2;
        }
        if (xslFileList.isEmpty() && this.xmlFile != null) {
            XMLProcessingInstructionSniffer sniffer = new XMLProcessingInstructionSniffer();
            try {
                sniffer.parseContents(new InputSource(this.xmlFile.getContents()));
                List<Map<String, String>> instructions = sniffer.getProcessingInstructions(XML_STYLESHEET_PI);
                if (instructions != null) {
                    for (Map map : instructions) {
                        String href;
                        String alternative = (String)map.get("alternative");
                        if (alternative != null && alternative.equalsIgnoreCase("yes") || (href = (String)map.get("href")) == null) continue;
                        if (new URI(href).isAbsolute()) {
                            this.xslFilePath = href;
                            continue;
                        }
                        xslFileList.add(this.xmlFile.getProject().getFile(this.xmlFile.getParent().getProjectRelativePath().append(href)));
                    }
                }
            }
            catch (IOException | URISyntaxException | ParserConfigurationException | CoreException | SAXException throwable) {}
        }
        this.xslFiles = xslFileList.toArray(new IFile[0]);
        return true;
    }

    private void launch(String mode) {
        if (this.xmlFile != null) {
            this.xmlFilePath = this.xmlFile.getLocation();
        }
        ILaunchConfiguration config = null;
        try {
            config = this.findOrCreateLaunchConfiguration();
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log(e);
        }
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.wst.xsl.launching.launchConfigurationType");
    }

    private ILaunchConfiguration findOrCreateLaunchConfiguration() throws CoreException {
        ILaunchConfiguration config;
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(this.getConfigurationType());
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                config = iLaunchConfigurationArray[n2];
                String inputFile = config.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", null);
                try {
                    inputFile = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(inputFile);
                }
                catch (CoreException coreException) {
                    break block7;
                }
                Path path = new Path(inputFile);
                if (path.equals((Object)this.xmlFilePath)) {
                    BaseLaunchHelper lh = new BaseLaunchHelper(config);
                    boolean found = false;
                    IFile[] iFileArray = this.xslFiles;
                    int n3 = this.xslFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IFile stylesheet = iFileArray[n4];
                        found = false;
                        for (LaunchTransform lt : lh.getPipeline().getTransformDefs()) {
                            if (!lt.getLocation().equals((Object)stylesheet.getLocation())) continue;
                            found = true;
                            break;
                        }
                        if (!found) break;
                        ++n4;
                    }
                    if (found) {
                        candidateConfigs.add(config);
                    }
                }
            }
            ++n2;
        }
        config = null;
        int candidateCount = candidateConfigs.size();
        config = candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : (candidateCount > 1 ? this.chooseConfiguration(candidateConfigs) : this.createConfiguration());
        return config;
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.XSLLaunchShortcut_2);
        dialog.setMessage(Messages.XSLSelectExisting);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration createConfiguration() {
        ILaunchConfiguration config = null;
        try {
            LaunchTransform lastDef;
            String outputFormat;
            ILaunchConfigurationType configType = this.getConfigurationType();
            String lastSegment = this.xmlFile != null ? this.xmlFile.getName() : (this.xmlFilePath != null ? this.xmlFilePath.lastSegment() : "XSLTransformation");
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(lastSegment));
            if (this.xmlFile != null) {
                wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", "${workspace_loc:" + this.xmlFile.getFullPath().toPortableString() + "}");
            } else {
                wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", this.xmlFilePath.toPortableString());
            }
            wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", true);
            wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", true);
            if (this.pipeline == null) {
                this.pipeline = new LaunchPipeline();
            }
            IFile[] iFileArray = this.xslFiles;
            int n = this.xslFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile element = iFileArray[n2];
                this.pipeline.addTransformDef(new LaunchTransform(element.getFullPath().toPortableString(), "resource"));
                ++n2;
            }
            if (this.xslFilePath != null) {
                this.pipeline.addTransformDef(new LaunchTransform(this.xslFilePath, "external"));
            }
            if (!this.pipeline.getTransformDefs().isEmpty() && (outputFormat = this.guessOutputMethod(lastDef = (LaunchTransform)this.pipeline.getTransformDefs().get(this.pipeline.getTransformDefs().size() - 1))) != null) {
                wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_DEFAULT_OUTPUT_METHOD", outputFormat);
            }
            wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_PIPELINE", this.pipeline.toXML());
            if (this.xmlFile != null) {
                wc.setMappedResources(new IResource[]{this.xmlFile.getProject()});
            }
            config = wc.doSave();
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.XSLLaunchShortcut_6, (String)exception.getStatus().getMessage());
        }
        return config;
    }

    private String guessOutputMethod(LaunchTransform lastDef) {
        try {
            XslOutputMethodSniffer xofs = new XslOutputMethodSniffer();
            xofs.parseContents(new InputSource(new FileInputStream(lastDef.getLocation().toFile())));
            return xofs.getOutputMethod();
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException throwable) {
            return null;
        }
    }

    protected Shell getShell() {
        return XSLDebugUIPlugin.getActiveWorkbenchShell();
    }
}

