/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;

public class PerformUnsavedRefactoringOperation
implements IWorkspaceRunnable {
    private ProcessorBasedRefactoring refactoring;

    public PerformUnsavedRefactoringOperation(ProcessorBasedRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public void run(IProgressMonitor pm) {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        try {
            this.refactoring.checkAllConditions(pm);
            Change change = this.refactoring.createChange(pm);
            if (change instanceof CompositeChange) {
                CompositeChange compositeChange = (CompositeChange)change;
                this.setSaveMode(compositeChange);
            }
            change.perform(pm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setSaveMode(CompositeChange composite) {
        Change[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Change child = children[i];
            if (child instanceof TextFileChange) {
                ((TextFileChange)child).setSaveMode(4);
            } else if (child instanceof CompositeChange) {
                this.setSaveMode((CompositeChange)child);
            }
            ++i;
        }
    }
}

