/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.ResourceSingletonObjectManager;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.JSFCoreTraceOptions;
import org.eclipse.jst.jsf.designtime.internal.Messages;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.TLDTagRegistry;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class TLDRegistryManager
extends ResourceSingletonObjectManager<TLDTagRegistry, IProject> {
    private static final String JST_WEB_MODULE = "jst.web";
    private static TLDRegistryManager INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TLDRegistryManager getGlobalManager() {
        Class<TLDRegistryManager> clazz = TLDRegistryManager.class;
        synchronized (TLDRegistryManager.class) {
            if (INSTANCE == null) {
                if (JSFCoreTraceOptions.TRACE_TLDREGISTRYMANAGER) {
                    JSFCoreTraceOptions.log("TLDRegistryManager: Initializing TLDRegistryManager singleton");
                }
                INSTANCE = new TLDRegistryManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private TLDRegistryManager() {
        super(ResourcesPlugin.getWorkspace());
        MyWorkspaceSaveParticipant participant = new MyWorkspaceSaveParticipant();
        try {
            ResourcesPlugin.getWorkspace().addSaveParticipant(JSFCorePlugin.getDefault().getPluginID(), (ISaveParticipant)participant);
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "TLDRegistryManager failed to install save participant");
        }
    }

    protected TLDTagRegistry createNewInstance(IProject project) {
        if (JSFCoreTraceOptions.TRACE_TLDREGISTRYMANAGER) {
            JSFCoreTraceOptions.log("TLDRegistryManager: creating new instance for " + project.toString());
        }
        return new TLDTagRegistry(project);
    }

    protected void runAfterGetInstance(IProject resource) {
        if (JSFCoreTraceOptions.TRACE_TLDREGISTRYMANAGER) {
            JSFCoreTraceOptions.log("TLDRegistryManager: Acquired instance for " + resource.toString());
        }
    }

    protected void runBeforeGetInstance(IProject resource) {
        if (JSFCoreTraceOptions.TRACE_TLDREGISTRYMANAGER) {
            JSFCoreTraceOptions.log("TLDRegistryManager: Getting registry for " + resource.toString());
        }
    }

    public static class MyRegistryFactory
    extends TagRegistryFactory {
        @Override
        public ITagRegistry createTagRegistry(IProject project) throws TagRegistryFactory.TagRegistryFactoryException {
            try {
                return (ITagRegistry)TLDRegistryManager.getGlobalManager().getInstance((IResource)project);
            }
            catch (ObjectManager.ManagedObjectException e) {
                throw new TagRegistryFactory.TagRegistryFactoryException(e);
            }
        }

        @Override
        public boolean isInstance(IProject project) {
            return TLDRegistryManager.getGlobalManager().isInstance((IResource)project);
        }

        public String getDisplayName() {
            return Messages.TLDRegistryManager_DisplayName;
        }

        @Override
        public boolean projectIsValid(IProject project) {
            if (project == null) {
                return false;
            }
            try {
                if (ProjectFacetsManager.isProjectFacetDefined((String)TLDRegistryManager.JST_WEB_MODULE)) {
                    IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
                    IProjectFacet webModuleFacet = ProjectFacetsManager.getProjectFacet((String)TLDRegistryManager.JST_WEB_MODULE);
                    if (faceted != null && faceted.hasProjectFacet(webModuleFacet)) {
                        return true;
                    }
                }
            }
            catch (CoreException ce) {
                JSFCorePlugin.log((Exception)((Object)ce), "TLDRegistryManager failed checking web project");
            }
            return false;
        }
    }

    private class MyWorkspaceSaveParticipant
    implements ISaveParticipant {
        private MyWorkspaceSaveParticipant() {
        }

        public void saving(ISaveContext context) throws CoreException {
            if (JSFCoreTraceOptions.TRACE_TLDREGISTRYMANAGER) {
                JSFCoreTraceOptions.log("MyWorkspaceSaveParticipant.saving: Kind=" + context.getKind());
            }
            try {
                if (context.getKind() == 1) {
                    Collection projects = TLDRegistryManager.this.getManagedResources();
                    for (IProject project : projects) {
                        this.saveProject(project);
                    }
                } else if (context.getKind() == 3) {
                    this.saveProject(context.getProject());
                }
            }
            catch (ObjectManager.ManagedObjectException moe) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Couldn't commit workspace", (Throwable)moe));
            }
        }

        private void saveProject(IProject project) throws ObjectManager.ManagedObjectException {
            if (JSFCoreTraceOptions.TRACE_TLDREGISTRYMANAGER) {
                JSFCoreTraceOptions.log("MyWorkspaceSaveParticipant.saveProject: Project=" + project.toString());
            }
            if (TLDRegistryManager.this.isInstance((IResource)project)) {
                TLDTagRegistry registry = (TLDTagRegistry)TLDRegistryManager.this.getInstance((IResource)project);
                if (JSFCoreTraceOptions.TRACE_TLDREGISTRYMANAGER) {
                    JSFCoreTraceOptions.log("MyWorkspaceSaveParticipant.saveProject: calling checkpoint on registry: " + registry.toString());
                }
                registry.checkpoint();
            }
        }

        public void doneSaving(ISaveContext context) {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
        }
    }
}

