/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorDropTargetAdapter;

public class DefaultTextTransferDropTargetAdapterProxy
extends ExtendedEditorDropTargetAdapter {
    private DropTargetListener fDefaultTargetListener;

    public DefaultTextTransferDropTargetAdapterProxy(DropTargetListener defaultTargetListener) {
        super(true);
        this.fDefaultTargetListener = defaultTargetListener;
    }

    @Override
    public void dragEnter(DropTargetEvent event) {
        if (this.useSSE(event)) {
            super.dragEnter(event);
        } else {
            this.fDefaultTargetListener.dragEnter(event);
        }
    }

    @Override
    public void dragLeave(DropTargetEvent event) {
        if (this.useSSE(event)) {
            super.dragLeave(event);
        } else {
            this.fDefaultTargetListener.dragLeave(event);
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (this.useSSE(event)) {
            super.dragOperationChanged(event);
        } else {
            this.fDefaultTargetListener.dragOperationChanged(event);
        }
    }

    @Override
    public void dragOver(DropTargetEvent event) {
        if (this.useSSE(event)) {
            super.dragOver(event);
        } else {
            this.fDefaultTargetListener.dragOver(event);
        }
    }

    @Override
    public void drop(DropTargetEvent event) {
        if (this.useSSE(event)) {
            super.drop(event);
        } else {
            this.fDefaultTargetListener.drop(event);
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (this.useSSE(event)) {
            super.dropAccept(event);
        } else {
            this.fDefaultTargetListener.dropAccept(event);
        }
    }

    private boolean useSSE(DropTargetEvent event) {
        Transfer[] transferArray = this.getTransfers();
        int n = transferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer tr = transferArray[n2];
            TransferData[] transferDataArray = event.dataTypes;
            int n3 = event.dataTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                TransferData td = transferDataArray[n4];
                if (tr.isSupportedType(td)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }
}

