/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class ArrayMap
extends Hashtable {
    private static final long serialVersionUID = 1L;

    public ArrayMap(int size) {
        super(size);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object[] values = (Object[])super.get(key);
        Object[] newValues = null;
        if (values == null || values.length == 0) {
            newValues = new Object[1];
        } else {
            newValues = new Object[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
        }
        newValues[newValues.length - 1] = value;
        return super.put(key, newValues);
    }

    public synchronized Object removeFirstPair(Object key, Object value) {
        Object[] values = (Object[])super.get(key);
        Object removed = null;
        Object[] result = null;
        if (values != null && value != null) {
            int i = 0;
            while (i < values.length) {
                if (value.equals(values[i])) {
                    removed = values[i];
                    result = new Object[values.length - 1];
                    if (result.length > 0) {
                        System.arraycopy(values, 0, result, 0, i);
                        if (i >= values.length - 1) break;
                        System.arraycopy(values, i + 1, result, i, result.length - i);
                        break;
                    }
                    super.remove(key);
                    break;
                }
                ++i;
            }
        }
        if (result != null && result.length > 0) {
            super.put(key, result);
        }
        return removed;
    }

    @Override
    public Collection values() {
        Collection valuemaps = super.values();
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator i = valuemaps.iterator();
        while (i.hasNext()) {
            values.addAll(Arrays.asList((Object[])i.next()));
        }
        return values;
    }
}

