/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;

class MockUpResourceWriter {
    private int line = 0;
    private int col = 0;
    private final StringBuilder builder = new StringBuilder();
    private static final String NOT_A_JAVASCRIPT_FILLER = Messages.MockUpResourceWriter_NOT_A_JAVASCRIPT;
    private static final Comparator<Script> scriptPositionComparator = new Comparator<Script>(){

        @Override
        public int compare(Script o1, Script o2) {
            int col2;
            int line2;
            int line1 = o1.getStartLine();
            if (line1 < (line2 = o2.getStartLine())) {
                return -1;
            }
            if (line1 > line2) {
                return 1;
            }
            int col1 = o1.getStartColumn();
            if (col1 < (col2 = o2.getStartColumn())) {
                return -1;
            }
            if (col1 > col2) {
                return 1;
            }
            return 0;
        }
    };

    MockUpResourceWriter() {
    }

    static String writeScriptSource(Collection<Script> scripts) {
        ArrayList<Script> sortedScriptsArrayList = new ArrayList<Script>();
        for (Script script : scripts) {
            if (script.isCollected()) continue;
            sortedScriptsArrayList.add(script);
        }
        Collections.sort(sortedScriptsArrayList, scriptPositionComparator);
        MockUpResourceWriter writer = new MockUpResourceWriter();
        for (Script script : sortedScriptsArrayList) {
            writer.writeSript(script);
        }
        return writer.getResult();
    }

    private void writeSript(Script script) {
        int scriptLine = script.getStartLine();
        if (scriptLine > this.line) {
            this.fillLines(scriptLine - this.line);
            this.line = scriptLine;
            int scriptCol = script.getStartColumn();
            this.fillColumns(scriptCol);
        } else if (scriptLine < this.line) {
            this.writeLineMissMessage(scriptLine);
        } else {
            int scriptCol = script.getStartColumn();
            if (this.col < scriptCol) {
                this.fillColumns(scriptCol - this.col);
            } else if (this.col > scriptCol) {
                // empty if block
            }
        }
        if (script.hasSource()) {
            this.writeText(script.getSource());
        } else {
            this.writeln(Messages.MockUpResourceWriter_SCRIPT_WITHOUT_TEXT);
        }
    }

    private void writeLineMissMessage(int scriptLine) {
        this.writeln(NLS.bind((String)Messages.MockUpResourceWriter_SCRIPTS_OVERLAPPED, (Object)(this.line + 1 - scriptLine), (Object)(scriptLine + 1)));
    }

    private void writeText(String text) {
        int pos = 0;
        while (true) {
            int nlPos;
            if ((nlPos = text.indexOf(10, pos)) == -1) {
                String rest = text.substring(pos);
                this.builder.append(rest);
                this.col += rest.length();
                break;
            }
            this.writeln(text.substring(pos, nlPos));
            pos = nlPos + 1;
        }
    }

    private void writeln(String str) {
        this.builder.append(str).append('\n');
        ++this.line;
        this.col = 0;
    }

    private void fillLines(int lines) {
        if (this.col != 0) {
            this.builder.append('\n');
            ++this.line;
        }
        int i = 0;
        while (i < lines) {
            this.builder.append(NOT_A_JAVASCRIPT_FILLER).append('\n');
            ++i;
        }
        this.line += lines;
        this.col = 0;
    }

    private void fillColumns(int number) {
        if (number >= NOT_A_JAVASCRIPT_FILLER.length()) {
            this.builder.append(NOT_A_JAVASCRIPT_FILLER.substring(0, NOT_A_JAVASCRIPT_FILLER.length() - 1));
            int fill = number - NOT_A_JAVASCRIPT_FILLER.length();
            int i = 0;
            while (i < fill) {
                this.builder.append('*');
                ++i;
            }
            this.builder.append(NOT_A_JAVASCRIPT_FILLER.substring(NOT_A_JAVASCRIPT_FILLER.length() - 1));
            this.col += number;
        } else if (number >= 1) {
            if (number == 1) {
                this.builder.append('*');
                ++this.col;
            } else {
                this.builder.append('{');
                int i = 2;
                while (i < number) {
                    this.builder.append('*');
                    ++i;
                }
                this.builder.append('}');
                this.col += number;
            }
        }
    }

    private String getResult() {
        return this.builder.toString();
    }
}

