/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.http.ui.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.http.core.internal.HttpServer;
import org.eclipse.wst.server.http.ui.internal.HttpUIPlugin;
import org.eclipse.wst.server.http.ui.internal.Messages;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class HttpServerComposite
extends Composite {
    protected IServerWorkingCopy serverWC;
    protected HttpServer server;
    protected Text prefix;
    protected Spinner port;
    protected Button publishCheckBox;
    protected IWizardHandle wizard;

    public HttpServerComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(Messages.wizardTitle);
        wizard.setDescription(Messages.wizardDescription);
        wizard.setImageDescriptor(HttpUIPlugin.getImageDescriptor("wizServer"));
        this.createControl();
    }

    protected void setServer(IServerWorkingCopy newServer) {
        if (newServer == null) {
            this.serverWC = null;
            this.server = null;
        } else {
            this.serverWC = newServer;
            this.server = (HttpServer)newServer.loadAdapter(HttpServer.class, null);
        }
        if (!this.isDisposed()) {
            this.init();
        }
        this.validate();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Composite comp = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.wst.server.http.ui.twnr0000");
        this.createServerInfoGroup(comp);
        Font font = comp.getFont();
        this.publishCheckBox = new Button(comp, 32);
        this.publishCheckBox.setText(Messages.shouldPublish);
        this.publishCheckBox.setFont(font);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.publishCheckBox.setLayoutData((Object)data);
        this.publishCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                HttpServerComposite.this.server.setPublishing(b.getSelection());
                HttpServerComposite.this.validate();
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.port.forceFocus();
    }

    protected void init() {
        if (this.port == null || this.serverWC == null || this.server == null) {
            return;
        }
        this.port.setSelection(this.server.getPort());
        this.prefix.setText(this.server.getURLPrefix());
        boolean canPublish = this.server.isPublishing();
        this.publishCheckBox.setSelection(canPublish);
    }

    protected void validate() {
        IPath path;
        this.wizard.setMessage(null, 0);
        if (this.server != null && this.server.isPublishing() && ((path = this.serverWC.getRuntime().getLocation()) == null || !path.toFile().exists())) {
            this.wizard.setMessage(Messages.wizardMissingPublishInfo, 3);
        }
        this.wizard.update();
    }

    protected boolean isComplete() {
        return this.wizard.getMessageType() != 3;
    }

    private void createServerInfoGroup(Composite parent) {
        Font font = parent.getFont();
        Label portLabel = new Label(parent, 0);
        portLabel.setFont(font);
        portLabel.setText(Messages.port);
        this.port = new Spinner(parent, 2048);
        this.port.setMinimum(0);
        this.port.setMaximum(999999);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.port.setLayoutData((Object)data);
        this.port.setFont(font);
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (HttpServerComposite.this.server != null) {
                    try {
                        HttpServerComposite.this.server.setPort(HttpServerComposite.this.port.getSelection());
                    }
                    catch (Exception exception) {}
                }
                HttpServerComposite.this.validate();
            }
        });
        Label prefixLabel = new Label(parent, 0);
        prefixLabel.setFont(font);
        prefixLabel.setText(Messages.URLPrefix);
        this.prefix = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 305;
        this.prefix.setLayoutData((Object)data);
        this.prefix.setFont(font);
        this.prefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HttpServerComposite.this.server.setURLPrefix(HttpServerComposite.this.prefix.getText());
                HttpServerComposite.this.validate();
            }
        });
    }
}

