/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.annotations;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.clazz.ASTUtils;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.utils.internal.text.JaxWsUtilMessages;
import org.eclipse.jst.ws.jaxws.utils.resources.EditResourcesManager;
import org.eclipse.jst.ws.jaxws.utils.resources.FileUtils;
import org.eclipse.jst.ws.jaxws.utils.resources.IFileUtils;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class AnnotationWriter {
    private static AnnotationWriter writer = null;
    private final IFileUtils fileUtils = FileUtils.getInstance();

    public static <T extends IJavaElement> AnnotationWriter getInstance() {
        if (writer == null) {
            writer = new AnnotationWriter();
        }
        return writer;
    }

    public <T extends IJavaElement> void setAppliedElement(IAnnotation<T> annotation, T javaElement) throws AnnotationGeneratorException {
        AnnotationImpl annotationImpl = (AnnotationImpl)annotation;
        annotationImpl.setJavaElement(javaElement);
        this.setAnnotatationStringVallue(annotationImpl, true, javaElement);
    }

    private <T extends IJavaElement> void setAnnotatationStringVallue(AnnotationImpl<T> annotationImpl, boolean needSave, T javaElement) throws AnnotationGeneratorException {
        if (!needSave) {
            return;
        }
        if (javaElement instanceof IType) {
            this.addToClass(annotationImpl, (IType)javaElement);
        }
        if (javaElement instanceof IField) {
            this.addToField(annotationImpl, (IField)javaElement);
        }
        if (javaElement instanceof IMethod) {
            this.addToMethod(annotationImpl, (IMethod)javaElement);
        }
        if (javaElement instanceof ITypeParameter) {
            this.addToParam(annotationImpl, (ITypeParameter)javaElement);
        }
    }

    private <T extends IJavaElement> void addToClass(AnnotationImpl<T> annotationImpl, IType classType) throws AnnotationGeneratorException {
        String className = classType.getElementName();
        this.addToMember(annotationImpl, classType.getCompilationUnit(), (IJavaElement)classType, className);
    }

    private <T extends IJavaElement> void addToField(AnnotationImpl<T> annotationImpl, IField fieldType) throws AnnotationGeneratorException {
        String className = fieldType.getParent().getElementName();
        this.addToMember(annotationImpl, fieldType.getCompilationUnit(), (IJavaElement)fieldType, className);
    }

    private <T extends IJavaElement> void addToMethod(AnnotationImpl<T> annotationImpl, IMethod methodType) throws AnnotationGeneratorException {
        String className = methodType.getParent().getElementName();
        this.addToMember(annotationImpl, methodType.getCompilationUnit(), (IJavaElement)methodType, className);
    }

    private <T extends IJavaElement> void addToParam(AnnotationImpl<T> annotationImpl, ITypeParameter typeParam) throws AnnotationGeneratorException {
        IMember member = typeParam.getDeclaringMember();
        String className = null;
        className = member.getElementType() == 9 ? member.getDeclaringType().getElementName() : member.getElementName();
        this.addToMember(annotationImpl, member.getCompilationUnit(), (IJavaElement)typeParam, className);
    }

    private <T extends IJavaElement> void addToMember(AnnotationImpl<T> annotationImpl, ICompilationUnit cUnit, IJavaElement type, String className) throws AnnotationGeneratorException {
        block13: {
            try {
                if (cUnit == null) {
                    return;
                }
                CompilationUnit unit = ASTUtils.getInstance().createCompilationUnit(cUnit, null);
                AST ast = unit.getAST();
                TypeDeclaration typeDeclaration = (TypeDeclaration)ASTUtils.getInstance().getTypeDeclaration(className, unit);
                if (typeDeclaration == null) break block13;
                switch (type.getElementType()) {
                    case 7: {
                        this.addAnnotation(annotationImpl, cUnit, unit, ast, (ASTNode)typeDeclaration);
                        break;
                    }
                    case 9: {
                        MethodDeclaration methodDeclaration = ASTUtils.getInstance().getMethodDeclaration((IMethod)type, typeDeclaration);
                        this.addAnnotation(annotationImpl, cUnit, unit, ast, (ASTNode)methodDeclaration);
                        break;
                    }
                    case 8: {
                        FieldDeclaration fieldDeclaration = ASTUtils.getInstance().getFieldDeclaration((IField)type, typeDeclaration);
                        this.addAnnotation(annotationImpl, cUnit, unit, ast, (ASTNode)fieldDeclaration);
                        break;
                    }
                    case 15: {
                        ITypeParameter typeParameter = (ITypeParameter)type;
                        if (typeParameter.getDeclaringMember().getElementType() == 9) {
                            MethodDeclaration methodDeclaration = ASTUtils.getInstance().getMethodDeclaration((IMethod)typeParameter.getDeclaringMember(), typeDeclaration);
                            SingleVariableDeclaration paramDeclaration = AnnotationWriter.getParamDeclaration(typeParameter, methodDeclaration);
                            this.addAnnotation(annotationImpl, cUnit, unit, ast, (ASTNode)paramDeclaration);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported type for annotation");
                    }
                }
            }
            catch (MalformedTreeException e) {
                throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.InvalidTreeStateMsg, e);
            }
            catch (CoreException e) {
                throw new AnnotationGeneratorException(e.getMessage(), e.getStatus().getMessage(), e);
            }
            catch (BadLocationException e) {
                throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.CannotPerformEditMsg, e);
            }
            catch (FileNotFoundException e) {
                throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.CompUnitMissingMsg, e);
            }
        }
    }

    private <T extends IJavaElement> void addAnnotation(AnnotationImpl<T> annotationImpl, ICompilationUnit cUnit, CompilationUnit unit, AST ast, ASTNode declaration) throws CoreException, MalformedTreeException, BadLocationException, FileNotFoundException, AnnotationGeneratorException {
        this.editResManager().setFileEditable((IFile)cUnit.getResource());
        unit.recordModifications();
        Expression annot = annotationImpl.getExpression(unit, ast);
        List modifiers = null;
        switch (declaration.getNodeType()) {
            case 23: 
            case 31: 
            case 55: {
                modifiers = ((BodyDeclaration)declaration).modifiers();
                break;
            }
            case 44: {
                modifiers = ((SingleVariableDeclaration)declaration).modifiers();
                break;
            }
            default: {
                throw new IllegalArgumentException("addAnnotation() illegal declataion type");
            }
        }
        modifiers.add(0, annot);
        IDocument doc = AnnotationUtils.getInstance().getDocument(cUnit);
        TextEdit edit = unit.rewrite(doc, null);
        edit.apply(doc);
        IStatus status = this.editResManager().setFileEditable((IFile)cUnit.getResource());
        if (status.getSeverity() != 0) {
            throw new AnnotationGeneratorException("Annotattion could not be stored, the file is not writable", JaxWsUtilMessages.AnnotationCannotBeStoredMsg);
        }
        this.fileUtils.setCompilationUnitContentAndSaveDirtyEditors(cUnit, doc.get(), true, null);
    }

    private static SingleVariableDeclaration getParamDeclaration(ITypeParameter typeParameter, MethodDeclaration methodDeclaration) {
        String paramName = typeParameter.getElementName();
        for (Object decl : methodDeclaration.parameters()) {
            if (!(decl instanceof SingleVariableDeclaration) || !paramName.equals(((SingleVariableDeclaration)decl).getName().toString())) continue;
            return (SingleVariableDeclaration)decl;
        }
        return null;
    }

    public <T extends IJavaElement> void update(IAnnotation<T> annotation) throws AnnotationGeneratorException, CoreException {
        AnnotationImpl annotattionImpl = new AnnotationImpl(annotation.getAnnotationName(), annotation.getParamValuePairs());
        try {
            this.updateTheAnnotation(annotation.getAppliedElement(), annotattionImpl);
        }
        catch (MalformedTreeException e) {
            throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.InvalidTreeStateMsg, e);
        }
        catch (BadLocationException e) {
            throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.CannotPerformEditMsg, e);
        }
        catch (FileNotFoundException e) {
            throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.CompUnitMissingMsg, e);
        }
    }

    @Deprecated
    public <T extends IJavaElement> void update(IAnnotation<T> annotation, Set<IParamValuePair> paramValuePairs, boolean replacePreviousPairs) throws AnnotationGeneratorException, CoreException {
        this.updateAnnotation(annotation, annotation.getAppliedElement(), paramValuePairs, replacePreviousPairs);
    }

    private <T extends IJavaElement> void updateAnnotation(IAnnotation<T> annotation, T javaElement, Set<IParamValuePair> paramValuePairs, boolean replacePreviousPairs) throws AnnotationGeneratorException, CoreException {
        AnnotationImpl annotationImpl = (AnnotationImpl)annotation;
        try {
            if (replacePreviousPairs) {
                annotationImpl.setParamValuePairs(paramValuePairs);
            } else {
                for (IParamValuePair pair : paramValuePairs) {
                    boolean isUpdated = false;
                    Set<IParamValuePair> tmpParamValuePairs = annotationImpl.getParamValuePairs();
                    for (IParamValuePair thisPair : tmpParamValuePairs) {
                        if (!thisPair.getParam().equals(pair.getParam())) continue;
                        tmpParamValuePairs.remove(thisPair);
                        tmpParamValuePairs.add(pair);
                        isUpdated = true;
                        break;
                    }
                    if (!isUpdated) {
                        tmpParamValuePairs.add(pair);
                    }
                    annotationImpl.setParamValuePairs(tmpParamValuePairs);
                }
            }
            this.updateTheAnnotation(javaElement, annotationImpl);
        }
        catch (MalformedTreeException e) {
            throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.InvalidTreeStateMsg, e);
        }
        catch (BadLocationException e) {
            throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.CannotPerformEditMsg, e);
        }
        catch (FileNotFoundException e) {
            throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.CompUnitMissingMsg, e);
        }
    }

    public <T extends IJavaElement> void remove(IAnnotation<T> annotation) throws AnnotationGeneratorException, CoreException {
        this.removeAnnotation(annotation, annotation.getAppliedElement());
    }

    private <T extends IJavaElement> void removeAnnotation(IAnnotation<T> annotation, T javaElement) throws AnnotationGeneratorException, CoreException {
        AnnotationImpl annotationImpl = (AnnotationImpl)annotation;
        try {
            AnnotationUtils.getInstance().removeAnnotation(javaElement, annotationImpl.getSimpleAnnotationName());
        }
        catch (BadLocationException ble) {
            throw new AnnotationGeneratorException(ble.getMessage(), JaxWsUtilMessages.CannotPerformEditMsg, ble);
        }
        catch (FileNotFoundException fnfe) {
            throw new AnnotationGeneratorException(fnfe.getMessage(), JaxWsUtilMessages.CompUnitMissingMsg, fnfe);
        }
    }

    private <T extends IJavaElement> void updateTheAnnotation(T javaElement, AnnotationImpl<T> annotationImpl) throws BadLocationException, CoreException, AnnotationGeneratorException, FileNotFoundException {
        Expression annot;
        TypeDeclaration td;
        ICompilationUnit iCu = this.getCu(javaElement);
        CompilationUnit unit = ASTUtils.getInstance().createCompilationUnit(iCu, null);
        AbstractTypeDeclaration bd = null;
        Annotation found = null;
        if (javaElement instanceof IType) {
            bd = ASTUtils.getInstance().getTypeDeclaration(javaElement.getElementName(), unit);
            found = this.findAnnotation((BodyDeclaration)bd, annotationImpl);
            unit.recordModifications();
            if (found != null) {
                bd.modifiers().remove(found);
            }
            Expression annot2 = annotationImpl.getExpression(unit, unit.getAST());
            bd.modifiers().add(0, annot2);
        }
        if (javaElement instanceof IMethod) {
            td = (TypeDeclaration)ASTUtils.getInstance().getTypeDeclaration(((IMethod)javaElement).getDeclaringType().getElementName(), unit);
            bd = ASTUtils.getInstance().getMethodDeclaration((IMethod)javaElement, td);
            found = this.findAnnotation((BodyDeclaration)bd, annotationImpl);
            unit.recordModifications();
            if (found != null) {
                bd.modifiers().remove(found);
            }
            annot = annotationImpl.getExpression(unit, unit.getAST());
            bd.modifiers().add(0, annot);
        }
        if (javaElement instanceof IField) {
            td = (TypeDeclaration)ASTUtils.getInstance().getTypeDeclaration(((IField)javaElement).getDeclaringType().getElementName(), unit);
            bd = ASTUtils.getInstance().getFieldDeclaration((IField)javaElement, td);
            found = this.findAnnotation((BodyDeclaration)bd, annotationImpl);
            unit.recordModifications();
            if (found != null) {
                bd.modifiers().remove(found);
            }
            annot = annotationImpl.getExpression(unit, unit.getAST());
            bd.modifiers().add(0, annot);
        }
        if (javaElement instanceof ITypeParameter) {
            if (((ITypeParameter)javaElement).getDeclaringMember() instanceof IType) {
                bd = ASTUtils.getInstance().getTypeDeclaration(((ITypeParameter)javaElement).getDeclaringMember().getElementName(), unit);
                SingleVariableDeclaration param = this.findParameter((BodyDeclaration)bd, javaElement);
                if (param != null) {
                    found = this.findParamAnnotation(param, annotationImpl, javaElement);
                }
                unit.recordModifications();
                if (found != null) {
                    param.modifiers().remove(found);
                }
                annot = annotationImpl.getExpression(unit, unit.getAST());
                param.modifiers().add(0, annot);
            } else {
                td = (TypeDeclaration)ASTUtils.getInstance().getTypeDeclaration(((IMethod)((ITypeParameter)javaElement).getParent()).getDeclaringType().getElementName(), unit);
                bd = ASTUtils.getInstance().getMethodDeclaration((IMethod)((ITypeParameter)javaElement).getParent(), td);
                SingleVariableDeclaration param = this.findParameter((BodyDeclaration)bd, javaElement);
                if (param != null) {
                    found = this.findParamAnnotation(param, annotationImpl, javaElement);
                }
                unit.recordModifications();
                if (found != null) {
                    param.modifiers().remove(found);
                }
                Expression annot3 = annotationImpl.getExpression(unit, unit.getAST());
                param.modifiers().add(0, annot3);
            }
        }
        this.setAnnotatationStringVallue(annotationImpl, false, javaElement);
        IDocument doc = AnnotationUtils.getInstance().getDocument(iCu);
        TextEdit edit = unit.rewrite(doc, javaElement.getJavaProject().getOptions(true));
        edit.apply(doc);
        IStatus status = this.editResManager().setFileEditable((IFile)iCu.getResource());
        if (status.getSeverity() != 0) {
            throw new AnnotationGeneratorException("Annotattion could not be stored, the file is not writable", JaxWsUtilMessages.AnnotationCannotBeStoredMsg);
        }
        this.fileUtils.setCompilationUnitContentAndSaveDirtyEditors(iCu, doc.get(), true, null);
    }

    private Annotation findAnnotation(BodyDeclaration td, IAnnotation<? extends IJavaElement> annotation) {
        for (IExtendedModifier modifier : td.modifiers()) {
            if (!modifier.isAnnotation()) continue;
            Annotation ann = (Annotation)modifier;
            if (!annotation.getAnnotationName().endsWith(ann.getTypeName().getFullyQualifiedName())) continue;
            return ann;
        }
        return null;
    }

    private <T extends IJavaElement> SingleVariableDeclaration findParameter(BodyDeclaration td, T javaElement) {
        if (td != null) {
            for (Object param : ((MethodDeclaration)td).parameters()) {
                if (!(param instanceof SingleVariableDeclaration) || !((ITypeParameter)javaElement).getElementName().toString().equals(((SingleVariableDeclaration)param).getName().toString())) continue;
                return (SingleVariableDeclaration)param;
            }
        }
        return null;
    }

    private <T extends IJavaElement> Annotation findParamAnnotation(SingleVariableDeclaration param, IAnnotation<? extends IJavaElement> annotation, T javaElement) {
        for (IExtendedModifier modifier : param.modifiers()) {
            if (!modifier.isAnnotation()) continue;
            Annotation ann = (Annotation)modifier;
            if (!annotation.getAnnotationName().endsWith(ann.getTypeName().getFullyQualifiedName())) continue;
            return ann;
        }
        return null;
    }

    private ICompilationUnit getCu(IJavaElement javaElement) {
        switch (javaElement.getElementType()) {
            case 7: {
                return ((IType)javaElement).getCompilationUnit();
            }
            case 8: {
                return ((IField)javaElement).getCompilationUnit();
            }
            case 9: {
                return ((IMethod)javaElement).getCompilationUnit();
            }
            case 15: {
                return ((ITypeParameter)javaElement).getDeclaringMember().getCompilationUnit();
            }
        }
        return null;
    }

    private EditResourcesManager editResManager() {
        return new EditResourcesManager();
    }
}

