/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.style.jspel;

import java.util.Collection;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.style.jspel.JSPELCodeScanner;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class LineStyleProviderForJSPEL
extends AbstractLineStyleProvider
implements LineStyleProvider {
    private JSPELCodeScanner fScanner = new JSPELCodeScanner();

    private void addRange(Collection presentation, int offset, int length, TextAttribute attr) {
        String styleString = JSPUIPlugin.getDefault().getPreferenceStore().getString("jsp_content");
        String[] prefs = ColorHelper.unpackStylePreferences((String)styleString);
        Color bgColor = prefs != null && prefs.length == 3 && prefs[1].startsWith("#") && Display.getCurrent() != null ? new Color((Device)Display.getCurrent(), ColorHelper.toRGB((String)prefs[1])) : attr.getBackground();
        presentation.add(new StyleRange(offset, length, attr.getForeground(), bgColor, attr.getStyle()));
    }

    private void addJavaTextAttribute(String colorKey) {
        IPreferenceStore store = this.getJavaColorPreferences();
        if (store != null && colorKey != null) {
            TextAttribute ta = null;
            if (colorKey == "keyword") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_keyword");
                boolean bold = store.getBoolean("java_keyword_bold");
                boolean italics = store.getBoolean("java_keyword_italic");
                boolean strikethrough = store.getBoolean("java_keyword_strikethrough");
                boolean underline = store.getBoolean("java_keyword_underline");
                int style = 0;
                if (bold) {
                    style |= 1;
                }
                if (italics) {
                    style |= 2;
                }
                if (strikethrough) {
                    style |= 0x20000000;
                }
                if (underline) {
                    style |= 0x40000000;
                }
                ta = this.createTextAttribute(foreground, null, style);
            } else if (colorKey == "default") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_default");
                boolean bold = store.getBoolean("java_default_bold");
                boolean italics = store.getBoolean("java_default_italic");
                boolean strikethrough = store.getBoolean("java_default_strikethrough");
                boolean underline = store.getBoolean("java_default_underline");
                int style = 0;
                if (bold) {
                    style |= 1;
                }
                if (italics) {
                    style |= 2;
                }
                if (strikethrough) {
                    style |= 0x20000000;
                }
                if (underline) {
                    style |= 0x40000000;
                }
                ta = this.createTextAttribute(foreground, null, style);
            }
            if (ta != null) {
                this.getTextAttributes().put(colorKey, ta);
                this.fScanner.setTokenData(colorKey, ta);
            }
        }
    }

    private TextAttribute getTokenTextAttribute(IToken token) {
        TextAttribute ta = null;
        Object data = token.getData();
        ta = data instanceof TextAttribute ? (TextAttribute)data : (TextAttribute)this.getTextAttributes().get("default");
        return ta;
    }

    protected void loadColors() {
        this.addTextAttribute("SCRIPT_AREA_BORDER");
        this.addTextAttribute("tagAttributeName");
        this.addTextAttribute("tagAttributeValue");
        this.addJavaTextAttribute("keyword");
        this.addJavaTextAttribute("default");
        this.fScanner.initializeRules();
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String styleKey = null;
        String javaStyleKey = null;
        if (event != null) {
            String prefKey = event.getProperty();
            if ("SCRIPT_AREA_BORDER".equals(prefKey)) {
                styleKey = "SCRIPT_AREA_BORDER";
            } else if ("tagAttributeName".equals(prefKey)) {
                styleKey = "tagAttributeName";
            } else if ("tagAttributeValue".equals(prefKey)) {
                styleKey = "tagAttributeValue";
            } else if ("java_keyword".equals(prefKey) || "java_keyword_bold".equals(prefKey) || "java_keyword_italic".equals(prefKey)) {
                javaStyleKey = "keyword";
            } else if ("java_default".equals(prefKey) || "java_default_bold".equals(prefKey) || "java_default_italic".equals(prefKey)) {
                javaStyleKey = "default";
            }
        }
        if (styleKey != null) {
            this.addTextAttribute(styleKey);
        }
        if (javaStyleKey != null) {
            this.addJavaTextAttribute(javaStyleKey);
            this.fScanner.initializeRules();
        }
        if (styleKey != null || javaStyleKey != null) {
            this.fRecHighlighter.refreshDisplay();
        }
    }

    public boolean prepareRegions(ITypedRegion typedRegion, int ssssrequestedStart, int ssssrequestedLength, Collection holdResults) {
        boolean result = true;
        try {
            int offsetAdjustment = typedRegion.getOffset();
            String content = this.fDocument.get(typedRegion.getOffset(), typedRegion.getLength());
            Document document = new Document(content);
            int lastStart = 0;
            int length = 0;
            IToken lastToken = Token.UNDEFINED;
            int remainingLength = typedRegion.getLength();
            this.fScanner.setRange((IDocument)document, lastStart, remainingLength);
            while (true) {
                IToken token;
                if ((token = this.fScanner.nextToken()).isEOF()) {
                    if (!lastToken.isUndefined() && length != 0) {
                        this.addRange(holdResults, lastStart + offsetAdjustment, length, this.getTokenTextAttribute(lastToken));
                    }
                    break;
                }
                if (token.isWhitespace()) {
                    length += this.fScanner.getTokenLength();
                    continue;
                }
                if (lastToken.isUndefined()) {
                    lastToken = token;
                    length += this.fScanner.getTokenLength();
                    continue;
                }
                if (token != lastToken) {
                    this.addRange(holdResults, lastStart + offsetAdjustment, length, this.getTokenTextAttribute(lastToken));
                    lastToken = token;
                    lastStart = this.fScanner.getTokenOffset();
                    length = this.fScanner.getTokenLength();
                    continue;
                }
                length += this.fScanner.getTokenLength();
            }
        }
        catch (BadLocationException badLocationException) {
            result = false;
        }
        return result;
    }

    protected IPreferenceStore getColorPreferences() {
        return JSPUIPlugin.getDefault().getPreferenceStore();
    }

    private IPreferenceStore getJavaColorPreferences() {
        return PreferenceConstants.getPreferenceStore();
    }

    protected void registerPreferenceManager() {
        this.getColorPreferences().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.getJavaColorPreferences().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    protected void unRegisterPreferenceManager() {
        this.getColorPreferences().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.getJavaColorPreferences().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    protected TextAttribute getAttributeFor(ITextRegion region) {
        return null;
    }
}

