/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.queue;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.collection.MapTools;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class SynchronizedQueue<E>
implements Queue<E>,
Serializable {
    private final Queue<E> queue;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedQueue(Queue<E> queue, Object mutex) {
        if (queue == null || mutex == null) {
            throw new NullPointerException();
        }
        this.queue = queue;
        this.mutex = mutex;
    }

    public SynchronizedQueue(Queue<E> queue) {
        if (queue == null) {
            throw new NullPointerException();
        }
        this.queue = queue;
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(E element) {
        Object object = this.mutex;
        synchronized (object) {
            this.enqueue_(element);
        }
    }

    private void enqueue_(E element) {
        this.queue.enqueue(element);
        this.mutex.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E dequeue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.dequeue_();
        }
    }

    private E dequeue_() {
        E element = this.queue.dequeue();
        this.mutex.notifyAll();
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmptyIs(boolean empty) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(empty);
        }
    }

    private void waitUntilEmptyIs_(boolean empty) throws InterruptedException {
        while (this.queue.isEmpty() != empty) {
            this.mutex.wait();
        }
    }

    public void waitUntilEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(true);
    }

    public void waitUntilNotEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToEnqueue(E element) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(true);
            this.enqueue_(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitToDequeue() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(false);
            return this.dequeue_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmptyIs(boolean empty, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEmptyIs_(empty, timeout);
        }
    }

    private boolean waitUntilEmptyIs_(boolean empty, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilEmptyIs_(empty);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.queue.isEmpty() != empty && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.queue.isEmpty() == empty;
    }

    public boolean waitUntilEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(true, timeout);
    }

    public boolean waitUntilNotEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToEnqueue(E element, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(true, timeout);
            if (success) {
                this.enqueue_(element);
            }
            return success;
        }
    }

    public Object waitToDequeue(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(false, timeout);
            if (success) {
                return this.dequeue_();
            }
            throw new NoSuchElementException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    public boolean enqueueAll(Iterable<? extends E> iterable) {
        return this.enqueueAll(iterable.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueAll(Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueAll_(iterator);
        }
    }

    private boolean enqueueAll_(Iterator<? extends E> iterator) {
        do {
            this.queue.enqueue(iterator.next());
        } while (iterator.hasNext());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueAll(E ... array) {
        int len = array.length;
        if (len == 0) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueAll_(array, len);
        }
    }

    private boolean enqueueAll_(E[] array, int arrayLength) {
        int i = 0;
        do {
            this.queue.enqueue(array[i++]);
        } while (i < arrayLength);
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueAll(Stack<? extends E> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueAll_(stack);
        }
    }

    private boolean enqueueAll_(Stack<? extends E> stack) {
        do {
            this.queue.enqueue(stack.pop());
        } while (!stack.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueAll(Queue<? extends E> q) {
        if (q.isEmpty()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueAll_(q);
        }
    }

    private boolean enqueueAll_(Queue<? extends E> q) {
        do {
            this.queue.enqueue(q.dequeue());
        } while (!q.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    public ArrayList<E> drain() {
        ArrayList result = new ArrayList();
        this.drainTo(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainTo(Collection<? super E> collection) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTo_(collection);
        }
    }

    private boolean drainTo_(Collection<? super E> collection) {
        if (this.queue.isEmpty()) {
            return false;
        }
        return this.drainTo__(collection);
    }

    private boolean drainTo__(Collection<? super E> collection) {
        do {
            collection.add(this.queue.dequeue());
        } while (!this.queue.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainTo(List<? super E> list, int index) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTo_(list, index);
        }
    }

    private boolean drainTo_(List<? super E> list, int index) {
        if (this.queue.isEmpty()) {
            return false;
        }
        if (index == list.size()) {
            return this.drainTo__(list);
        }
        ArrayList temp = new ArrayList();
        this.drainTo__(temp);
        list.addAll(index, temp);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainTo(Stack<? super E> stack) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTo_(stack);
        }
    }

    private boolean drainTo_(Stack<? super E> stack) {
        if (this.queue.isEmpty()) {
            return false;
        }
        do {
            stack.push(this.queue.dequeue());
        } while (!this.queue.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainTo(Queue<? super E> q) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTo_(q);
        }
    }

    private boolean drainTo_(Queue<? super E> q) {
        if (this.queue.isEmpty()) {
            return false;
        }
        do {
            q.enqueue(this.queue.dequeue());
        } while (!this.queue.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> boolean drainTo(Map<K, ? super E> map, Transformer<? super E, ? extends K> keyTransformer) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTo_(map, keyTransformer);
        }
    }

    private <K> boolean drainTo_(Map<K, ? super E> map, Transformer<? super E, ? extends K> keyTransformer) {
        if (this.queue.isEmpty()) {
            return false;
        }
        do {
            MapTools.add(map, this.queue.dequeue(), keyTransformer);
        } while (!this.queue.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> boolean drainTo(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTo_(map, keyTransformer, valueTransformer);
        }
    }

    private <K, V> boolean drainTo_(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        if (this.queue.isEmpty()) {
            return false;
        }
        do {
            MapTools.add(map, this.queue.dequeue(), keyTransformer, valueTransformer);
        } while (!this.queue.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

