/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.tests.search.AbstractSearchTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Type Search only implemented for ES6 syntax")
public class TestTypeDeclarationPattern
extends AbstractSearchTest {
    protected TypeNameMatch[] runTypeSearchTest(String projectQualifier, String queryString, String[] fileNames, String[] fileSources, int searchFor, int matchRule) throws Exception {
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.setupMinimalProject(String.valueOf(this.getRootProjectName()) + projectQualifier, fileNames, fileSources)});
        final ArrayList results = new ArrayList();
        SearchEngine searchEngine = new SearchEngine();
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                results.add(match);
            }
        };
        searchEngine.searchAllTypeNames(queryString.toCharArray(), matchRule, searchFor, scope, requestor, 3, (IProgressMonitor)new NullProgressMonitor());
        return results.toArray(new TypeNameMatch[results.size()]);
    }

    @Test
    public void testTypeDeclarationPatternMatch01() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "at*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)3L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch02() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "apack*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)3L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch03() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "a*e.b*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch04() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "a*.a*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch05() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "a*.s*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.sTest = function() {\n\tthis.s = 5;\n}\napackage.subpackage.aTest3 = function() {\n\tthis.s = 5;\n}\n"}, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch06() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "a*.s*.*t", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.sTest = function() {\n\tthis.s = 5;\n}\napackage.subpackage.bTest = function() {\n\tthis.s = 5;\n}\napackage.subpackage.aTest2 = function() {\n\tthis.s = 5;\n}\n"}, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch07() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "*.A*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch8() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "APACK*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)3L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch09() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "apack.a", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 1);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)0L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch10() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "apackage.a", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 1);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch11() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "APACK", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 1);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)3L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationPatternMatch12() throws Exception {
        TypeNameMatch[] results = this.runTypeSearchTest(this.getName(), "apackage.a", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\nAPACKAGE.ATEST2 = function() {\n\tthis.s = 5;\n}\nAPACKAGE.aTest3 = function() {\n\tthis.s = 5;\n}\nAPACKAGE.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 1);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "apack*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)3L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationSearch02() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "*.a*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\napackage.bTest = function() {\n\tthis.s = 5;\n}\n"}, 0, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationSearch03() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "APACKAGE.a*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\naTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\nAPACKAGE.aTest4 = function() {\n\tthis.s = 5;\n}\n"}, 0, 0, 10);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationSearch04() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "at*", new String[]{"X.js"}, new String[]{"aTest1 = function() {\n\tthis.s = 5;\n}\napackage.aTest2 = function() {\n\tthis.s = 5;\n}\napackage.aTest3 = function() {\n\tthis.s = 5;\n}\n"}, 0, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)3L, (long)results.length);
    }

    @Test
    public void testTypeDeclarationSearch05() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "TTD", new String[]{"X.js"}, new String[]{"apackage.TestTypeDeclaration1 = function() {\n\tthis.s = 5;\n}\napackage.TestTypeDeclaration2 = function() {\n\tthis.s = 5;\n}\napackage.TestTypeDeclaration3 = function() {\n\tthis.s = 5;\n}\n"}, 0, 0, 128);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)3L, (long)results.length);
    }
}

