/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.modelquery;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.contentmodel.JSPCMDocumentFactory;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.html.core.internal.contentmodel.JSPCMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.extension.ModelQueryExtension;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPModelQueryExtension
extends ModelQueryExtension {
    private static final String TAG_JSP_ROOT = "jsp:root";

    public CMNode[] getAvailableElementContent(Element parentElement, String namespace, int includeOptions) {
        CMNode[] nodes = EMPTY_CMNODE_ARRAY;
        ArrayList<Object> nodeList = new ArrayList<Object>();
        if ((includeOptions & 2) != 0 && parentElement instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)parentElement;
            ModelQueryAdapter mqAdapter = null;
            mqAdapter = node.getNodeType() == 9 ? (ModelQueryAdapter)node.getAdapterFor(ModelQueryAdapter.class) : (ModelQueryAdapter)((IDOMNode)node.getOwnerDocument()).getAdapterFor(ModelQueryAdapter.class);
            if (mqAdapter != null) {
                CMDocument doc = mqAdapter.getModelQuery().getCorrespondingCMDocument((Node)node);
                if (doc != null) {
                    CMDocument jcmdoc = this.getDefaultJSPCMDocument(node);
                    CMNamedNodeMap jspelements = jcmdoc.getElements();
                    if (!(jspelements == null || doc instanceof JSPCMDocument && node.getNodeType() != 9)) {
                        Element docElement;
                        ArrayList<String> rejectElements = new ArrayList<String>();
                        Document domDoc = null;
                        domDoc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
                        rejectElements.add("jsp:scriptlet");
                        rejectElements.add("jsp:expression");
                        rejectElements.add("jsp:declaration");
                        rejectElements.add("jsp:directive.include");
                        rejectElements.add("jsp:directive.page");
                        rejectElements.add("jsp:text");
                        rejectElements.add("jsp:directive.taglib");
                        rejectElements.add("jsp:directive.tag");
                        rejectElements.add("jsp:directive.attribute");
                        rejectElements.add("jsp:directive.variable");
                        if (this.isXMLFormat(domDoc)) {
                            rejectElements.add("jsp:fallback");
                            rejectElements.add("jsp:useBean");
                            rejectElements.add("jsp:getProperty");
                            rejectElements.add("jsp:setProperty");
                            rejectElements.add("jsp:include");
                            rejectElements.add("jsp:forward");
                            rejectElements.add("jsp:plugin");
                            rejectElements.add("jsp:fallback");
                            rejectElements.add("jsp:param");
                            rejectElements.add("jsp:params");
                        }
                        if ((docElement = domDoc.getDocumentElement()) != null && (docElement.getNodeName().equals(TAG_JSP_ROOT) || ((IDOMNode)docElement).getStartStructuredDocumentRegion() != null || ((IDOMNode)docElement).getEndStructuredDocumentRegion() != null)) {
                            rejectElements.add(TAG_JSP_ROOT);
                        }
                        int j = 0;
                        while (j < jspelements.getLength()) {
                            CMElementDeclaration ed = (CMElementDeclaration)jspelements.item(j);
                            if (!rejectElements.contains(ed.getNodeName())) {
                                nodeList.add(ed);
                            }
                            ++j;
                        }
                    }
                } else {
                    CMNamedNodeMap jspElements = this.getDefaultJSPCMDocument(node).getElements();
                    int length = jspElements.getLength();
                    int i = 0;
                    while (i < length) {
                        nodeList.add(jspElements.item(i));
                        ++i;
                    }
                }
            }
            nodes = nodeList.toArray(new CMNode[nodeList.size()]);
        }
        return nodes;
    }

    private CMDocument getDefaultJSPCMDocument(IDOMNode node) {
        CMDocument jcmdoc = null;
        String contentType = node.getModel().getContentTypeIdentifier();
        if (ContentTypeIdForJSP.ContentTypeID_JSPTAG.equals(contentType)) {
            jcmdoc = JSPCMDocumentFactory.getCMDocument("JSP20.TAG");
        } else {
            String modelPath = node.getModel().getBaseLocation();
            if (modelPath != null && !"org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL".equals(modelPath)) {
                float version = DeploymentDescriptorPropertyCache.getInstance().getJSPVersion((IPath)new Path(modelPath));
                jcmdoc = JSPCMDocumentFactory.getCMDocument(version);
            }
            if (jcmdoc == null) {
                jcmdoc = JSPCMDocumentFactory.getCMDocument();
            }
        }
        return jcmdoc;
    }

    private boolean isXMLFormat(Document doc) {
        boolean result = false;
        if (doc != null) {
            Element docElement = doc.getDocumentElement();
            result = docElement != null && (docElement.getNodeName().equals(TAG_JSP_ROOT) || ((IDOMNode)docElement).getStartStructuredDocumentRegion() == null && ((IDOMNode)docElement).getEndStructuredDocumentRegion() == null);
        }
        return result;
    }
}

