/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.jspel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ELGenerator;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.core.internal.java.jspel.TokenMgrError;
import org.eclipse.jst.jsp.core.jspel.ELProblem;
import org.eclipse.jst.jsp.core.jspel.IJSPELTranslator;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;

public class JSPELTranslator
implements IJSPELTranslator {
    private static final String PREFERENCE_NODE_QUALIFIER = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
    private JSPELParser elParser = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ELProblem> translateEL(String elText, String delim, IStructuredDocumentRegion currentNode, int contentStart, int contentLength, StringBuffer fUserELExpressions, HashMap fUserELRanges, IStructuredDocument document) {
        ArrayList<ELProblem> elProblems;
        block9: {
            elProblems = new ArrayList<ELProblem>();
            try {
                JSPELTranslator jSPELTranslator = this;
                synchronized (jSPELTranslator) {
                    if (this.elParser == null) {
                        this.elParser = JSPELParser.createParser(elText);
                    } else {
                        this.elParser.ReInit(elText);
                    }
                    ASTExpression expression = this.elParser.Expression();
                    ELGenerator gen = new ELGenerator();
                    List generatorELProblems = gen.generate(expression, currentNode, fUserELExpressions, fUserELRanges, document, (ITextRegionCollection)currentNode, contentStart, contentLength);
                    elProblems.addAll(generatorELProblems);
                }
            }
            catch (ParseException e) {
                int sev = this.getProblemSeverity("validation.el-general-syntax", this.getScopeContexts(document));
                if (sev != -1) {
                    Token curTok = e.currentToken;
                    Position pos = null;
                    int problemStartOffset = contentStart + curTok.beginColumn;
                    int problemEndOffset = contentStart + curTok.endColumn;
                    pos = new Position(problemStartOffset, problemEndOffset - problemStartOffset + 1);
                    elProblems.add(new ELProblem(sev, pos, e.getLocalizedMessage()));
                }
            }
            catch (TokenMgrError tokenMgrError) {
                int sev = this.getProblemSeverity("validation.el-lexical-failure", this.getScopeContexts(document));
                if (sev == -1) break block9;
                Position pos = new Position(contentStart, contentLength);
                elProblems.add(new ELProblem(sev, pos, JSPCoreMessages.JSPEL_Token));
            }
        }
        return elProblems;
    }

    private int getProblemSeverity(String key, IScopeContext[] contexts) {
        return Platform.getPreferencesService().getInt(PREFERENCE_NODE_QUALIFIER, key, 2, contexts);
    }

    private IScopeContext[] getScopeContexts(IStructuredDocument document) {
        ProjectScope projectScope;
        IProject project;
        IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        IFile file = this.getFile(document);
        if (file != null && file.exists() && (project = file.getProject()).exists() && (projectScope = new ProjectScope(project)).getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("validation.use-project-settings", false)) {
            scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        return scopes;
    }

    private IFile getFile(IStructuredDocument document) {
        IFile f = null;
        ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer((IDocument)document);
        if (buffer != null) {
            IPath path = buffer.getLocation();
            if (path.segmentCount() > 1) {
                f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
            if (f != null && f.isAccessible()) {
                return f;
            }
        }
        return null;
    }
}

