/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal.provisional;

import java.util.Date;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.internet.monitor.core.internal.Monitor;
import org.eclipse.wst.internet.monitor.core.internal.Trace;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;

public class Request
implements IAdaptable {
    protected Monitor monitor;
    protected Date date;
    protected long responseTime = -1L;
    protected int localPort;
    protected String remoteHost;
    protected int remotePort;
    protected byte[] request;
    protected byte[] response;
    protected String name;
    protected String protocolId;
    protected Properties properties;
    public static final int TRANSPORT = 1;
    public static final int CONTENT = 2;
    public static final int ALL = 3;

    public Request(Monitor monitor, String protocolId, int localPort, String remoteHost, int remotePort) {
        this.monitor = monitor;
        this.protocolId = protocolId;
        this.localPort = localPort;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.date = new Date();
        this.properties = new Properties();
        if (monitor != null) {
            monitor.addRequest(this);
        }
    }

    public String getProtocol() {
        return this.protocolId;
    }

    public Date getDate() {
        return this.date;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public byte[] getRequest(int type) {
        return this.request;
    }

    public byte[] getResponse(int type) {
        return this.response;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public String getName() {
        if (this.name == null) {
            return this.getRemoteHost() + ":" + this.getRemotePort();
        }
        return this.name;
    }

    protected void setName(String n) {
        this.name = n;
    }

    public void setProperty(String key, Object value) {
        block4: {
            try {
                if (this.properties.containsKey(key)) {
                    this.properties.remove(key);
                }
                if (value != null) {
                    this.properties.put(key, value);
                }
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block4;
                Trace.trace("/severe", "Could not add property", e);
            }
        }
        this.monitor.requestChanged(this);
    }

    public Object getProperty(String key) {
        try {
            return this.properties.get(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addToRequest(byte[] addRequest) {
        if (addRequest == null || addRequest.length == 0) {
            return;
        }
        if (this.request == null || this.request.length == 0) {
            this.setRequest(addRequest);
            return;
        }
        int size = this.request.length + addRequest.length;
        byte[] b = new byte[size];
        System.arraycopy(this.request, 0, b, 0, this.request.length);
        System.arraycopy(addRequest, 0, b, this.request.length, addRequest.length);
        this.request = b;
        this.fireChangedEvent();
    }

    public void addToResponse(byte[] addResponse) {
        if (addResponse == null || addResponse.length == 0) {
            return;
        }
        if (this.response == null || this.response.length == 0) {
            this.setResponse(addResponse);
            return;
        }
        int size = this.response.length + addResponse.length;
        byte[] b = new byte[size];
        System.arraycopy(this.response, 0, b, 0, this.response.length);
        System.arraycopy(addResponse, 0, b, this.response.length, addResponse.length);
        this.response = b;
        this.fireChangedEvent();
    }

    protected void setRequest(byte[] request) {
        if (request == null || request.length == 0) {
            return;
        }
        this.request = request;
        this.monitor.requestChanged(this);
    }

    protected void setResponse(byte[] response) {
        if (response == null || response.length == 0) {
            return;
        }
        this.response = response;
        this.responseTime = System.currentTimeMillis() - this.date.getTime();
        this.monitor.requestChanged(this);
    }

    public IMonitor getMonitor() {
        return this.monitor;
    }

    protected void fireChangedEvent() {
        if (this.monitor != null) {
            this.monitor.requestChanged(this);
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

