/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.gen.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.ConvertLineDelimitersOperation;
import org.eclipse.core.filebuffers.manipulation.FileBufferOperationRunner;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.gen.JptJpaGenMessages;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.gen.internal.ORMGenTable;
import org.eclipse.jpt.jpa.gen.internal.OverwriteConfirmer;
import org.eclipse.jpt.jpa.gen.internal.plugin.JptJpaGenPlugin;
import org.eclipse.jpt.jpa.gen.internal.util.CompilationUnitModifier;
import org.eclipse.jpt.jpa.gen.internal.util.FileUtil;
import org.eclipse.jpt.jpa.gen.internal.util.UrlUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class PackageGenerator {
    private static final String LOGGER_NAME = "org.eclipse.jpt.entities.gen.log";
    private final JpaProject jpaProject;
    private final ORMGenCustomizer customizer;
    private final OverwriteConfirmer overwriteConfirmer;

    public static void generate(JpaProject jpaProject, ORMGenCustomizer customizer, OverwriteConfirmer overwriteConfirmer, IProgressMonitor monitor, boolean generateXml) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        PackageGenerator generator = new PackageGenerator(jpaProject, customizer, overwriteConfirmer);
        sm.worked(1);
        try {
            if (generateXml) {
                generator.doXmlGenerate((IProgressMonitor)sm.newChild(19));
            } else {
                generator.doGenerate((IProgressMonitor)sm.newChild(19));
            }
        }
        catch (Exception e) {
            throw new CoreException(JptJpaGenPlugin.instance().buildErrorStatus(e, JptJpaGenMessages.ERROR_GENERATING_ENTITIES));
        }
    }

    private PackageGenerator(JpaProject jpaProject, ORMGenCustomizer customizer, OverwriteConfirmer confirmer) {
        this.jpaProject = jpaProject;
        this.customizer = customizer;
        this.overwriteConfirmer = confirmer;
    }

    private Object getCustomizer() {
        return this.customizer;
    }

    private IJavaProject getJavaProject() {
        return this.jpaProject.getJavaProject();
    }

    protected void doGenerate(IProgressMonitor monitor) throws Exception {
        this.generateInternal(monitor);
    }

    protected void doXmlGenerate(IProgressMonitor monitor) throws Exception {
        this.generateXmlInternal(monitor);
    }

    protected void generateInternal(IProgressMonitor monitor) throws Exception {
        File templDir = this.prepareTemplatesFolder("templates/entities/");
        ArrayList<String> genClasses = new ArrayList<String>();
        List<String> tableNames = this.customizer.getGenTableNames();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(tableNames.size() + 2));
        Iterator<String> iter = tableNames.iterator();
        while (iter.hasNext()) {
            if (sm.isCanceled()) {
                return;
            }
            String tableName = iter.next();
            ORMGenTable table = this.customizer.getTable(tableName);
            String className = table.getQualifiedClassName();
            this.generateClass(table, templDir.getAbsolutePath(), (IProgressMonitor)sm.newChild(1, 0));
            genClasses.add(className);
            if (!table.isCompositeKey()) continue;
            genClasses.add(table.getQualifiedCompositeKeyClassName());
        }
        if (sm.isCanceled()) {
            return;
        }
        if (this.customizer.updatePersistenceXml()) {
            this.updatePersistenceXml(genClasses);
        }
        sm.worked(2);
    }

    private void updatePersistenceXml(List<String> genClasses) {
        PersistenceUnit persistenceUnit;
        JptXmlResource resource = this.jpaProject.getPersistenceXmlResource();
        if (resource == null) {
            return;
        }
        Persistence persistence = this.jpaProject.getContextRoot().getPersistenceXml().getRoot();
        if (persistence == null) {
            return;
        }
        if (persistence.getPersistenceUnitsSize() == 0) {
            persistenceUnit = persistence.addPersistenceUnit();
            persistenceUnit.setName(this.jpaProject.getName());
        } else {
            persistenceUnit = persistence.getPersistenceUnit(0);
        }
        for (String className : genClasses) {
            if (!IterableTools.isEmpty((Iterable)persistenceUnit.getMappingFileRefsContaining(className)) || persistenceUnit.specifiesManagedType(className)) continue;
            persistenceUnit.addSpecifiedClassRef(className);
        }
        resource.save();
    }

    protected void generateXmlInternal(IProgressMonitor monitor) throws Exception {
        File templDir = this.prepareTemplatesFolder("templates/xml_entities/");
        List<String> tableNames = this.customizer.getGenTableNames();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(tableNames.size() + 2));
        this.generateXmlMappingFile(tableNames, templDir.getAbsolutePath(), (IProgressMonitor)sm.newChild(1, 0));
        if (sm.isCanceled()) {
            return;
        }
        this.updatePersistenceXmlForMappingFile(this.customizer.getXmlMappingFile());
        sm.worked(2);
    }

    private File prepareTemplatesFolder(String templatesPath) throws IOException, Exception, CoreException {
        Path path;
        Bundle bundle = JptJpaGenPlugin.instance().getBundle();
        URL url = FileLocator.find((Bundle)bundle, (IPath)(path = new Path(templatesPath)), null);
        if (url == null) {
            throw new CoreException(JptJpaGenPlugin.instance().buildErrorStatus(JptJpaGenMessages.TEMPLATES_NOT_FOUND));
        }
        URL templUrl = FileLocator.resolve((URL)url);
        File templDir = null;
        templDir = UrlUtil.isJarUrl(templUrl) ? FileUtil.extractFilesFromBundle(templUrl, bundle, templatesPath) : UrlUtil.getUrlFile(templUrl);
        if (templDir == null || !templDir.exists()) {
            throw new CoreException(JptJpaGenPlugin.instance().buildErrorStatus(JptJpaGenMessages.TEMPLATES_NOT_FOUND));
        }
        return templDir;
    }

    private void updatePersistenceXmlForMappingFile(String mappingFile) {
        PersistenceUnit persistenceUnit;
        JptXmlResource resource = this.jpaProject.getPersistenceXmlResource();
        if (resource == null) {
            return;
        }
        Persistence persistence = this.jpaProject.getContextRoot().getPersistenceXml().getRoot();
        if (persistence == null) {
            return;
        }
        if (persistence.getPersistenceUnitsSize() == 0) {
            persistenceUnit = persistence.addPersistenceUnit();
            persistenceUnit.setName(this.jpaProject.getName());
        } else {
            persistenceUnit = persistence.getPersistenceUnit(0);
        }
        boolean addSpecifiedMappingFile = true;
        for (MappingFileRef mappingFileRef : persistenceUnit.getMappingFileRefs()) {
            if (!mappingFileRef.getFileName().equals(mappingFile)) continue;
            addSpecifiedMappingFile = false;
        }
        if (addSpecifiedMappingFile) {
            persistenceUnit.addSpecifiedMappingFileRef(mappingFile);
            resource.save();
        }
    }

    protected void generateClass(ORMGenTable table, String templateDirPath, IProgressMonitor monitor) throws Exception {
        String subTaskName = NLS.bind((String)JptJpaGenMessages.ENTITY_GENERATOR_TASK_NAME, (Object)table.getName());
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)subTaskName, (int)10);
        try {
            IFolder javaPackageFolder = this.getJavaPackageFolder(table, monitor);
            IFile javaFile = javaPackageFolder.getFile(table.getClassName() + ".java");
            if (javaFile.exists() && this.overwriteConfirmer != null && !this.overwriteConfirmer.overwrite(javaFile.getName())) {
                return;
            }
            Logger logger = Logger.getLogger(LOGGER_NAME);
            logger.setLevel(Level.SEVERE);
            Properties vep = new Properties();
            vep.setProperty("file.resource.loader.path", templateDirPath);
            vep.setProperty("runtime.log.logsystem.jdk.logger", LOGGER_NAME);
            VelocityEngine ve = new VelocityEngine();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ve.getClass().getClassLoader());
            try {
                ve.init(vep);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            sm.worked(2);
            this.generateJavaFile(table, javaFile, ve, "main.java.vm", true, (IProgressMonitor)sm.newChild(6));
            if (table.isCompositeKey()) {
                IFile compositeKeyFile = javaPackageFolder.getFile(table.getCompositeKeyClassName() + ".java");
                this.generateJavaFile(table, compositeKeyFile, ve, "pk.java.vm", false, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.setWorkRemaining(1);
            }
            javaFile.refreshLocal(1, (IProgressMonitor)sm.newChild(1));
        }
        catch (Throwable e) {
            JptJpaGenPlugin.instance().logError(e, JptJpaGenMessages.ERROR_GENERATING_ENTITIES);
        }
    }

    private void generateJavaFile(ORMGenTable table, IFile javaFile, VelocityEngine ve, String templateName, boolean isDomainClass, IProgressMonitor monitor) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("table", (Object)table);
        context.put("customizer", this.getCustomizer());
        StringWriter w = new StringWriter();
        String charset = javaFile.getCharset();
        charset = this.checkCharsetAndFallbackToUTF8IfNecessary(charset);
        ve.mergeTemplate(templateName, charset, (Context)context, (Writer)w);
        String fileContent = w.toString();
        if (javaFile.exists()) {
            if (isDomainClass) {
                this.updateExistingDomainClass(table.getQualifiedClassName(), javaFile, fileContent);
            } else {
                byte[] content = fileContent.getBytes(javaFile.getCharset());
                javaFile.setContents((InputStream)new ByteArrayInputStream(content), true, true, monitor);
            }
        } else {
            byte[] content = fileContent.getBytes(javaFile.getCharset());
            this.createFile(javaFile, new ByteArrayInputStream(content));
        }
        PackageGenerator.convertLineDelimiter(javaFile);
    }

    private String checkCharsetAndFallbackToUTF8IfNecessary(String charset) {
        try {
            Charset.forName(charset);
        }
        catch (Exception e) {
            JptJpaGenPlugin.instance().log(2, e, "Failed to find charset " + charset + " , falling back to UTF-8");
            charset = StandardCharsets.UTF_8.name();
        }
        return charset;
    }

    protected void updateExistingDomainClass(String className, IFile javaFile, String fileContent) throws Exception {
        CompilationUnitModifier modifier = new CompilationUnitModifier(this.getJavaProject(), className);
        modifier.setJavaSource(fileContent);
        modifier.save();
    }

    public void createFile(IFile file, InputStream contents) throws CoreException {
        file.create(contents, false, null);
    }

    public IFolder getJavaPackageFolder(ORMGenTable table, IProgressMonitor monitor) throws CoreException {
        IPackageFragment packageFragment;
        IPackageFragmentRoot root = this.getDefaultJavaSourceLocation(this.getJavaProject(), table.getSourceFolder());
        String packageName = table.getPackage();
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageFragment = root.getPackageFragment(packageName)).exists()) {
            root.createPackageFragment(packageName, true, monitor);
        }
        return (IFolder)packageFragment.getResource();
    }

    private IPackageFragmentRoot getDefaultJavaSourceLocation(IJavaProject jproject, String sourceFolder) {
        IPackageFragmentRoot defaultSrcPath = null;
        if (jproject != null && jproject.exists()) {
            try {
                IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        String path;
                        if (defaultSrcPath == null) {
                            defaultSrcPath = roots[i];
                        }
                        if ((path = roots[i].getPath().toString()).equals("/" + sourceFolder)) {
                            return roots[i];
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JptJpaGenPlugin.instance().logError(e);
            }
        }
        return defaultSrcPath;
    }

    protected void generateXmlMappingFile(List<String> tableNames, String templateDirPath, IProgressMonitor monitor) throws Exception {
        try {
            IFile xmlFile;
            String xmlMappingFileLocation = this.customizer.getXmlMappingFile();
            JptXmlResource xmlResource = this.jpaProject.getMappingFileXmlResource((IPath)new Path(xmlMappingFileLocation));
            if (xmlResource != null) {
                xmlFile = xmlResource.getFile();
            } else {
                IProject project = this.jpaProject.getProject();
                IContainer container = ((ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class)).getDefaultLocation();
                xmlFile = container.getFile((IPath)new Path(xmlMappingFileLocation.substring(xmlMappingFileLocation.lastIndexOf("/"))));
            }
            if (xmlFile.exists() && this.overwriteConfirmer != null && !this.overwriteConfirmer.overwrite(xmlFile.getName())) {
                return;
            }
            Logger logger = Logger.getLogger(LOGGER_NAME);
            logger.setLevel(Level.SEVERE);
            Properties vep = new Properties();
            vep.setProperty("file.resource.loader.path", templateDirPath);
            vep.setProperty("runtime.log.logsystem.jdk.logger", LOGGER_NAME);
            VelocityEngine ve = new VelocityEngine();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ve.getClass().getClassLoader());
            try {
                ve.init(vep);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            String charset = xmlFile.getCharset();
            charset = this.checkCharsetAndFallbackToUTF8IfNecessary(charset);
            StringBuilder xmlFileContents = new StringBuilder();
            xmlFileContents.append(this.generateXmlHeaderFooter(ve, "header.vm", charset));
            Iterator<String> names = tableNames.iterator();
            while (names.hasNext()) {
                ORMGenTable table = this.customizer.getTable(names.next());
                xmlFileContents.append(this.generateXmlTypeMetadata(table, ve, "namedQuery.vm", charset));
            }
            ArrayList<ORMGenTable> compositeKeyTables = new ArrayList<ORMGenTable>();
            Iterator<String> names2 = tableNames.iterator();
            while (names2.hasNext()) {
                ORMGenTable table = this.customizer.getTable(names2.next());
                String subTaskName = NLS.bind((String)JptJpaGenMessages.ENTITY_GENERATOR_TASK_NAME, (Object)table.getName());
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)subTaskName, (int)10);
                if (sm.isCanceled()) {
                    return;
                }
                xmlFileContents.append(this.generateXmlTypeMetadata(table, ve, "main.xml.vm", charset));
                if (!table.isCompositeKey()) continue;
                compositeKeyTables.add(table);
            }
            for (ORMGenTable table : compositeKeyTables) {
                SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)JptJpaGenMessages.ENTITY_GENERATOR_TASK_NAME, (Object)table.getName()), (int)1);
                if (!table.isCompositeKey()) continue;
                xmlFileContents.append(this.generateXmlTypeMetadata(table, ve, "embeddable.vm", charset));
            }
            xmlFileContents.append(this.generateXmlHeaderFooter(ve, "footer.vm", charset));
            if (xmlFile.exists()) {
                content = xmlFileContents.toString().getBytes(xmlFile.getCharset());
                xmlFile.setContents((InputStream)new ByteArrayInputStream(content), false, true, null);
            } else {
                content = xmlFileContents.toString().getBytes(xmlFile.getCharset());
                this.createFile(xmlFile, new ByteArrayInputStream(content));
            }
            xmlFile.refreshLocal(1, null);
        }
        catch (Throwable e) {
            JptJpaGenPlugin.instance().logError(e, JptJpaGenMessages.ERROR_GENERATING_ENTITIES);
        }
    }

    private String generateXmlHeaderFooter(VelocityEngine ve, String templateName, String charset) throws Exception {
        StringWriter stringWriter = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("customizer", this.getCustomizer());
        ve.mergeTemplate(templateName, charset, (Context)context, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private String generateXmlTypeMetadata(ORMGenTable table, VelocityEngine ve, String templateName, String charset) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("table", (Object)table);
        context.put("customizer", this.getCustomizer());
        StringWriter w = new StringWriter();
        ve.mergeTemplate(templateName, charset, (Context)context, (Writer)w);
        return w.toString();
    }

    private static void convertLineDelimiter(IFile file) {
        IPath[] paths = new IPath[]{file.getFullPath()};
        ITextFileBufferManager buffManager = FileBuffers.getTextFileBufferManager();
        String lineDelimiter = PlatformTools.getNewTextFileLineDelimiter();
        ConvertLineDelimitersOperation convertOperation = new ConvertLineDelimitersOperation(lineDelimiter);
        FileBufferOperationRunner runner = new FileBufferOperationRunner((IFileBufferManager)buffManager, null);
        try {
            runner.execute(paths, (IFileBufferOperation)convertOperation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException oce) {
            JptJpaGenPlugin.instance().logError(oce);
        }
        catch (CoreException ce) {
            JptJpaGenPlugin.instance().logError(ce);
        }
    }
}

