/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.jsdt.chromium.debug.ui.DialogUtils;

public class WizardUtils {

    public static class LogicBasedWizard
    extends Wizard {
        private final WizardPageSet pageSet;
        private WizardFinisher wizardFinisher = null;
        private UpdateButtonsState updateButtonsState = UpdateButtonsState.NOT_READY;
        private DialogUtils.Message currentLogicMessage = DialogUtils.NULL_MESSAGE;
        private WizardLogic logic;
        private PageImpl<?> startingPage = null;

        public LogicBasedWizard(WizardPageSet pageSet) {
            this.pageSet = pageSet;
            for (PageImpl<?> page : pageSet.getAllPages()) {
                this.addPage((IWizardPage)page);
            }
        }

        DialogUtils.Message getLogicMessage() {
            return this.currentLogicMessage;
        }

        public void createPageControls(Composite pageContainer) {
            super.createPageControls(pageContainer);
            this.logic = this.pageSet.createLogic(this);
            this.startingPage = this.logic.getStartingPage();
            this.logic.updateAll();
            this.updateButtonsState = UpdateButtonsState.SHOULD_BE_READY;
        }

        public boolean performFinish() {
            if (this.wizardFinisher == null) {
                return false;
            }
            final boolean[] result = new boolean[1];
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    result[0] = wizardFinisher.performFinish((IWizard)this, monitor);
                }
            };
            try {
                this.getContainer().run(false, true, runnable);
                return result[0];
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean canFinish() {
            return this.wizardFinisher != null;
        }

        public IWizardPage getNextPage(IWizardPage page) {
            PageImpl pageImpl = (PageImpl)page;
            return pageImpl.getNextPageImpl();
        }

        public IWizardPage getPreviousPage(IWizardPage page) {
            PageImpl pageImpl = (PageImpl)page;
            return pageImpl.getPreviousPageImpl();
        }

        public IWizardPage getStartingPage() {
            return this.startingPage;
        }

        public void setWizardFinisher(WizardFinisher wizardFinisher, DialogUtils.Message message) {
            this.wizardFinisher = wizardFinisher;
            this.currentLogicMessage = message;
            this.updateButtons();
        }

        void updateButtons() {
            if (this.updateButtonsState == UpdateButtonsState.SHOULD_BE_READY) {
                this.getContainer().updateButtons();
                this.getContainer().updateMessage();
            }
        }

        public void dispose() {
            if (this.logic != null) {
                this.logic.dispose();
            }
            super.dispose();
        }

        private static enum UpdateButtonsState {
            NOT_READY,
            SHOULD_BE_READY;

        }
    }

    public static class NextPageEnabler
    implements DialogUtils.ScopeEnabler {
        private final PageImpl<?> basePage;
        private final PageImpl<?> nextPage;

        public NextPageEnabler(PageImpl<?> basePage, PageImpl<?> nextPage) {
            this.basePage = basePage;
            this.nextPage = nextPage;
        }

        @Override
        public void setEnabled(boolean enabled, boolean recursive) {
            if (enabled) {
                this.basePage.linkToNextPage(this.nextPage);
            } else {
                this.basePage.unlinkFromNextPage(this.nextPage);
            }
        }
    }

    public static interface PageElements {
        public Control getMainControl();
    }

    public static interface PageElementsFactory<T extends PageElements> {
        public T create(Composite var1);
    }

    public static class PageImpl<PE extends PageElements>
    extends WizardPage {
        private PE pageElements = null;
        private final PageElementsFactory<PE> factory;
        private PageImpl<?> previousPage = null;
        private PageImpl<?> nextPage = null;
        private List<PageListener> listeners = new ArrayList<PageListener>(0);

        public PageImpl(String pageName, PageElementsFactory<PE> factory, String title, String description) {
            super(pageName, title, null);
            this.factory = factory;
            this.setDescription(description);
        }

        public void createControl(Composite parent) {
            this.pageElements = this.factory.create(parent);
            this.setControl(this.pageElements.getMainControl());
        }

        public IWizardPage getPreviousPageImpl() {
            return this.previousPage;
        }

        public IWizardPage getNextPageImpl() {
            return this.nextPage;
        }

        public void setVisible(boolean visible) {
            for (PageListener listener : this.listeners) {
                listener.onSetVisible(visible);
            }
            super.setVisible(visible);
        }

        public void addListener(PageListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(PageListener listener) {
            this.listeners.remove(listener);
        }

        public PE getPageElements() {
            return this.pageElements;
        }

        public void linkToNextPage(PageImpl<?> next) {
            if (next != null) {
                next.previousPage = this;
            }
            this.nextPage = next;
            LogicBasedWizard wizardImpl = (LogicBasedWizard)this.getWizard();
            wizardImpl.updateButtons();
        }

        public void unlinkFromNextPage(PageImpl<?> next) {
            if (next != null && this.nextPage == next) {
                next.previousPage = null;
                this.nextPage = null;
            }
            LogicBasedWizard wizardImpl = (LogicBasedWizard)this.getWizard();
            wizardImpl.updateButtons();
        }

        public String getMessage() {
            LogicBasedWizard wizardImpl = (LogicBasedWizard)this.getWizard();
            return wizardImpl.getLogicMessage().getText();
        }

        public int getMessageType() {
            LogicBasedWizard wizardImpl = (LogicBasedWizard)this.getWizard();
            return wizardImpl.getLogicMessage().getPriority().getMessageProviderType();
        }
    }

    public static interface PageListener {
        public void onSetVisible(boolean var1);
    }

    public static class WizardFinishController
    implements DialogUtils.ValueConsumer {
        private final DialogUtils.ValueSource<? extends DialogUtils.Optional<? extends WizardFinisher>> finisherValue;
        private final DialogUtils.ValueSource<? extends DialogUtils.Optional<?>> warningValue;
        private final LogicBasedWizard wizardImpl;

        public WizardFinishController(DialogUtils.ValueSource<? extends DialogUtils.Optional<? extends WizardFinisher>> finisherValue, DialogUtils.ValueSource<? extends DialogUtils.Optional<? extends Void>> warningValue, LogicBasedWizard wizardImpl) {
            this.finisherValue = finisherValue;
            this.warningValue = warningValue;
            this.wizardImpl = wizardImpl;
        }

        @Override
        public void update(DialogUtils.Updater updater) {
            WizardFinisher finisher;
            DialogUtils.Optional<?> warnings;
            HashSet<DialogUtils.Message> messages = new HashSet<DialogUtils.Message>();
            if (this.warningValue != null && !(warnings = this.warningValue.getValue()).isNormal()) {
                messages.addAll(warnings.errorMessages());
            }
            if (this.finisherValue.getValue().isNormal()) {
                finisher = this.finisherValue.getValue().getNormal();
            } else {
                finisher = null;
                messages.addAll(this.finisherValue.getValue().errorMessages());
            }
            DialogUtils.Message message = DialogUtils.chooseImportantMessage(messages);
            this.wizardImpl.setWizardFinisher(finisher, message);
        }
    }

    public static interface WizardFinisher {
        public boolean performFinish(IWizard var1, IProgressMonitor var2);
    }

    public static interface WizardLogic {
        public void updateAll();

        public PageImpl<?> getStartingPage();

        public void dispose();
    }

    public static interface WizardPageSet {
        public List<? extends PageImpl<?>> getAllPages();

        public WizardLogic createLogic(LogicBasedWizard var1);
    }
}

