/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.wst.jsdt.core.ICorrectionRequestor;

public class CodeCorrectionTestsRequestor
implements ICorrectionRequestor {
    private Vector fSuggestions = new Vector(5);

    public void acceptClass(char[] packageName, char[] className, char[] correctionName, int modifiers, int correctionStart, int correctionEnd) {
        this.fSuggestions.addElement(new Suggestion(correctionName, correctionStart, correctionEnd));
    }

    public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] correctionName, int modifiers, int correctionStart, int correctionEnd) {
        this.fSuggestions.addElement(new Suggestion(correctionName, correctionStart, correctionEnd));
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, char[] correctionName, int modifiers, int correctionStart, int correctionEnd) {
        this.fSuggestions.addElement(new Suggestion(correctionName, correctionStart, correctionEnd));
    }

    public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int correctionStart, int correctionEnd) {
        this.fSuggestions.addElement(new Suggestion(name, correctionStart, correctionEnd));
    }

    public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] correctionName, int modifiers, int correctionStart, int correctionEnd) {
        this.fSuggestions.addElement(new Suggestion(correctionName, correctionStart, correctionEnd));
    }

    public void acceptPackage(char[] packageName, char[] correctionName, int correctionStart, int correctionEnd) {
        this.fSuggestions.addElement(new Suggestion(correctionName, correctionStart, correctionEnd));
    }

    public String getSuggestions() {
        Suggestion[] suggestions = this.getSortedSuggestions();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < suggestions.length) {
            if (i != 0) {
                result.append('\n');
            }
            result.append(suggestions[i].text);
            ++i;
        }
        return result.toString();
    }

    public String getStarts() {
        Suggestion[] suggestions = this.getSortedSuggestions();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < suggestions.length) {
            if (i != 0) {
                result.append('\n');
            }
            result.append(suggestions[i].start);
            ++i;
        }
        return result.toString();
    }

    public String getEnds() {
        Suggestion[] suggestions = this.getSortedSuggestions();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < suggestions.length) {
            if (i != 0) {
                result.append('\n');
            }
            result.append(suggestions[i].end);
            ++i;
        }
        return result.toString();
    }

    private Suggestion[] getSortedSuggestions() {
        Object[] unsorted = this.fSuggestions.toArray();
        Suggestion[] sorted = new Suggestion[unsorted.length];
        System.arraycopy(unsorted, 0, sorted, 0, unsorted.length);
        Arrays.sort(sorted, new SuggestionComparator());
        return sorted;
    }

    private class Suggestion {
        public String text;
        public int start;
        public int end;

        public Suggestion(char[] text, int start, int end) {
            this.text = new String(text);
            this.start = start;
            this.end = end;
        }
    }

    class SuggestionComparator
    implements Comparator {
        SuggestionComparator() {
        }

        public int compare(Object o1, Object o2) {
            Suggestion s1 = (Suggestion)o1;
            Suggestion s2 = (Suggestion)o2;
            int result = s1.text.compareTo(s2.text);
            if (result == 0 && (result = s1.start - s2.start) == 0) {
                result = s1.end - s2.end;
            }
            return result;
        }
    }
}

