/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.tests.internal;

import java.util.Arrays;
import org.eclipse.wst.jsdt.chromium.internal.JsonUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class JsonBuilderUtil {
    public static JsonPropertyTemp jsonProperty(String name, String value) {
        return new JsonPropertyTemp(name, value);
    }

    public static JsonPropertyTemp jsonProperty(String name, Number value) {
        return new JsonPropertyTemp(name, value);
    }

    public static JsonPropertyTemp jsonProperty(String name, Boolean value) {
        return new JsonPropertyTemp(name, value);
    }

    public static JsonPropertyTemp jsonProperty(String name, JSONObject value) {
        return new JsonPropertyTemp(name, value);
    }

    public static JsonPropertyTemp jsonProperty(String name, JSONArray value) {
        return new JsonPropertyTemp(name, value);
    }

    public static JSONObject jsonObject(JsonPropertyTemp ... properties) {
        JSONObject object = new JSONObject();
        JsonPropertyTemp[] jsonPropertyTempArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            JsonPropertyTemp pr1 = jsonPropertyTempArray[n2];
            object.put((Object)pr1.getName(), pr1.getValue());
            ++n2;
        }
        return object;
    }

    public static JSONObject jsonObject(String pseudoJsonText) {
        String jsonText = "{" + JsonBuilderUtil.convertToRealJson(pseudoJsonText) + "}";
        try {
            return JsonUtil.jsonObjectFromJson((String)jsonText);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }

    public static JSONArray jsonArray(JSONObject ... objects) {
        JSONArray array = new JSONArray();
        array.addAll(Arrays.asList(objects));
        return array;
    }

    public static String convertToRealJson(String pseudoJson) {
        return pseudoJson.replace('\'', '\"');
    }

    public static class JsonPropertyTemp {
        private final String name;
        private final Object value;

        JsonPropertyTemp(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        Object getValue() {
            return this.value;
        }
    }
}

