/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.tests.encoding.util.WorkspaceProgressMonitor;

public class ProjectUnzipUtility {
    public static final String PROJECT_ZIPS_FOLDER = "ProjectTestFiles";
    private List fCreatedProjects = new ArrayList();
    static final int BUFFER = 2048;

    public void importFile(File fileToImport, String folderPath) {
    }

    public void unzipAndImport(URL url, String destinationDirectory) {
        block17: {
            InputStream stream = null;
            try {
                try {
                    File unzipDestinationDirectory = new File(destinationDirectory);
                    stream = url.openStream();
                    ZipInputStream zipStream = new ZipInputStream(stream);
                    ZipEntry entry = zipStream.getNextEntry();
                    while (entry != null) {
                        String currentEntry = entry.getName();
                        File destFile = new File(unzipDestinationDirectory, currentEntry);
                        File destinationParent = destFile.getParentFile();
                        destinationParent.mkdirs();
                        if (!entry.isDirectory()) {
                            byte[] data = new byte[2048];
                            FileOutputStream fileOutputStream = new FileOutputStream(destFile);
                            ByteArrayOutputStream dest = new ByteArrayOutputStream(2048);
                            int i = -1;
                            while ((i = zipStream.read(data)) > -1) {
                                dest.write(data, 0, i);
                            }
                            dest.flush();
                            dest.close();
                            fileOutputStream.write(dest.toByteArray());
                            fileOutputStream.close();
                        }
                        entry = zipStream.getNextEntry();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void unzipAndImport(File inFile, String destinationDirectory) {
        try {
            String inFileName = inFile.getAbsolutePath();
            File sourceZipFile = new File(inFileName);
            File unzipDestinationDirectory = new File(destinationDirectory);
            ZipFile zipFile = new ZipFile(sourceZipFile, 1);
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            IProject currentProject = null;
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(unzipDestinationDirectory, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] data = new byte[2048];
                FileOutputStream fileOutputStream = new FileOutputStream(destFile);
                ByteArrayOutputStream dest = new ByteArrayOutputStream(2048);
                boolean eof = false;
                int nBytes = 0;
                while (!eof) {
                    nBytes = is.read(data, 0, 2048);
                    if (nBytes != -1) {
                        dest.write(data, 0, nBytes);
                        continue;
                    }
                    eof = true;
                }
                dest.flush();
                dest.close();
                fileOutputStream.write(dest.toByteArray());
                fileOutputStream.close();
                is.close();
            }
            zipFile.close();
            if (currentProject != null) {
                try {
                    Path projectLocation = new Path(Platform.getLocation().toOSString());
                    this.createProject(currentProject, (IPath)projectLocation, new WorkspaceProgressMonitor());
                }
                catch (CoreException cex) {
                    cex.printStackTrace();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void refreshWorkspace() throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = wsRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            projects[i].refreshLocal(2, null);
            ++i;
        }
        wsRoot.refreshLocal(2, null);
    }

    public void deleteProjects() throws Exception {
        final IProject[] projects = this.getCreatedProjects();
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < projects.length) {
                    projects[i].clearHistory(null);
                    projects[i].close(null);
                    projects[i].delete(true, true, null);
                    ++i;
                }
                ProjectUnzipUtility.this.refreshWorkspace();
            }
        }, null);
        ResourcesPlugin.getWorkspace().save(true, null);
    }

    public void deleteProject(String projectName) throws Exception {
        String name = projectName;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        final IProject proj = wsRoot.getProject(name);
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (proj != null && proj.exists()) {
                    proj.clearHistory(null);
                    proj.refreshLocal(2, null);
                    try {
                        proj.delete(true, true, null);
                    }
                    catch (Exception exception) {
                        proj.refreshLocal(2, null);
                        proj.delete(true, true, null);
                    }
                }
                ProjectUnzipUtility.this.refreshWorkspace();
            }
        }, null);
        ResourcesPlugin.getWorkspace().save(true, null);
    }

    public IProject[] getCreatedProjects() {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        String[] projectNames = this.fCreatedProjects.toArray(new String[this.fCreatedProjects.size()]);
        IProject[] projects = new IProject[projectNames.length];
        int i = 0;
        while (i < projectNames.length) {
            projects[i] = wsRoot.getProject(projectNames[i]);
            ++i;
        }
        return projects;
    }

    public void initJavaProject(String projName) throws CoreException {
        this.refreshWorkspace();
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        String[] natureIds = new String[]{"org.eclipse.jdt.core.javanature"};
        if (!proj.isOpen()) {
            proj.open(null);
        }
        IProjectDescription desc = proj.getDescription();
        desc.setNatureIds(natureIds);
        proj.setDescription(desc, null);
    }

    private void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new WorkspaceProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void deleteProject(IProject fProject) throws InvocationTargetException, InterruptedException {
        final IProject proj = fProject;
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (proj != null && proj.exists()) {
                        proj.clearHistory(null);
                        proj.refreshLocal(2, null);
                        proj.delete(true, true, null);
                    }
                    ProjectUnzipUtility.this.refreshWorkspace();
                }
            }, null);
        }
        catch (CoreException coreException) {}
    }
}

