/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Random;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.deque.AbstractPriorityDeque;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public abstract class AbstractPriorityDequeTests
extends TestCase {
    public AbstractPriorityDequeTests(String name) {
        super(name);
    }

    abstract <E extends Comparable<E>> AbstractPriorityDeque<E> buildDeque();

    abstract <E extends Comparable<E>> AbstractPriorityDeque<E> buildDeque(int var1);

    abstract <E extends Comparable<E>> AbstractPriorityDeque<E> buildDeque(Comparator<E> var1, int var2);

    public void testIsEmpty_head() {
        AbstractPriorityDeque deque = this.buildDeque();
        AbstractPriorityDequeTests.assertTrue((boolean)deque.isEmpty());
        deque.enqueue((Object)"first");
        AbstractPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.enqueue((Object)"second");
        AbstractPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.dequeueHead();
        AbstractPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.dequeueHead();
        AbstractPriorityDequeTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testIsEmpty_tail() {
        AbstractPriorityDeque deque = this.buildDeque();
        AbstractPriorityDequeTests.assertTrue((boolean)deque.isEmpty());
        deque.enqueue((Object)"first");
        AbstractPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.enqueue((Object)"second");
        AbstractPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.dequeueTail();
        AbstractPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.dequeueTail();
        AbstractPriorityDequeTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testEnqueueAndDequeueHead() {
        AbstractPriorityDeque deque = this.buildDeque();
        String first = "first";
        String second = "second";
        deque.enqueue((Object)first);
        deque.enqueueTail((Object)second);
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.dequeueHead()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.dequeueHead()));
    }

    public void testEnqueueAndDequeueTail() {
        AbstractPriorityDeque deque = this.buildDeque();
        String first = "first";
        String second = "second";
        deque.enqueue((Object)first);
        deque.enqueue((Object)second);
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.dequeueTail()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.dequeueTail()));
    }

    public void testEnqueueAndPeekHead() {
        AbstractPriorityDeque deque = this.buildDeque();
        String first = "first";
        String second = "second";
        deque.enqueue((Object)first);
        deque.enqueue((Object)second);
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.dequeueHead()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.dequeueHead()));
    }

    public void testEnqueueAndPeekTail() {
        AbstractPriorityDeque deque = this.buildDeque();
        String first = "first";
        String second = "second";
        String third = "third";
        String zzzz = "zzzz";
        deque.enqueue((Object)second);
        deque.enqueue((Object)zzzz);
        deque.enqueue((Object)third);
        deque.enqueue((Object)first);
        AbstractPriorityDequeTests.assertEquals((String)zzzz, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)zzzz, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)zzzz, (String)((String)deque.dequeueTail()));
        AbstractPriorityDequeTests.assertEquals((String)third, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)third, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)third, (String)((String)deque.dequeueTail()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.dequeueTail()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.dequeueTail()));
    }

    public void testEmptyQueueExceptionPeekHead() {
        AbstractPriorityDeque deque = this.buildDeque();
        String first = "first";
        String second = "second";
        deque.enqueue((Object)first);
        deque.enqueue((Object)second);
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.dequeueHead()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.dequeueHead()));
        boolean exCaught = false;
        try {
            deque.peekHead();
            AbstractPriorityDequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        AbstractPriorityDequeTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyQueueExceptionPeekTail() {
        AbstractPriorityDeque deque = this.buildDeque();
        String first = "first";
        String second = "second";
        deque.enqueue((Object)first);
        deque.enqueue((Object)second);
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.dequeueTail()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.dequeueTail()));
        boolean exCaught = false;
        try {
            deque.peekTail();
            AbstractPriorityDequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        AbstractPriorityDequeTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyQueueExceptionDequeueHead() {
        AbstractPriorityDeque deque = this.buildDeque();
        String first = "first";
        String second = "second";
        deque.enqueue((Object)first);
        deque.enqueue((Object)second);
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.dequeueHead()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.dequeueHead()));
        boolean exCaught = false;
        try {
            deque.dequeueHead();
            AbstractPriorityDequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        AbstractPriorityDequeTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyQueueExceptionDequeueTail() {
        AbstractPriorityDeque deque = this.buildDeque();
        String first = "first";
        String second = "second";
        deque.enqueue((Object)first);
        deque.enqueue((Object)second);
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)second, (String)((String)deque.dequeueTail()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)first, (String)((String)deque.dequeueTail()));
        boolean exCaught = false;
        try {
            deque.dequeueTail();
            AbstractPriorityDequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        AbstractPriorityDequeTests.assertTrue((boolean)exCaught);
    }

    public void testClone() {
        AbstractPriorityDeque deque = this.buildDeque();
        deque.enqueue((Object)"first");
        deque.enqueue((Object)"second");
        deque.enqueue((Object)"third");
        AbstractPriorityDeque clone = (AbstractPriorityDeque)ObjectTools.execute(deque, (String)"clone");
        this.verifyClone(deque, (AbstractPriorityDeque<String>)clone);
    }

    public void testSerialization() throws Exception {
        AbstractPriorityDeque deque = this.buildDeque();
        deque.enqueue((Object)"first");
        deque.enqueue((Object)"second");
        deque.enqueue((Object)"third");
        this.verifyClone(deque, TestTools.serialize(deque));
    }

    protected void verifyClone(AbstractPriorityDeque<String> original, AbstractPriorityDeque<String> clone) {
        AbstractPriorityDequeTests.assertNotSame(original, clone);
        AbstractPriorityDequeTests.assertEquals((String)((String)original.peekHead()), (String)((String)clone.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)((String)original.dequeueHead()), (String)((String)clone.dequeueHead()));
        AbstractPriorityDequeTests.assertEquals((String)((String)original.peekTail()), (String)((String)clone.peekTail()));
        AbstractPriorityDequeTests.assertEquals((String)((String)original.dequeueTail()), (String)((String)clone.dequeueTail()));
        AbstractPriorityDequeTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        AbstractPriorityDequeTests.assertEquals((String)((String)original.peekHead()), (String)((String)clone.peekHead()));
        AbstractPriorityDequeTests.assertEquals((String)((String)original.dequeueHead()), (String)((String)clone.dequeueHead()));
        AbstractPriorityDequeTests.assertTrue((boolean)original.isEmpty());
        AbstractPriorityDequeTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"fourth");
        AbstractPriorityDequeTests.assertFalse((boolean)original.isEmpty());
        AbstractPriorityDequeTests.assertTrue((boolean)clone.isEmpty());
    }

    public void testToString() throws Exception {
        AbstractPriorityDeque deque = this.buildDeque();
        AbstractPriorityDequeTests.assertEquals((String)"[]", (String)deque.toString());
        deque.enqueue((Object)"first");
        AbstractPriorityDequeTests.assertEquals((String)"[first]", (String)deque.toString());
        deque.enqueue((Object)"second");
        AbstractPriorityDequeTests.assertEquals((String)"[first, second]", (String)deque.toString());
        deque.enqueue((Object)"third");
        AbstractPriorityDequeTests.assertEquals((String)"[first, second, third]", (String)deque.toString());
    }

    public void testMultipleSizes() throws Exception {
        int maxSize = 50;
        Random random = new Random();
        int size = 1;
        while (size <= maxSize) {
            int[] values = new int[size];
            int i = 0;
            while (i < values.length) {
                values[i] = random.nextInt();
                ++i;
            }
            AbstractPriorityDeque deque = this.buildDeque(size);
            int[] nArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                int value = nArray[n2];
                deque.enqueue((Object)value);
                ++n2;
            }
            Integer currentHead = (Integer)deque.dequeueHead();
            int i2 = 1;
            Integer currentTail = null;
            if (!deque.isEmpty()) {
                currentTail = (Integer)deque.dequeueTail();
                ++i2;
            }
            do {
                if (!deque.isEmpty()) {
                    Integer nextHead = (Integer)deque.dequeueHead();
                    ++i2;
                    AbstractPriorityDequeTests.assertTrue((currentHead <= nextHead ? 1 : 0) != 0);
                    currentHead = nextHead;
                }
                if (deque.isEmpty()) continue;
                Integer nextTail = (Integer)deque.dequeueTail();
                ++i2;
                AbstractPriorityDequeTests.assertTrue((currentTail != null && currentTail >= nextTail ? 1 : 0) != 0);
                currentTail = nextTail;
            } while (!deque.isEmpty());
            AbstractPriorityDequeTests.assertEquals((int)size, (int)i2);
            ++size;
        }
    }

    public void testSomethingBig() throws Exception {
        int size = 500000;
        AbstractPriorityDeque deque = this.buildDeque(size);
        Random random = new Random();
        int i = size;
        while (i-- > 0) {
            deque.enqueue((Object)random.nextInt());
        }
        Integer currentHead = (Integer)deque.dequeueHead();
        int i2 = 1;
        Integer currentTail = null;
        if (!deque.isEmpty()) {
            currentTail = (Integer)deque.dequeueTail();
            ++i2;
        }
        do {
            if (!deque.isEmpty()) {
                Integer nextHead = (Integer)deque.dequeueHead();
                ++i2;
                AbstractPriorityDequeTests.assertTrue((currentHead <= nextHead ? 1 : 0) != 0);
                currentHead = nextHead;
            }
            if (deque.isEmpty()) continue;
            Integer nextTail = (Integer)deque.dequeueTail();
            ++i2;
            AbstractPriorityDequeTests.assertTrue((currentTail != null && currentTail >= nextTail ? 1 : 0) != 0);
            currentTail = nextTail;
        } while (!deque.isEmpty());
        AbstractPriorityDequeTests.assertEquals((int)size, (int)i2);
    }

    public void testConstructor_nullComparator() throws Exception {
        boolean exCaught = false;
        try {
            AbstractPriorityDeque deque = this.buildDeque(null, 3);
            AbstractPriorityDequeTests.fail((String)("bogus deque: " + deque));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractPriorityDequeTests.assertTrue((boolean)exCaught);
    }

    public void testConstructor_negativeCapacity() throws Exception {
        boolean exCaught = false;
        try {
            AbstractPriorityDeque deque = this.buildDeque(-7);
            AbstractPriorityDequeTests.fail((String)("bogus deque: " + deque));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractPriorityDequeTests.assertTrue((boolean)exCaught);
    }

    public void testSerialization_fullArray() throws Exception {
        AbstractPriorityDeque deque = this.buildDeque(3);
        deque.enqueue((Object)"first");
        deque.enqueue((Object)"second");
        deque.enqueue((Object)"third");
        this.verifyClone(deque, TestTools.serialize(deque));
    }

    public void testSerialization_empty() throws Exception {
        AbstractPriorityDeque original = this.buildDeque();
        AbstractPriorityDeque clone = TestTools.serialize(original);
        AbstractPriorityDequeTests.assertNotSame(original, clone);
        AbstractPriorityDequeTests.assertTrue((boolean)original.isEmpty());
        AbstractPriorityDequeTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"foo");
        AbstractPriorityDequeTests.assertFalse((boolean)original.isEmpty());
        AbstractPriorityDequeTests.assertTrue((boolean)clone.isEmpty());
    }
}

