/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.SourcePositionComparator;
import org.eclipse.wst.jsdt.ui.JavaScriptElementComparator;

public class LexicalSortingAction
extends Action {
    private JavaScriptElementComparator fComparator = new JavaScriptElementComparator();
    private SourcePositionComparator fSourcePositonComparator = new SourcePositionComparator();
    private StructuredViewer fViewer;
    private String fPreferenceKey;

    public LexicalSortingAction(StructuredViewer viewer, String id) {
        this.fViewer = viewer;
        this.fPreferenceKey = "LexicalSortingAction." + id + ".isChecked";
        this.setText(JavaBrowsingMessages.LexicalSortingAction_label);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
        this.setToolTipText(JavaBrowsingMessages.LexicalSortingAction_tooltip);
        this.setDescription(JavaBrowsingMessages.LexicalSortingAction_description);
        boolean checked = JavaScriptPlugin.getDefault().getPreferenceStore().getBoolean(this.fPreferenceKey);
        this.valueChanged(checked, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.lexical_sorting_browsing_action");
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(final boolean on, boolean store) {
        this.setChecked(on);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (on) {
                    LexicalSortingAction.this.fViewer.setComparator((ViewerComparator)LexicalSortingAction.this.fComparator);
                } else {
                    LexicalSortingAction.this.fViewer.setComparator((ViewerComparator)LexicalSortingAction.this.fSourcePositonComparator);
                }
            }
        });
        if (store) {
            JavaScriptPlugin.getDefault().getPreferenceStore().setValue(this.fPreferenceKey, on);
        }
    }
}

