/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.model.internal.validation.AValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.DuplicatesTable;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb11Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class EJBJar11VRule
extends AValidationRule
implements IMessagePrefixEjb11Constants {
    private DuplicatesTable _ejbName = new DuplicatesTable();
    private static final Object ID = IValidationRuleList.EJB11_EJBJAR;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_SESSION_BEANCLASS, IValidationRuleList.EJB11_SESSION_REMOTE, IValidationRuleList.EJB11_SESSION_HOME, IValidationRuleList.EJB11_CMP_BEANCLASS, IValidationRuleList.EJB11_CMP_REMOTE, IValidationRuleList.EJB11_CMP_HOME, IValidationRuleList.EJB11_CMP_KEYCLASS, IValidationRuleList.EJB11_BMP_BEANCLASS, IValidationRuleList.EJB11_BMP_REMOTE, IValidationRuleList.EJB11_BMP_HOME, IValidationRuleList.EJB11_BMP_KEYCLASS, IValidationRuleList.EJB11_EJBEXT};
    private static final Map MESSAGE_IDS = new HashMap();

    static {
        MESSAGE_IDS.put("CHKJ2814", new String[]{"CHKJ2814.ejb11"});
        MESSAGE_IDS.put("CHKJ2825", new String[]{"CHKJ2825.ejb11"});
        MESSAGE_IDS.put("CHKJ2826", new String[]{"CHKJ2826.ejb11"});
        MESSAGE_IDS.put("CHKJ2842", new String[]{"CHKJ2842.ejb11"});
        MESSAGE_IDS.put("CHKJ2843", new String[]{"CHKJ2843.ejb11"});
        MESSAGE_IDS.put("CHKJ2844", new String[]{"CHKJ2844.ejb11"});
        MESSAGE_IDS.put("CHKJ2845", new String[]{"CHKJ2845.ejb11"});
        MESSAGE_IDS.put("CHKJ2846", new String[]{"CHKJ2846.ejb11"});
        MESSAGE_IDS.put("CHKJ2847", new String[]{"CHKJ2847.ejb11"});
        MESSAGE_IDS.put("CHKJ2850", new String[]{"CHKJ2850.ejb11"});
        MESSAGE_IDS.put("CHKJ2852", new String[]{"CHKJ2852"});
        MESSAGE_IDS.put("CHKJ2875", new String[]{"CHKJ2875.ejb11"});
        MESSAGE_IDS.put("CHKJ2895", new String[]{"CHKJ2895.ejb11"});
    }

    @Override
    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    @Override
    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    @Override
    public final Object getId() {
        return ID;
    }

    @Override
    public Object getTarget(Object parent, Object target) {
        return null;
    }

    protected void validateAssemblyDescriptorElement(IEJBValidationContext vc, EJBJar ejbJar) {
        vc.terminateIfCancelled();
        if (ejbJar == null) {
            return;
        }
        AssemblyDescriptor assemblyDescriptor = ejbJar.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        EList roles = assemblyDescriptor.getSecurityRoles();
        if (roles != null) {
            class RoleWrapper {
                private SecurityRole _role = null;

                public RoleWrapper(SecurityRole role) {
                    this._role = role;
                }

                public boolean equals(Object o) {
                    if (o instanceof RoleWrapper) {
                        RoleWrapper other = (RoleWrapper)o;
                        return this._role.getRoleName().equals(other.getRole().getRoleName());
                    }
                    return false;
                }

                public int hashCode() {
                    return super.hashCode() + this._role.getRoleName().hashCode();
                }

                public SecurityRole getRole() {
                    return this._role;
                }
            }
            DuplicatesTable roleNames = new DuplicatesTable();
            SecurityRole role = null;
            Iterator roleIt = roles.iterator();
            while (roleIt.hasNext()) {
                IMessage message;
                vc.terminateIfCancelled();
                role = (SecurityRole)roleIt.next();
                if (role == null) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2825", 2, ejbJar, (IValidationRule)this);
                    vc.addMessage(message);
                    continue;
                }
                if (!role.eIsSet((EStructuralFeature)CommonPackage.eINSTANCE.getSecurityRole_RoleName()) || role.getRoleName().equals("")) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2825", 2, role, (IValidationRule)this);
                    vc.addMessage(message);
                    continue;
                }
                roleNames.add(new RoleWrapper(role));
            }
            if (roleNames.containsDuplicates()) {
                List duplicates = roleNames.getDuplicates();
                Iterator iterator = duplicates.iterator();
                while (iterator.hasNext()) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2826", 2, ((RoleWrapper)iterator.next()).getRole(), (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            roleNames.clear();
        }
        EList methTrans = assemblyDescriptor.getMethodTransactions();
        MethodTransaction mt = null;
        Iterator iterator = methTrans.iterator();
        while (iterator.hasNext()) {
            vc.terminateIfCancelled();
            try {
                mt = (MethodTransaction)iterator.next();
            }
            catch (Throwable exc) {
                Logger logger = vc.getMsgLogger();
                if (logger != null && logger.isLoggingLevel(Level.FINER)) {
                    logger.write(Level.FINER, exc);
                }
                mt = null;
            }
            if (mt == null) {
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.FINEST)) continue;
                LogEntry entry = vc.getLogEntry();
                entry.setSourceID("DDValidator.validateAssemblyDescriptorElement");
                entry.setText("mt is null");
                logger.write(Level.FINEST, (Object)entry);
                continue;
            }
            boolean hasValidMethod = this.validateMethodElements(vc, ejbJar, (List)mt.getMethodElements());
            if (hasValidMethod) continue;
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2847", 2, mt, (IValidationRule)this);
            vc.addMessage(message);
        }
        EList methodPermissions = assemblyDescriptor.getMethodPermissions();
        for (MethodPermission mp : methodPermissions) {
            EList mproles;
            boolean hasValidMethod = this.validateMethodElements(vc, ejbJar, (List)mp.getMethodElements());
            if (!hasValidMethod) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2846", 2, mp, (IValidationRule)this);
                vc.addMessage(message);
            }
            if ((mproles = mp.getRoles()) != null && mproles.size() != 0) continue;
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2845", 2, mp, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void validate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void reset() {
        super.reset();
        this._ejbName.clear();
    }

    protected void register(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        this._ejbName.add(new EjbNameWrapper(bean));
    }

    private void addInternalErrorMessage(IEJBValidationContext vc, Throwable exc) {
        Logger logger;
        IMessage mssg = vc.getMessage();
        mssg.setId("CHKJ2900");
        vc.addMessage(mssg);
        if (exc != null && (logger = vc.getMsgLogger()) != null && logger.isLoggingLevel(Level.SEVERE)) {
            logger.write(Level.SEVERE, exc);
        }
    }

    public void validateUniqueEjbNames(IEJBValidationContext vc, EJBJar ejbJar) {
        List names = this._ejbName.getDuplicates();
        if (names.size() == 0) {
            return;
        }
        for (EjbNameWrapper wrapper : names) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2895", 2, wrapper.getBean(), new String[]{wrapper.getBean().getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateClientJAR(IEJBValidationContext vc, EJBJar ejbJar) {
        String clientJARName = ejbJar.getEjbClientJar();
        if (clientJARName == null) {
            return;
        }
        Boolean exists = (Boolean)vc.loadModel("EJB_CLIENTJAR", new Object[]{clientJARName});
        if (exists == null) {
            return;
        }
        if (!exists.booleanValue()) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2875", 1, ejbJar, new String[]{clientJARName}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected boolean validateMethodElements(IEJBValidationContext vc, EJBJar ejbJar, List elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean hasValidMethod = false;
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            IMessage message;
            vc.terminateIfCancelled();
            MethodElement element = (MethodElement)iterator.next();
            EnterpriseBean bean = element.getEnterpriseBean();
            if (bean == null) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2814", 2, element, (IValidationRule)this);
                vc.addMessage(message);
                continue;
            }
            if (element.getName() != null) {
                List params;
                boolean hasMethods;
                IMessage message2;
                String[] msgParm;
                String className;
                boolean reflected = true;
                try {
                    ValidationRuleUtility.isValidType((JavaHelpers)bean.getHomeInterface());
                }
                catch (InvalidInputException e) {
                    reflected = false;
                    className = e.getJavaClass() == null ? "<home>" : e.getJavaClass().getQualifiedName();
                    msgParm = new String[]{className};
                    message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2850", 2, bean, msgParm, (IValidationRule)this);
                    vc.addMessage(message2);
                }
                try {
                    ValidationRuleUtility.isValidType((JavaHelpers)bean.getRemoteInterface());
                }
                catch (InvalidInputException e) {
                    reflected = false;
                    className = e.getJavaClass() == null ? "<remote>" : e.getJavaClass().getQualifiedName();
                    msgParm = new String[]{className};
                    message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2850", 2, bean, msgParm, (IValidationRule)this);
                    vc.addMessage(message2);
                }
                if (!reflected) continue;
                String name = element.getName();
                Method[] methods = element.getMethods();
                boolean bl = hasMethods = methods != null && methods.length > 0;
                if (!hasMethods) {
                    message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2843", 2, element, new String[]{bean.getName()}, (IValidationRule)this);
                    vc.addMessage(message2);
                    continue;
                }
                hasValidMethod = true;
                if (!name.equals("*") || (params = element.getMethodParams()) == null || params.size() <= 0) continue;
                IMessage message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2842", 2, element, (IValidationRule)this);
                vc.addMessage(message3);
                continue;
            }
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2844", 2, element, (IValidationRule)this);
            vc.addMessage(message);
        }
        return hasValidMethod;
    }

    class EjbNameWrapper {
        private EnterpriseBean _bean = null;

        public EjbNameWrapper(EnterpriseBean bean) {
            this._bean = bean;
        }

        public boolean equals(Object o) {
            if (o instanceof EjbNameWrapper) {
                EjbNameWrapper other = (EjbNameWrapper)o;
                if (this._bean.getName() == null && other.getBean().getName() == null) {
                    return true;
                }
                if (this._bean.getName() == null) {
                    return false;
                }
                if (other.getBean().getName() == null) {
                    return false;
                }
                return this._bean.getName().equals(other.getBean().getName());
            }
            return false;
        }

        public int hashCode() {
            if (this.getBean() != null && this.getBean().getName() != null) {
                return this.getBean().getName().hashCode();
            }
            return super.hashCode();
        }

        public EnterpriseBean getBean() {
            return this._bean;
        }
    }
}

