/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.xml;

import java.io.InputStream;
import org.eclipse.jst.j2ee.internal.WrappedRuntimeException;
import org.eclipse.jst.j2ee.internal.xml.GeneralXmlDocumentReader;
import org.eclipse.jst.j2ee.internal.xml.J2EEXMLResourceHandler;
import org.eclipse.jst.j2ee.internal.xml.J2EEXmlDtDEntityResolver;
import org.eclipse.jst.j2ee.internal.xml.XMLParseResourceHandler;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlDocumentReader
extends GeneralXmlDocumentReader {
    public XmlDocumentReader(InputSource source) {
        super(source);
        this.setFlagDefaults();
    }

    public XmlDocumentReader(InputSource source, EntityResolver resolver, ErrorHandler handler) {
        super(source, resolver, handler);
        this.setFlagDefaults();
    }

    @Override
    public EntityResolver createDefaultEntityResolver() {
        return J2EEXmlDtDEntityResolver.INSTANCE;
    }

    @Override
    protected void handleException(String aMessage, Throwable anException) {
        if (anException instanceof SAXParseException) {
            this.handleException(aMessage, (SAXParseException)anException);
        } else {
            super.handleException(aMessage, anException);
        }
    }

    protected void handleException(String aMessage, SAXParseException parseException) {
        this.primHandleException(J2EEXMLResourceHandler.getString(XMLParseResourceHandler.parse_exception_occured_EXC_, new Object[]{new Integer(parseException.getLineNumber()), new Integer(parseException.getColumnNumber())}), parseException);
    }

    @Override
    protected void primHandleException(String aMessage, Throwable anException) {
        if (anException instanceof Exception) {
            throw new WrappedRuntimeException(aMessage, (Exception)anException);
        }
        super.primHandleException(aMessage, anException);
    }

    protected void setFlagDefaults() {
        this.setAllowJavaEncodings(true);
        this.setValidate(true);
    }

    public static DocumentType readDocumentType(InputStream in, String uri) {
        InputSource source = new InputSource(in);
        XmlDocumentReader aReader = new XmlDocumentReader(source);
        aReader.setValidate(false);
        Document aDocument = aReader.parseDocument();
        if (aDocument != null) {
            return aDocument.getDoctype();
        }
        return null;
    }
}

