/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.PluginRecord;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;
import org.eclipse.wst.common.snippets.internal.util.CommonXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkspaceModelDumper {
    private static WorkspaceModelDumper dumper = null;

    public static synchronized WorkspaceModelDumper getInstance() {
        if (dumper == null) {
            dumper = new WorkspaceModelDumper();
        }
        return dumper;
    }

    protected WorkspaceModelDumper() {
    }

    protected void assignEntryProperties(ISnippetsEntry entry, Element owningElement) {
        if (entry instanceof SnippetPaletteDrawer) {
            SnippetPaletteDrawer drawer = (SnippetPaletteDrawer)entry;
            owningElement.setAttribute("id", drawer.getId());
            owningElement.setAttribute("smallicon", drawer.getSmallIconName());
            owningElement.setAttribute("label", drawer.getLabel());
            owningElement.setAttribute("largeicon", drawer.getLargeIconName());
        }
        if (entry instanceof SnippetPaletteItem) {
            SnippetPaletteItem item = (SnippetPaletteItem)entry;
            owningElement.setAttribute("id", item.getId());
            owningElement.setAttribute("smallicon", item.getSmallIconName());
            owningElement.setAttribute("label", item.getLabel());
            owningElement.setAttribute("largeicon", item.getLargeIconName());
        }
        owningElement.appendChild(this.createDescription(owningElement.getOwnerDocument(), entry.getDescription()));
    }

    protected void assignSourceFor(ISnippetsEntry entry, Element owningElement) {
        if (entry.getSourceType() == "WORKSPACE") {
            owningElement.setAttribute("shared", "shared");
        }
    }

    protected Element createCategory(Document doc, ISnippetCategory category) {
        Element element = doc.createElement("category");
        this.assignSourceFor(category, element);
        element.setAttribute("id", ((SnippetPaletteDrawer)category).getId());
        String[] filters = category.getFilters();
        if (filters.length > 0) {
            Object filtersAttr = filters[0];
            if (filters.length > 1) {
                int i = 1;
                while (i < filters.length) {
                    filtersAttr = (String)filtersAttr + " " + filters[i];
                    ++i;
                }
            }
            element.setAttribute("filters", (String)filtersAttr);
        }
        if (category.getSourceType() == "WORKSPACE") {
            this.assignEntryProperties(category, element);
            int i = 0;
            while (i < category.getItems().length) {
                ISnippetItem item = category.getItems()[i];
                Element child = this.createItem(doc, item);
                element.appendChild(child);
                ++i;
            }
        }
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("User item writer saving category " + ((SnippetPaletteDrawer)category).getId());
        }
        return element;
    }

    protected Element createContent(Document doc, ISnippetItem item) {
        Element element = doc.createElement("content");
        element.appendChild(doc.createCDATASection(item.getContentString()));
        return element;
    }

    protected Element createDescription(Document doc, String description) {
        Element element = doc.createElement("description");
        if (description != null) {
            element.appendChild(doc.createCDATASection(description));
        } else {
            element.appendChild(doc.createCDATASection(""));
        }
        return element;
    }

    protected Document createDocument(ISnippetCategory category) {
        Document document = CommonXML.getDocumentBuilder().getDOMImplementation().createDocument(null, "snippets", null);
        Element root = document.getDocumentElement();
        Element categoryElement = this.createCategory(document, category);
        root.appendChild(categoryElement);
        return document;
    }

    protected Element createItem(Document doc, ISnippetItem item) {
        Element element = doc.createElement("item");
        this.assignEntryProperties(item, element);
        this.assignSourceFor(item, element);
        element.setAttribute("category", ((SnippetPaletteDrawer)item.getCategory()).getId());
        element.setAttribute("class", ((SnippetPaletteItem)item).getClassName());
        element.setAttribute("editorclass", ((SnippetPaletteItem)item).getEditorClassName());
        element.appendChild(this.createContent(doc, item));
        ISnippetVariable[] variables = item.getVariables();
        int i = 0;
        while (i < variables.length) {
            Element variable = this.createVariable(doc, variables[i]);
            element.appendChild(variable);
            ++i;
        }
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("User item writer saving item " + ((SnippetPaletteDrawer)item.getCategory()).getId() + ":" + ((SnippetPaletteItem)item).getId());
        }
        return element;
    }

    protected Element createPluginRecord(Document doc, PluginRecord record) {
        Element element = doc.createElement("plugin");
        element.setAttribute("name", record.getPluginName());
        element.setAttribute("version", record.getPluginVersion());
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("User item writer saving plugin record " + record.getPluginName() + "/" + record.getPluginVersion());
        }
        return element;
    }

    protected Element createVariable(Document doc, ISnippetVariable variable) {
        Element element = doc.createElement("variable");
        element.setAttribute("id", ((SnippetVariable)variable).getId());
        element.setAttribute("name", variable.getName());
        element.setAttribute("default", variable.getDefaultValue());
        element.appendChild(this.createDescription(doc, variable.getDescription()));
        return element;
    }

    public String toXML(ISnippetsEntry entry) {
        Document document = CommonXML.getDocumentBuilder().getDOMImplementation().createDocument(null, "snippets", null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (entry instanceof ISnippetItem) {
            ISnippetItem item = (ISnippetItem)entry;
            Element itemElement = this.createItem(document, item);
            document.getDocumentElement().appendChild(itemElement);
        } else {
            ISnippetCategory category = (ISnippetCategory)entry;
            Element categoryElement = this.createCategory(document, category);
            document.getDocumentElement().appendChild(categoryElement);
        }
        try {
            CommonXML.serialize(document, output);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        String retVal = null;
        try {
            retVal = new String(output.toByteArray(), "utf16");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            retVal = new String(output.toByteArray());
        }
        return retVal;
    }

    public void write(ISnippetCategory category, IFile file) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.write(category, output);
        byte[] array = output.toByteArray();
        try {
            file.setContents((InputStream)new ByteArrayInputStream(array), false, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    public void write(ISnippetCategory category, OutputStream ostream) {
        block11: {
            Document document = this.createDocument(category);
            try {
                try {
                    CommonXML.serialize(document, ostream);
                    ostream.flush();
                }
                catch (IOException e) {
                    Logger.log(4, "could not save " + String.valueOf(ostream), e);
                    try {
                        ostream.close();
                        document = null;
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    ostream.close();
                    document = null;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ostream.close();
                document = null;
            }
            catch (IOException iOException) {}
        }
    }
}

