/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;

public final class SavePresetDialog
extends Dialog {
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private IDialogSettings settings;
    private Text nameTextField;
    private Text descTextField;
    private Label msgLabel;
    private String name;
    private String description;

    protected SavePresetDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public static IPreset showDialog(Shell shell, Set<IProjectFacetVersion> facets) {
        SavePresetDialog dialog = new SavePresetDialog(shell);
        IPreset preset = null;
        if (dialog.open() == 0) {
            String name = dialog.name;
            String desc = dialog.description;
            preset = ProjectFacetsManager.definePreset((String)name, (String)desc, facets);
        }
        return preset;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Resources.dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings root = FacetUiPlugin.getInstance().getDialogSettings();
        IDialogSettings temp = root.getSection(((Object)((Object)this)).getClass().getName());
        if (temp == null) {
            temp = root.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        if (temp.get(WIDTH) == null) {
            temp.put(WIDTH, 300);
        }
        if (temp.get(HEIGHT) == null) {
            temp.put(HEIGHT, 160);
        }
        this.settings = temp;
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = SavePresetDialog.gdfill();
        gd.widthHint = this.settings.getInt(WIDTH);
        gd.heightHint = this.settings.getInt(HEIGHT);
        composite.setLayoutData((Object)gd);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point size = composite.getSize();
                SavePresetDialog.this.settings.put(SavePresetDialog.WIDTH, size.x);
                SavePresetDialog.this.settings.put(SavePresetDialog.HEIGHT, size.y);
            }
        });
        Label nameLabel = new Label(composite, 0);
        nameLabel.setLayoutData((Object)SavePresetDialog.gdhfill());
        nameLabel.setText(Resources.nameLabel);
        this.nameTextField = new Text(composite, 2048);
        this.nameTextField.setLayoutData((Object)SavePresetDialog.gdhfill());
        this.nameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SavePresetDialog.this.handleNameChange();
            }
        });
        Label descLabel = new Label(composite, 0);
        descLabel.setLayoutData((Object)SavePresetDialog.gdhfill());
        descLabel.setText(Resources.descLabel);
        this.descTextField = new Text(composite, 2624);
        this.descTextField.setLayoutData((Object)SavePresetDialog.gdfill());
        this.descTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SavePresetDialog.this.handleDescriptionChange();
            }
        });
        this.msgLabel = new Label(composite, 0);
        this.msgLabel.setLayoutData((Object)SavePresetDialog.gdhfill());
        this.msgLabel.setForeground(SavePresetDialog.color(3));
        this.handleNameChange();
        return composite;
    }

    private void handleNameChange() {
        this.name = this.nameTextField.getText().trim();
        boolean okButtonEnabled = false;
        boolean conflictDetected = false;
        if (this.name.length() > 0) {
            for (IPreset preset : ProjectFacetsManager.getPresets()) {
                if (!preset.getLabel().equals(this.name)) continue;
                conflictDetected = true;
                break;
            }
            if (!conflictDetected) {
                okButtonEnabled = true;
            }
        }
        if (conflictDetected) {
            this.msgLabel.setText(Resources.nameInUseMessage);
        } else {
            this.msgLabel.setText("");
        }
        this.setOkButtonEnabled(okButtonEnabled);
    }

    private void handleDescriptionChange() {
        this.description = this.descTextField.getText().trim();
    }

    private void setOkButtonEnabled(final boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        } else {
            final Display display = Display.getCurrent();
            Thread t = new Thread(){

                @Override
                public void run() {
                    Button b = SavePresetDialog.this.getButton(0);
                    while (b == null) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        b = SavePresetDialog.this.getButton(0);
                    }
                    final Button finalButton = b;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            finalButton.setEnabled(enabled);
                        }
                    });
                }
            };
            t.start();
        }
    }

    private static GridData gdfill() {
        return new GridData(4, 4, true, true);
    }

    private static GridData gdhfill() {
        return new GridData(768);
    }

    public static Color color(int id) {
        return Display.getCurrent().getSystemColor(id);
    }

    private static final class Resources
    extends NLS {
        public static String dialogTitle;
        public static String nameLabel;
        public static String descLabel;
        public static String nameInUseMessage;

        static {
            Resources.initializeMessages((String)SavePresetDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

