/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.contentassist;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.taginfo.MarkupTagInfoProvider;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSFContentAssistProcessor
implements IContentAssistProcessor {
    private ITextRegionContextResolver resolver;
    private ITaglibContextResolver tlResolver;
    private String defaultAdditionalInfo;
    private String defaultIconPath = "/icons/attr_val.gif";
    private ImageDescriptor defaultAttrValImgDesc;
    private MarkupTagInfoProvider fInfoProvider;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentPosition) {
        List proposals = new ArrayList();
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(viewer, documentPosition);
        if (context != null) {
            String regionType;
            this.resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
            if (this.resolver != null && (regionType = this.resolver.getRegionType()) != null && regionType.equals("XML_TAG_ATTRIBUTE_VALUE")) {
                String uri;
                Element tagElement;
                Attr attr;
                this.tlResolver = IStructuredDocumentContextResolverFactory2.INSTANCE.getTaglibContextResolverFromDelegates(context);
                if (this.tlResolver != null && (attr = this.getAttribute(context)) != null && (tagElement = attr.getOwnerElement()) != null && (uri = this.tlResolver.getTagURIForNodeName((Node)tagElement)) != null) {
                    proposals = this.createProposals(context, uri, tagElement, attr);
                }
            }
        }
        return proposals.toArray(new ICompletionProposal[0]);
    }

    private String getDefaultAdditionalInfo(Node tagElement, Attr attr) {
        CMAttributeDeclaration attrNode;
        CMElementDeclaration elementNode;
        if (this.defaultAdditionalInfo == null && (elementNode = this.getCMElementDeclaration(tagElement)) != null && (attrNode = this.getCMAttributeDeclaration(elementNode, attr)) != null) {
            this.defaultAdditionalInfo = this.getInfoProvider().getInfo((CMNode)attrNode);
        }
        return this.defaultAdditionalInfo;
    }

    private CMElementDeclaration getCMElementDeclaration(Node node) {
        ModelQuery modelQuery;
        CMElementDeclaration result = null;
        if (node.getNodeType() == 1 && (modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument())) != null) {
            result = modelQuery.getCMElementDeclaration((Element)node);
        }
        return result;
    }

    private CMAttributeDeclaration getCMAttributeDeclaration(CMElementDeclaration tagElement, Attr attr) {
        CMNamedNodeMap attrs = tagElement.getAttributes();
        for (CMAttributeDeclaration CMAttr : attrs) {
            if (!CMAttr.getAttrName().equals(attr.getName())) continue;
            return CMAttr;
        }
        return null;
    }

    private MarkupTagInfoProvider getInfoProvider() {
        if (this.fInfoProvider == null) {
            this.fInfoProvider = new MarkupTagInfoProvider();
        }
        return this.fInfoProvider;
    }

    private List createProposals(IStructuredDocumentContext context, String uri, Node tagElement, Attr attr) {
        ArrayList ret = new ArrayList();
        List processors = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IPossibleValues.class, context, uri, tagElement.getLocalName(), attr.getLocalName());
        if (processors != null) {
            int i = 0;
            while (i < processors.size()) {
                IPossibleValues p = (IPossibleValues)processors.get(i);
                ret.addAll(this.createProposals(p, tagElement, attr));
                ++i;
            }
        }
        return ret;
    }

    private List createProposals(IPossibleValues p, Node tagElement, Attr attr) {
        ArrayList<CustomCompletionProposal> ret = new ArrayList<CustomCompletionProposal>();
        this.defaultAdditionalInfo = null;
        for (IPossibleValue val : p.getPossibleValues()) {
            if (val == null) continue;
            CustomCompletionProposal proposal = new CustomCompletionProposal(val.getValue(), this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition(val), this.getImage(val), val.getDisplayValue(), null, this.getAdditionalInfo(val, tagElement, attr), 700, true);
            ret.add(proposal);
        }
        return ret;
    }

    private String getAdditionalInfo(IPossibleValue val, Node tagElement, Attr attr) {
        if (val.getAdditionalInformation() != null) {
            return val.getAdditionalInformation();
        }
        return this.getDefaultAdditionalInfo(tagElement, attr);
    }

    private int getReplacementLength() {
        return this.resolver.getRegionText().length() - 2;
    }

    private int getCursorPosition(IPossibleValue val) {
        return val.getValue().length();
    }

    private int getReplacementOffset() {
        return this.resolver.getStartOffset() + 1;
    }

    private Image getImage(IPossibleValue val) {
        ImageDescriptor icon = val.getIcon();
        if (icon == null || icon.equals("")) {
            return this.getDefaultAttributeValueImage();
        }
        return this.getOrCreateImage(icon);
    }

    private Image getOrCreateImage(ImageDescriptor icon) {
        if (icon == null) {
            return null;
        }
        Image img = JSFUiPlugin.getDefault().getImageRegistry().get(icon.toString());
        if (img == null) {
            try {
                img = icon.createImage();
                JSFUiPlugin.getDefault().getImageRegistry().put(icon.toString(), img);
            }
            catch (RuntimeException runtimeException) {}
        }
        return img;
    }

    private Image getDefaultAttributeValueImage() {
        if (this.defaultAttrValImgDesc == null) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.jst.jsf.ui");
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(this.defaultIconPath), null);
            this.defaultAttrValImgDesc = ImageDescriptor.createFromURL((URL)url);
        }
        return this.getOrCreateImage(this.defaultAttrValImgDesc);
    }

    private Attr getAttribute(IStructuredDocumentContext context) {
        Node curNode;
        IDOMContextResolver domResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        if (domResolver != null && (curNode = domResolver.getNode()) instanceof Attr) {
            return (Attr)curNode;
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

