/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public final class JSPUtil {
    private static final String CTYPE_JSPSOURCE = "org.eclipse.jst.jsp.core.jspsource";
    private static final String CTYPE_JSPFRAGMENTSOURCE = "org.eclipse.jst.jsp.core.jspfragmentsource";

    public static boolean isJSPContentType(String contentType) {
        return CTYPE_JSPSOURCE.equals(contentType) || CTYPE_JSPFRAGMENTSOURCE.equals(contentType);
    }

    public static boolean isJSPContentType(IFile file) {
        boolean isJSPSource = JSPUtil.isJSPSource(file);
        if (isJSPSource) {
            return true;
        }
        boolean isJSPFragment = JSPUtil.isJSPFragment(file);
        return isJSPFragment;
    }

    private JSPUtil() {
    }

    public static boolean isJSPSource(IFile file) {
        return JSPUtil.isAssociatedWithContentType(file, CTYPE_JSPSOURCE);
    }

    public static boolean isJSPFragment(IFile file) {
        return JSPUtil.isAssociatedWithContentType(file, CTYPE_JSPFRAGMENTSOURCE);
    }

    private static boolean isAssociatedWithContentType(IFile file, String contentType) {
        IContentTypeManager typeManager = Platform.getContentTypeManager();
        IContentType jspContentType = typeManager.getContentType(contentType);
        return jspContentType != null && jspContentType.isAssociatedWith(file.getName());
    }
}

