/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CharArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

public final class TypeDeclarationTools {
    private static final String[] JAVA_LANG_CLASS_NAMES_ARRAY_5 = ArrayTools.sort(new String[]{"AbstractMethodError", "Appendable", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "AssertionError", "Boolean", "Byte", "Character", "Character.Subset", "Character.UnicodeBlock", "CharSequence", "Class", "ClassCastException", "ClassCircularityError", "ClassFormatError", "ClassLoader", "ClassNotFoundException", "Cloneable", "CloneNotSupportedException", "Comparable", "Compiler", "Deprecated", "Double", "Enum", "EnumConstantNotPresentException", "Error", "Exception", "ExceptionInInitializerError", "Float", "IllegalAccessError", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IncompatibleClassChangeError", "IndexOutOfBoundsException", "InheritableThreadLocal", "InstantiationError", "InstantiationException", "Integer", "InternalError", "InterruptedException", "Iterable", "LinkageError", "Long", "Math", "NegativeArraySizeException", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchFieldException", "NoSuchMethodError", "NoSuchMethodException", "NullPointerException", "Number", "NumberFormatException", "Object", "OutOfMemoryError", "Override", "Package", "Process", "ProcessBuilder", "Readable", "Runnable", "Runtime", "RuntimeException", "RuntimePermission", "SecurityException", "SecurityManager", "Short", "StackOverflowError", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "StringIndexOutOfBoundsException", "SuppressWarnings", "System", "Thread", "Thread.State", "Thread.UncaughtExceptionHandler", "ThreadDeath", "ThreadGroup", "ThreadLocal", "Throwable", "TypeNotPresentException", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "UnsupportedOperationException", "VerifyError", "VirtualMachineError", "Void"});
    public static final Iterable<String> JAVA_LANG_CLASS_NAMES_5 = IterableTools.iterable(JAVA_LANG_CLASS_NAMES_ARRAY_5);
    private static final String[] JAVA_LANG_CLASS_NAMES_ARRAY_6 = JAVA_LANG_CLASS_NAMES_ARRAY_5;
    public static final Iterable<String> JAVA_LANG_CLASS_NAMES_6 = IterableTools.iterable(JAVA_LANG_CLASS_NAMES_ARRAY_6);
    private static final String[] JAVA_LANG_CLASS_NAMES_ARRAY_7 = ArrayTools.sort(ArrayTools.concatenate(JAVA_LANG_CLASS_NAMES_ARRAY_6, {"AutoCloseable", "BootstrapMethodError", "Character.UnicodeScript", "ClassValue", "ProcessBuilder.Redirect", "ProcessBuilder.Redirect.Type", "ReflectiveOperationException", "SafeVarargs"}));
    public static final Iterable<String> JAVA_LANG_CLASS_NAMES_7 = IterableTools.iterable(JAVA_LANG_CLASS_NAMES_ARRAY_7);
    private static final String[] JAVA_LANG_CLASS_NAMES_ARRAY_8 = ArrayTools.sort(ArrayTools.concatenate(JAVA_LANG_CLASS_NAMES_ARRAY_7, {"FunctionalInterface"}));
    public static final Iterable<String> JAVA_LANG_CLASS_NAMES_8 = IterableTools.iterable(JAVA_LANG_CLASS_NAMES_ARRAY_8);
    private static final String[] JAVA_LANG_CLASS_NAMES_ARRAY_11 = ArrayTools.sort(ArrayTools.concatenate(JAVA_LANG_CLASS_NAMES_ARRAY_8, {"ProcessHandle", "ProcessHandle.Info", "StackWalker.StackFrame", "System.Logger", "Module", "ModuleLayer", "ModuleLayer.Controller", "Runtime.Version", "StackWalker", "System.LoggerFinder", "StackWalker.Option", "System.Logger.Level", "IllegalCallerException", "LayerInstantiationException"}));
    public static final Iterable<String> JAVA_LANG_CLASS_NAMES_11 = IterableTools.iterable(JAVA_LANG_CLASS_NAMES_ARRAY_11);
    private static final String[] JAVA_LANG_CLASS_NAMES_ARRAY = JAVA_LANG_CLASS_NAMES_ARRAY_11;
    public static final Iterable<String> JAVA_LANG_CLASS_NAMES = IterableTools.iterable(JAVA_LANG_CLASS_NAMES_ARRAY);

    public static boolean isArray(String typeDeclaration) {
        return TypeDeclarationTools.isArray_(StringTools.removeAllWhitespace(typeDeclaration));
    }

    private static boolean isArray_(String typeDeclaration) {
        return StringTools.last(typeDeclaration) == ']';
    }

    public static boolean isArray(char[] typeDeclaration) {
        return TypeDeclarationTools.isArray_(CharArrayTools.removeAllWhitespace(typeDeclaration));
    }

    private static boolean isArray_(char[] typeDeclaration) {
        return CharArrayTools.last(typeDeclaration) == ']';
    }

    public static int arrayDepth(String typeDeclaration) {
        return TypeDeclarationTools.arrayDepth_(StringTools.removeAllWhitespace(typeDeclaration));
    }

    static int arrayDepth_(String typeDeclaration) {
        int last = typeDeclaration.length() - 1;
        int depth = 0;
        int close = last;
        while (typeDeclaration.charAt(close) == ']') {
            if (typeDeclaration.charAt(close - 1) != '[') {
                throw new IllegalArgumentException("invalid type declaration: " + typeDeclaration);
            }
            close = last - (++depth << 1);
        }
        return depth;
    }

    public static int arrayDepth(char[] typeDeclaration) {
        return TypeDeclarationTools.arrayDepth_(CharArrayTools.removeAllWhitespace(typeDeclaration));
    }

    static int arrayDepth_(char[] typeDeclaration) {
        int last = typeDeclaration.length - 1;
        int depth = 0;
        int close = last;
        while (typeDeclaration[close] == ']') {
            if (typeDeclaration[close - 1] != '[') {
                throw new IllegalArgumentException("invalid type declaration: " + String.copyValueOf(typeDeclaration));
            }
            close = last - (++depth << 1);
        }
        return depth;
    }

    public static String elementTypeName(String typeDeclaration) {
        typeDeclaration = StringTools.removeAllWhitespace(typeDeclaration);
        return TypeDeclarationTools.elementTypeName_(typeDeclaration, TypeDeclarationTools.arrayDepth_(typeDeclaration));
    }

    public static char[] elementTypeName(char[] typeDeclaration) {
        typeDeclaration = CharArrayTools.removeAllWhitespace(typeDeclaration);
        return TypeDeclarationTools.elementTypeName_(typeDeclaration, TypeDeclarationTools.arrayDepth_(typeDeclaration));
    }

    public static String elementTypeName(String typeDeclaration, int arrayDepth) {
        return TypeDeclarationTools.elementTypeName_(StringTools.removeAllWhitespace(typeDeclaration), arrayDepth);
    }

    static String elementTypeName_(String typeDeclaration, int arrayDepth) {
        return typeDeclaration.substring(0, typeDeclaration.length() - (arrayDepth << 1));
    }

    public static char[] elementTypeName(char[] typeDeclaration, int arrayDepth) {
        return TypeDeclarationTools.elementTypeName_(CharArrayTools.removeAllWhitespace(typeDeclaration), arrayDepth);
    }

    static char[] elementTypeName_(char[] typeDeclaration, int arrayDepth) {
        return ArrayTools.subArray(typeDeclaration, 0, typeDeclaration.length - (arrayDepth << 1));
    }

    public static String componentTypeDeclaration(String typeDeclaration) {
        return TypeDeclarationTools.componentTypeDeclaration_(StringTools.removeAllWhitespace(typeDeclaration));
    }

    private static String componentTypeDeclaration_(String typeDeclaration) {
        int arrayDepth = TypeDeclarationTools.arrayDepth_(typeDeclaration);
        return arrayDepth == 0 ? null : TypeDeclarationTools.elementTypeName_(typeDeclaration, 1);
    }

    public static char[] componentTypeDeclaration(char[] typeDeclaration) {
        return TypeDeclarationTools.componentTypeDeclaration_(CharArrayTools.removeAllWhitespace(typeDeclaration));
    }

    private static char[] componentTypeDeclaration_(char[] typeDeclaration) {
        int arrayDepth = TypeDeclarationTools.arrayDepth_(typeDeclaration);
        return arrayDepth == 0 ? null : TypeDeclarationTools.elementTypeName_(typeDeclaration, 1);
    }

    public static String className(String typeDeclaration) {
        return TypeDeclarationTools.className_(StringTools.removeAllWhitespace(typeDeclaration));
    }

    private static String className_(String typeDeclaration) {
        int arrayDepth = TypeDeclarationTools.arrayDepth_(typeDeclaration);
        String elementTypeName = TypeDeclarationTools.elementTypeName_(typeDeclaration, arrayDepth);
        return TypeDeclarationTools.className(elementTypeName, arrayDepth);
    }

    public static char[] className(char[] typeDeclaration) {
        return TypeDeclarationTools.className_(CharArrayTools.removeAllWhitespace(typeDeclaration));
    }

    private static char[] className_(char[] typeDeclaration) {
        int arrayDepth = TypeDeclarationTools.arrayDepth_(typeDeclaration);
        char[] elementTypeName = TypeDeclarationTools.elementTypeName_(typeDeclaration, arrayDepth);
        return TypeDeclarationTools.className(elementTypeName, arrayDepth);
    }

    public static String className(String elementTypeName, int arrayDepth) {
        if (arrayDepth == 0) {
            return elementTypeName;
        }
        if (elementTypeName.equals(ClassNameTools.VOID)) {
            throw new IllegalArgumentException(String.valueOf('\'') + ClassNameTools.VOID + "' must have an array depth of zero: " + arrayDepth + '.');
        }
        StringBuilder sb = new StringBuilder(100);
        int i = arrayDepth;
        while (i-- > 0) {
            sb.append('[');
        }
        char prim = ClassNameTools.primitiveClassCode(elementTypeName);
        if (prim == '\u0000') {
            ClassNameTools.appendReferenceNameTo(elementTypeName, sb);
        } else {
            sb.append(prim);
        }
        return sb.toString();
    }

    public static char[] className(char[] elementTypeName, int arrayDepth) {
        if (arrayDepth == 0) {
            return elementTypeName;
        }
        if (Arrays.equals(elementTypeName, ClassNameTools.VOID_CHAR_ARRAY)) {
            throw new IllegalArgumentException(String.valueOf('\'') + ClassNameTools.VOID + "' must have an array depth of zero: " + arrayDepth + '.');
        }
        StringBuilder sb = new StringBuilder(100);
        int i = arrayDepth;
        while (i-- > 0) {
            sb.append('[');
        }
        char prim = ClassNameTools.primitiveClassCode(elementTypeName);
        if (prim == '\u0000') {
            ClassNameTools.appendReferenceNameTo(elementTypeName, sb);
        } else {
            sb.append(prim);
        }
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static String simpleName(String typeDeclaration) {
        return TypeDeclarationTools.simpleName_(StringTools.removeAllWhitespace(typeDeclaration));
    }

    private static String simpleName_(String typeDeclaration) {
        return typeDeclaration.substring(typeDeclaration.lastIndexOf(46) + 1);
    }

    public static char[] simpleName(char[] typeDeclaration) {
        return TypeDeclarationTools.simpleName_(CharArrayTools.removeAllWhitespace(typeDeclaration));
    }

    private static char[] simpleName_(char[] typeDeclaration) {
        return ArrayTools.subArray(typeDeclaration, ArrayTools.lastIndexOf(typeDeclaration, '.') + 1);
    }

    public static String packageName(String typeDeclaration) {
        return TypeDeclarationTools.packageName_(StringTools.removeAllWhitespace(typeDeclaration));
    }

    private static String packageName_(String typeDeclaration) {
        if (TypeDeclarationTools.isArray_(typeDeclaration)) {
            return "";
        }
        int lastPeriod = typeDeclaration.lastIndexOf(46);
        return lastPeriod == -1 ? "" : typeDeclaration.substring(0, lastPeriod);
    }

    public static char[] packageName(char[] typeDeclaration) {
        return TypeDeclarationTools.packageName_(CharArrayTools.removeAllWhitespace(typeDeclaration));
    }

    private static char[] packageName_(char[] typeDeclaration) {
        if (TypeDeclarationTools.isArray_(typeDeclaration)) {
            return CharArrayTools.EMPTY_CHAR_ARRAY;
        }
        int lastPeriod = ArrayTools.lastIndexOf(typeDeclaration, '.');
        return lastPeriod == -1 ? CharArrayTools.EMPTY_CHAR_ARRAY : ArrayTools.subArray(typeDeclaration, 0, lastPeriod);
    }

    public static boolean isJavaLangClass(String simpleClassName) {
        return ArrayTools.binarySearch(JAVA_LANG_CLASS_NAMES_ARRAY, simpleClassName);
    }

    public static boolean isJavaLangClass(char[] simpleClassName) {
        return TypeDeclarationTools.isJavaLangClass(String.copyValueOf(simpleClassName));
    }

    public static boolean isJavaLangClass5(String simpleClassName) {
        return ArrayTools.binarySearch(JAVA_LANG_CLASS_NAMES_ARRAY_5, simpleClassName);
    }

    public static boolean isJavaLangClass5(char[] simpleClassName) {
        return TypeDeclarationTools.isJavaLangClass5(String.copyValueOf(simpleClassName));
    }

    public static boolean isJavaLangClass6(String simpleClassName) {
        return ArrayTools.binarySearch(JAVA_LANG_CLASS_NAMES_ARRAY_6, simpleClassName);
    }

    public static boolean isJavaLangClass6(char[] simpleClassName) {
        return TypeDeclarationTools.isJavaLangClass6(String.copyValueOf(simpleClassName));
    }

    public static boolean isJavaLangClass7(String simpleClassName) {
        return ArrayTools.binarySearch(JAVA_LANG_CLASS_NAMES_ARRAY_7, simpleClassName);
    }

    public static boolean isJavaLangClass7(char[] simpleClassName) {
        return TypeDeclarationTools.isJavaLangClass7(String.copyValueOf(simpleClassName));
    }

    public static boolean isJavaLangClass8(String simpleClassName) {
        return ArrayTools.binarySearch(JAVA_LANG_CLASS_NAMES_ARRAY_8, simpleClassName);
    }

    public static boolean isJavaLangClass8(char[] simpleClassName) {
        return TypeDeclarationTools.isJavaLangClass8(String.copyValueOf(simpleClassName));
    }

    public static boolean isJavaLangClass11(String simpleClassName) {
        return ArrayTools.binarySearch(JAVA_LANG_CLASS_NAMES_ARRAY_11, simpleClassName);
    }

    public static boolean isJavaLangClass11(char[] simpleClassName) {
        return TypeDeclarationTools.isJavaLangClass11(String.copyValueOf(simpleClassName));
    }

    public static Class<?> loadClass(String typeDeclaration) {
        return ClassTools.forTypeDeclaration(typeDeclaration);
    }

    public static Class<?> loadClass(String typeDeclaration, ClassLoader classLoader) {
        return ClassTools.forTypeDeclaration(typeDeclaration, classLoader);
    }

    public static Class<?> loadClass_(String typeDeclaration) throws ClassNotFoundException {
        return ClassTools.forTypeDeclaration_(typeDeclaration);
    }

    public static Class<?> loadClass_(String typeDeclaration, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassTools.forTypeDeclaration_(typeDeclaration, classLoader);
    }

    public static Class<?> loadClass(char[] typeDeclaration) {
        return ClassTools.forTypeDeclaration(typeDeclaration);
    }

    public static Class<?> loadClass(char[] typeDeclaration, ClassLoader classLoader) {
        return ClassTools.forTypeDeclaration(typeDeclaration, classLoader);
    }

    public static Class<?> loadClass_(char[] typeDeclaration) throws ClassNotFoundException {
        return ClassTools.forTypeDeclaration_(typeDeclaration);
    }

    public static Class<?> loadClass_(char[] typeDeclaration, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassTools.forTypeDeclaration_(typeDeclaration, classLoader);
    }

    private TypeDeclarationTools() {
        throw new UnsupportedOperationException();
    }
}

