/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.util.Locale;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionScanner;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public abstract class AbstractCompletionTest
extends AbstractCompilerTest {
    public static final String NONE = "<NONE>";

    public AbstractCompletionTest(String testName) {
        super(testName);
    }

    public void checkDietParse(char[] source, int cursorLocation, String expectedCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        this.checkDietParse(source, cursorLocation, expectedCompletion, null, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, testName);
    }

    public void checkDietParse(char[] source, int cursorLocation, String expectedCompletion, String expectedParentCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        char[] chars;
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration unit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult, cursorLocation);
        String computedCompletion = parser.assistNode == null ? NONE : parser.assistNode.toString();
        String computedParentCompletion = parser.assistNodeParent == null ? NONE : parser.assistNodeParent.toString();
        String computedUnitToString = unit.toString();
        if (!expectedCompletion.equals(computedCompletion)) {
            System.out.println(Util.displayString(computedCompletion));
        }
        AbstractCompletionTest.assertEquals("invalid completion node-" + testName, expectedCompletion, computedCompletion);
        if (expectedParentCompletion != null) {
            if (!expectedParentCompletion.equals(computedParentCompletion)) {
                System.out.println(Util.displayString(computedParentCompletion));
            }
            AbstractCompletionTest.assertEquals("invalid completion parent node-" + testName, expectedParentCompletion, computedParentCompletion);
        }
        if (!expectedUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AbstractCompletionTest.assertEquals("invalid completion tree-" + testName, expectedUnitToString, computedUnitToString);
        if (expectedCompletionIdentifier != null) {
            chars = ((CompletionScanner)parser.scanner).completionIdentifier;
            String computedCompletionIdentifier = chars == null ? NONE : new String(chars);
            AbstractCompletionTest.assertEquals("invalid completion identifier-" + testName, expectedCompletionIdentifier, computedCompletionIdentifier);
        }
        if (expectedReplacedSource != null) {
            chars = null;
            if (parser.assistNode != null) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)parser.assistNode.sourceStart, (int)(parser.assistNode.sourceEnd + 1));
            } else if (parser.assistIdentifier() != null && ((CompletionScanner)parser.scanner).completedIdentifierEnd >= ((CompletionScanner)parser.scanner).completedIdentifierStart) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)((CompletionScanner)parser.scanner).completedIdentifierStart, (int)(((CompletionScanner)parser.scanner).completedIdentifierEnd + 1));
            }
            String computedReplacedSource = chars == null ? NONE : new String(chars);
            AbstractCompletionTest.assertEquals("invalid replaced source-" + testName, expectedReplacedSource, computedReplacedSource);
        }
    }

    public void checkMethodParse(char[] source, int cursorLocation, String expectedCompletion, String expectedParentCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String[] expectedLabels, String testName) {
        char[] chars;
        AbstractCompletionTest.assertTrue((String)"bad cursor location", (cursorLocation >= 0 ? 1 : 0) != 0);
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration unit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult, cursorLocation);
        String computedCompletion = parser.assistNode == null ? NONE : parser.assistNode.toString();
        String computedParentCompletion = parser.assistNodeParent == null ? NONE : parser.assistNodeParent.toString();
        String computedUnitToString = unit.toString();
        if (!expectedCompletion.equals(computedCompletion)) {
            System.out.println(Util.displayString(computedCompletion));
        }
        AbstractCompletionTest.assertEquals("invalid completion node-" + testName, expectedCompletion, computedCompletion);
        if (expectedParentCompletion != null) {
            if (!expectedParentCompletion.equals(computedParentCompletion)) {
                System.out.println(Util.displayString(computedParentCompletion));
            }
            AbstractCompletionTest.assertEquals("invalid completion parent node-" + testName, expectedParentCompletion, computedParentCompletion);
        }
        if (!expectedUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        AbstractCompletionTest.assertEquals("invalid completion location-" + testName, expectedUnitToString, computedUnitToString);
        if (expectedCompletionIdentifier != null) {
            String computedCompletionIdentifier;
            chars = ((CompletionScanner)parser.scanner).completionIdentifier;
            String string = computedCompletionIdentifier = chars == null ? NONE : new String(chars);
            if (!expectedCompletionIdentifier.equals(computedCompletionIdentifier)) {
                System.out.println(Util.displayString(computedCompletionIdentifier));
            }
            AbstractCompletionTest.assertEquals("invalid completion identifier-" + testName, expectedCompletionIdentifier, computedCompletionIdentifier);
        }
        if (expectedReplacedSource != null) {
            String computedReplacedSource;
            chars = null;
            if (parser.assistNode != null) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)parser.assistNode.sourceStart, (int)(parser.assistNode.sourceEnd + 1));
            } else if (parser.assistIdentifier() != null && ((CompletionScanner)parser.scanner).completedIdentifierEnd >= ((CompletionScanner)parser.scanner).completedIdentifierStart) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)((CompletionScanner)parser.scanner).completedIdentifierStart, (int)(((CompletionScanner)parser.scanner).completedIdentifierEnd + 1));
            }
            String string = computedReplacedSource = chars == null ? NONE : new String(chars);
            if (!expectedReplacedSource.equals(computedReplacedSource)) {
                System.out.println(Util.displayString(computedReplacedSource));
            }
            AbstractCompletionTest.assertEquals("invalid replaced source-" + testName, expectedReplacedSource, computedReplacedSource);
            if (expectedReplacedSource.length() == 0) {
                AbstractCompletionTest.assertEquals((String)("invalid insertion point-" + testName), (int)(cursorLocation + 1), (int)parser.assistNode.sourceStart);
            }
        }
    }

    public void checkMethodParse(char[] source, int cursorLocation, String expectedCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        this.checkMethodParse(source, cursorLocation, expectedCompletion, null, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, null, testName);
    }

    public void checkMethodParse(char[] source, int cursorLocation, String expectedCompletion, String expectedParentCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        this.checkMethodParse(source, cursorLocation, expectedCompletion, expectedParentCompletion, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, null, testName);
    }

    public void checkMethodParse(char[] source, int cursorLocation, String expectedCompletion, String expectedUnitToString, String expectedCompletionIdentifier, String expectedReplacedSource, String[] expectedLabels, String testName) {
        this.checkMethodParse(source, cursorLocation, expectedCompletion, null, expectedUnitToString, expectedCompletionIdentifier, expectedReplacedSource, expectedLabels, testName);
    }

    private ASTNode findMethod(TypeDeclaration type, int cursorLocation) {
        int i;
        if (type.methods != null) {
            i = 0;
            while (i < type.methods.length) {
                AbstractMethodDeclaration method = type.methods[i];
                if (method.declarationSourceStart <= cursorLocation && (cursorLocation <= method.declarationSourceEnd || method.declarationSourceEnd == 0)) {
                    return method;
                }
                ++i;
            }
        }
        if (type.memberTypes != null) {
            i = 0;
            while (i < type.memberTypes.length) {
                TypeDeclaration memberType = type.memberTypes[i];
                ASTNode method = this.findMethod(memberType, cursorLocation);
                if (method != null) {
                    return method;
                }
                ++i;
            }
        }
        if (type.fields != null) {
            i = 0;
            while (i < type.fields.length) {
                FieldDeclaration field = type.fields[i];
                if (field instanceof Initializer && field.declarationSourceStart <= cursorLocation && (cursorLocation <= field.declarationSourceEnd || field.declarationSourceEnd == 0)) {
                    return type;
                }
                ++i;
            }
        }
        return null;
    }

    protected void runTestCheckDietParse(String compilationUnit, String completeBehind, String expectedCompletionNodeToString, String expectedUnitDisplayString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        int cursorLocation = compilationUnit.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkDietParse(compilationUnit.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, expectedCompletionIdentifier, expectedReplacedSource, testName);
    }

    protected void runTestCheckMethodParse(String compilationUnit, String completeBehind, String expectedCompletionNodeToString, String expectedUnitDisplayString, String expectedCompletionIdentifier, String expectedReplacedSource, String[] expectedLabels, String testName) {
        int completeBehindStart = compilationUnit.indexOf(completeBehind);
        AbstractCompletionTest.assertTrue((String)"completeBehind string not found", (completeBehindStart >= 0 ? 1 : 0) != 0);
        int cursorLocation = completeBehindStart + completeBehind.length() - 1;
        this.checkMethodParse(compilationUnit.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, expectedCompletionIdentifier, expectedReplacedSource, expectedLabels, testName);
    }

    protected void runTestCheckMethodParse(String compilationUnit, String completeBehind, String expectedCompletionNodeToString, String expectedUnitDisplayString, String expectedCompletionIdentifier, String expectedReplacedSource, String testName) {
        this.runTestCheckMethodParse(compilationUnit, completeBehind, expectedCompletionNodeToString, expectedUnitDisplayString, expectedCompletionIdentifier, expectedReplacedSource, null, testName);
    }
}

