/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPTemplateCompletionProcessor;
import org.eclipse.jst.jsp.ui.internal.templates.TemplateContextTypeIdsJSP;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.DefaultXMLCompletionProposalComputer;

public class JSPTemplatesCompletionProposalComputer
extends DefaultXMLCompletionProposalComputer {
    private JSPTemplateCompletionProcessor fTemplateProcessor = new JSPTemplateCompletionProcessor();

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        ArrayList proposals = new ArrayList(super.computeCompletionProposals(context, monitor));
        proposals.addAll(this.getTemplateProposals(TemplateContextTypeIdsJSP.ALL, context));
        return proposals;
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsJSP.ATTRIBUTE, context);
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsJSP.ATTRIBUTE_VALUE, context);
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsJSP.TAG, context);
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        if (ContentTypeIdForJSP.ContentTypeID_JSPTAG.equals(((IDOMNode)contentAssistRequest.getNode()).getModel().getContentTypeIdentifier())) {
            this.addTemplates(contentAssistRequest, "tag_new", context);
        } else {
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsJSP.NEW, context);
        }
    }

    private List getTemplateProposals(String templateContext, CompletionProposalInvocationContext context) {
        ArrayList<ICompletionProposal> templateProposals = new ArrayList<ICompletionProposal>();
        if (this.fTemplateProcessor != null) {
            this.fTemplateProcessor.setContextType(templateContext);
            ICompletionProposal[] proposals = this.fTemplateProcessor.computeCompletionProposals(context.getViewer(), context.getInvocationOffset());
            templateProposals.addAll(Arrays.asList(proposals));
        }
        return templateProposals;
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String templateContext, CompletionProposalInvocationContext context) {
        if (contentAssistRequest != null) {
            boolean useProposalList = !contentAssistRequest.shouldSeparate();
            List proposals = this.getTemplateProposals(templateContext, context);
            int i = 0;
            while (i < proposals.size()) {
                if (useProposalList) {
                    contentAssistRequest.addProposal((ICompletionProposal)proposals.get(i));
                } else {
                    contentAssistRequest.addMacro((ICompletionProposal)proposals.get(i));
                }
                ++i;
            }
        }
    }
}

