/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective;

import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.wsdl.Service;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.wst.ws.internal.datamodel.BasicModel;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Perspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.DirUtils;
import org.eclipse.wst.ws.internal.explorer.platform.util.URLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.OpenWSDLAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.SwitchPerspectiveFromWSDLAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.UpdateWSDLBindingAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLBindingElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.SOAPMessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLMainNode;
import org.eclipse.xsd.impl.XSDPackageImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;

public class WSDLPerspective
extends Perspective {
    public static final int STATUS_CONTENT_DEFAULT = 0;
    public static final int STATUS_CONTENT_RESULT_FORM = 1;
    public static final int STATUS_CONTENT_RESULT_SOURCE = 2;
    private BasicModel model_;
    private NodeManager nodeManager_;
    private String perspectiveContentFramesetCols_;
    private String savedPerspectiveContentFramesetCols_;
    private String actionsContainerFramesetRows_;
    private String savedActionsContainerFramesetRows_;
    private int statusContentType_;
    private SOAPMessageQueue soapRequestQueue_;
    private SOAPMessageQueue soapResponseQueue_;
    private Node operationNode_;

    static {
        new ResourceFactoryRegistryImpl().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        EcorePackageImpl.init();
        XSDPackageImpl.init();
    }

    public WSDLPerspective(Controller controller) {
        super("wsdl", controller);
    }

    @Override
    public final void initPerspective(ServletContext application) {
        this.model_ = new BasicModel("wsdlModel");
        TreeElement treeElement = new TreeElement(this.getMessage("NODE_NAME_WSDL_MAIN"), (Model)this.model_);
        this.model_.setRootElement((Element)treeElement);
        this.nodeManager_ = new NodeManager(this.controller_);
        WSDLMainNode wsdlMainNode = new WSDLMainNode(treeElement, this.nodeManager_);
        this.nodeManager_.setRootNode(wsdlMainNode);
        this.perspectiveContentFramesetCols_ = !DirUtils.isRTL() ? "30%,*" : "*,30%";
        this.savedPerspectiveContentFramesetCols_ = this.perspectiveContentFramesetCols_;
        this.savedActionsContainerFramesetRows_ = this.actionsContainerFramesetRows_ = "75%,*";
        this.statusContentType_ = 0;
        this.soapRequestQueue_ = new SOAPMessageQueue();
        this.soapResponseQueue_ = new SOAPMessageQueue();
        this.operationNode_ = null;
    }

    public final void preloadWSDL(String[] wsdlURLs) {
        if (wsdlURLs != null) {
            int i = 0;
            while (i < wsdlURLs.length) {
                OpenWSDLAction openWSDLAction = new OpenWSDLAction(this.controller_);
                Hashtable propertyTable = openWSDLAction.getPropertyTable();
                String decodedWSDLURL = URLUtils.decode(wsdlURLs[i]);
                propertyTable.put("wsdlURL", decodedWSDLURL);
                openWSDLAction.run();
                ++i;
            }
            if (wsdlURLs.length > 0) {
                this.controller_.setCurrentPerspective(2);
            }
        }
    }

    public final void preloadEndpoints(String[] wsdlURLs, String[] endpoints) {
        if (wsdlURLs != null && wsdlURLs.length > 0 && endpoints != null && endpoints.length > 0) {
            String wsdlURL = wsdlURLs[0];
            Vector wsdlNodes = this.nodeManager_.getRootNode().getChildNodes();
            for (Node wsdlNode : wsdlNodes) {
                if (!wsdlNode.getNodeName().equals(wsdlURL)) continue;
                Vector serviceNodes = wsdlNode.getChildNodes();
                for (Node serviceNode : serviceNodes) {
                    Vector bindingNodes = serviceNode.getChildNodes();
                    String[] nodeIds = new String[bindingNodes.size()];
                    int i = 0;
                    while (i < nodeIds.length) {
                        nodeIds[i] = String.valueOf(((Node)bindingNodes.get(i)).getNodeId());
                        ++i;
                    }
                    UpdateWSDLBindingAction action = new UpdateWSDLBindingAction(this.controller_);
                    Hashtable<String, String[]> propertyTable = new Hashtable<String, String[]>();
                    propertyTable.put("nodeId", nodeIds);
                    propertyTable.put("::endPoint", endpoints);
                    action.setPropertyTable(propertyTable);
                    action.execute(false);
                }
                return;
            }
        }
    }

    public final void preselectServiceOrBinding(String[] wsdlURLs, String[] serviceQNameStrings, String[] bindingNameStrings) {
        if (wsdlURLs != null && wsdlURLs.length > 0) {
            String wsdlURL = wsdlURLs[0];
            if (serviceQNameStrings != null && serviceQNameStrings.length > 0) {
                this.preselectService(wsdlURL, serviceQNameStrings[0]);
            } else if (bindingNameStrings != null && bindingNameStrings.length > 0) {
                this.preselectBinding(wsdlURL, bindingNameStrings[0]);
            }
        }
    }

    private final void preselectService(String wsdlURL, String serviceQNameString) {
        Vector wsdlNodes = this.nodeManager_.getRootNode().getChildNodes();
        int i = 0;
        while (i < wsdlNodes.size()) {
            Node wsdlNode = (Node)wsdlNodes.elementAt(i);
            if (wsdlNode.getNodeName().equals(wsdlURL)) {
                Vector serviceNodes = wsdlNode.getChildNodes();
                int j = 0;
                while (j < serviceNodes.size()) {
                    Node serviceNode = (Node)serviceNodes.elementAt(j);
                    WSDLServiceElement serviceElement = (WSDLServiceElement)serviceNode.getTreeElement();
                    Service service = serviceElement.getService();
                    if (service.getQName().toString().equals(serviceQNameString)) {
                        this.nodeManager_.setSelectedNodeId(serviceNode.getNodeId());
                        this.nodeManager_.makeSelectedNodeVisible();
                        this.controller_.setCurrentPerspective(2);
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private final void preselectBinding(String wsdlURL, String bindingNameString) {
        Vector wsdlNodes = this.nodeManager_.getRootNode().getChildNodes();
        int i = 0;
        while (i < wsdlNodes.size()) {
            Node wsdlNode = (Node)wsdlNodes.elementAt(i);
            if (wsdlNode.getNodeName().equals(wsdlURL)) {
                Vector serviceNodes = wsdlNode.getChildNodes();
                int j = 0;
                while (j < serviceNodes.size()) {
                    Node serviceNode = (Node)serviceNodes.elementAt(j);
                    Vector bindingNodes = serviceNode.getChildNodes();
                    int k = 0;
                    while (k < bindingNodes.size()) {
                        Node bindingNode = (Node)bindingNodes.elementAt(k);
                        WSDLBindingElement bindingElement = (WSDLBindingElement)bindingNode.getTreeElement();
                        if (bindingElement.getBinding().getQName().toString().equals(bindingNameString)) {
                            this.nodeManager_.setSelectedNodeId(bindingNode.getNodeId());
                            this.nodeManager_.makeSelectedNodeVisible();
                            this.controller_.setCurrentPerspective(2);
                            return;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager_;
    }

    @Override
    public String getPerspectiveContentPage() {
        return "wsdl/wsdl_perspective_content.jsp";
    }

    @Override
    public int getPerspectiveId() {
        return 2;
    }

    @Override
    public String getPanesFile() {
        return "wsdl/scripts/wsdlpanes.jsp";
    }

    @Override
    public String getFramesetsFile() {
        return "wsdl/scripts/wsdlframesets.jsp";
    }

    @Override
    public String getProcessFramesetsForm() {
        return "wsdl/forms/ProcessWSDLFramesetsForm.jsp";
    }

    @Override
    public String getTreeContentVar() {
        return "wsdlNavigatorContent";
    }

    @Override
    public String getTreeContentPage() {
        return "wsdl/wsdl_navigator_content.jsp";
    }

    @Override
    public String getPropertiesContainerVar() {
        return "wsdlPropertiesContainer";
    }

    @Override
    public String getPropertiesContainerPage() {
        return "wsdl/wsdl_properties_container.jsp";
    }

    @Override
    public String getStatusContentVar() {
        return "wsdlStatusContent";
    }

    @Override
    public String getStatusContentPage() {
        return "wsdl/wsdl_status_content.jsp";
    }

    public final String getPerspectiveContentFramesetCols() {
        return this.perspectiveContentFramesetCols_;
    }

    public final void setPerspectiveContentFramesetCols(String cols) {
        this.perspectiveContentFramesetCols_ = cols;
    }

    public final void setSavedPerspectiveContentFramesetCols(String cols) {
        this.savedPerspectiveContentFramesetCols_ = cols;
    }

    public final String getSavedPerspectiveContentFramesetCols() {
        return this.savedPerspectiveContentFramesetCols_;
    }

    public final String getActionsContainerFramesetRows() {
        return this.actionsContainerFramesetRows_;
    }

    public final void setActionsContainerFramesetRows(String rows) {
        this.actionsContainerFramesetRows_ = rows;
    }

    public final void setSavedActionsContainerFramesetRows(String rows) {
        this.savedActionsContainerFramesetRows_ = rows;
    }

    public final String getSavedActionsContainerFramesetRows() {
        return this.savedActionsContainerFramesetRows_;
    }

    @Override
    public final String getSwitchPerspectiveFormActionLink(int targetPerspectiveId, boolean forHistory) {
        return SwitchPerspectiveFromWSDLAction.getFormActionLink(targetPerspectiveId, forHistory);
    }

    public final int getStatusContentType() {
        return this.statusContentType_;
    }

    public final void setStatusContentType(int statusContentType) {
        this.statusContentType_ = statusContentType;
    }

    public final SOAPMessageQueue getSOAPRequestQueue() {
        return this.soapRequestQueue_;
    }

    public final SOAPMessageQueue getSOAPResponseQueue() {
        return this.soapResponseQueue_;
    }

    public final Node getOperationNode() {
        return this.operationNode_;
    }

    public final void setOperationNode(Node operationNode) {
        this.operationNode_ = operationNode;
    }

    public final String getSOAPEnvelopeXMLLink(int soapEnvelopeType) {
        StringBuffer link = new StringBuffer("wsdl/soap_envelope_xml.jsp?");
        link.append("soapEnvelopeType").append('=').append(soapEnvelopeType);
        return link.toString();
    }

    public final String getBindingTypeString(int bindingType) {
        switch (bindingType) {
            case 0: {
                return this.getMessage("FORM_LABEL_BINDING_TYPE_SOAP");
            }
            case 1: {
                return this.getMessage("FORM_LABEL_BINDING_TYPE_HTTP_GET");
            }
            case 2: {
                return this.getMessage("FORM_LABEL_BINDING_TYPE_HTTP_POST");
            }
        }
        return this.getMessage("FORM_LABEL_BINDING_TYPE_UNSUPPORTED");
    }
}

