/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.resources;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.jaxws.utils.StatusUtils;
import org.eclipse.jst.ws.jaxws.utils.internal.text.JaxWsUtilMessages;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;
import org.eclipse.jst.ws.jaxws.utils.resources.StringInputStreamAdapter;

public class EditResourcesManager {
    private static final ILogger logger = new Logger();

    public IStatus setFileEditable(IFile file, Object context) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.isReadOnly()) {
            return Status.OK_STATUS;
        }
        IWorkspace workspace = file.getWorkspace();
        return workspace.validateEdit(new IFile[]{file}, context);
    }

    public IStatus setFileEditable(IFile file) {
        return this.setFileEditable(file, IWorkspace.VALIDATE_PROMPT);
    }

    public IStatus setFilesEditable(IFile[] files, Object context) {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("Array must not be empty nor null");
        }
        ArrayList<IFile> roFiles = new ArrayList<IFile>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile f = iFileArray[n2];
            if (f.isReadOnly()) {
                roFiles.add(f);
            }
            ++n2;
        }
        if (roFiles.size() == 0) {
            return Status.OK_STATUS;
        }
        IWorkspace workspace = ((IFile)roFiles.get(0)).getWorkspace();
        return workspace.validateEdit(roFiles.toArray(new IFile[roFiles.size()]), context);
    }

    public IStatus setFilesEditable(IFile[] files) {
        return this.setFilesEditable(files, IWorkspace.VALIDATE_PROMPT);
    }

    public IStatus setFileContents(IFile file, String content, int updateFlags, IProgressMonitor progressMonitor) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        IStatus editStatus = this.setFileEditable(file);
        if (editStatus.getSeverity() != 0) {
            return editStatus;
        }
        try {
            file.setContents((InputStream)new StringInputStreamAdapter(content), updateFlags, progressMonitor);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            logger.logError(e.getMessage(), e);
            return StatusUtils.statusError(JaxWsUtilMessages.EditResourcesManager_FILE_CONTENTS_CHANGE_FAILED_MSG, e);
        }
    }

    public IStatus setFileContents(IFile file, String content, boolean force, boolean keepHistory, IProgressMonitor monitor) {
        return this.setFileContents(file, content, (keepHistory ? 2 : 0) | (force ? 1 : 0), monitor);
    }
}

