/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.pref;

import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.sse.core.internal.encoding.ContentBasedPreferenceGateway;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class TestPreferences
extends TestCase {
    private boolean DEBUG = true;

    private static void printChildren(Preferences preferences) throws BackingStoreException {
        System.out.println("\t" + preferences.absolutePath());
        String[] keys = preferences.keys();
        TestPreferences.printKeys(keys);
        String[] children = preferences.childrenNames();
        TestPreferences.printChildren(children);
        int i = 0;
        while (i < children.length) {
            String child = children[i];
            Preferences subPreferences = preferences.node(child);
            String[] subkeys = subPreferences.keys();
            System.out.println();
            System.out.println(child);
            System.out.println();
            TestPreferences.printKeys(subkeys);
            ++i;
        }
    }

    private static void printChildren(String[] children) {
        TestPreferences.printStringArray(children, "\t");
    }

    private static void printKeys(String[] keys) {
        TestPreferences.printStringArray(keys, "\t\t");
    }

    private static void printStringArray(String[] array, String tabChars) {
        int i = 0;
        while (i < array.length) {
            String string = array[i];
            System.out.println(String.valueOf(tabChars) + string);
            ++i;
        }
    }

    private void displayPreferenceTree() {
        IEclipsePreferences eclipsePreferences = Platform.getPreferencesService().getRootNode();
        try {
            String[] children = eclipsePreferences.childrenNames();
            System.out.println(eclipsePreferences.absolutePath());
            TestPreferences.printChildren(children);
            int i = 0;
            while (i < children.length) {
                String string = children[i];
                Preferences preferences = eclipsePreferences.node(string);
                TestPreferences.printChildren(preferences);
                ++i;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void testAccess() {
        if (this.DEBUG) {
            this.displayPreferenceTree();
        }
        TestPreferences.assertTrue((boolean)true);
    }

    public void testContentBasedPrefHTML() {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor("test.html");
        Preferences preferences = ContentBasedPreferenceGateway.getPreferences((IContentType)contentType);
        TestPreferences.assertNotNull((Object)preferences);
    }

    public void testContentBasedPrefXML() {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor("test.xml");
        Preferences preferences = ContentBasedPreferenceGateway.getPreferences((IContentType)contentType);
        TestPreferences.assertNotNull((Object)preferences);
    }
}

