/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.util;

import junit.framework.TestCase;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeClassType;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeNameType;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultValueType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacetNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacetType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.KeyClassType;
import org.eclipse.jst.jsf.facesconfig.emf.KeyType;
import org.eclipse.jst.jsf.facesconfig.emf.LargeIconType;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntryType;
import org.eclipse.jst.jsf.facesconfig.emf.NullValueType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyClassType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.SmallIconType;
import org.eclipse.jst.jsf.facesconfig.emf.SuggestedValueType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;

public final class CommonStructuresUtil
extends TestCase {
    private static final String TEST_SANITY = "testSanity";
    private static final FacesConfigPackage _facesConfigPackage = FacesConfigPackage.eINSTANCE;
    private static final FacesConfigFactory _facesConfigFactory = _facesConfigPackage.getFacesConfigFactory();
    public static final String ID = "id";
    public static final String LANG = "lang";
    public static final String NAME = "name";
    public static final String CLASS = "class";
    public static final String VALUE = "value";
    private static final String KEY = "key";
    private static final String DESCRIPTION_VALUE = "description";
    private static final String DISPLAY_VALUE = "displayValue";
    private static final String ICON = "icon";
    private static final String SMALL_ICON = CommonStructuresUtil.createPreficedString("small", "icon");
    private static final String LARGE_ICON = CommonStructuresUtil.createPreficedString("large", "icon");
    private static final String SUGGESTED_VALUE = CommonStructuresUtil.createPreficedString("suggested", "value");
    private static final String DEFAULT_VALUE = CommonStructuresUtil.createPreficedString("default", "value");
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_NAME = CommonStructuresUtil.createPreficedString("attribute", "name");
    private static final String ATTRIBUTE_CLASS = CommonStructuresUtil.createPreficedString("attribute", "class");
    private static final String PROPERTY = "property";
    private static final String PROPERTY_NAME = CommonStructuresUtil.createPreficedString("property", "name");
    private static final String PROPERTY_CLASS = CommonStructuresUtil.createPreficedString("property", "class");
    private static final String FACET = "facet";
    private static final String FACET_NAME = CommonStructuresUtil.createPreficedString("facet", "name");
    private static final String MANAGED_PROPERTY = "managed-property";
    private static final String MAP_ENTRIES = "map-entries";
    private static final String MAP_ENTRIES_KEY_CLASS = CommonStructuresUtil.createPreficedString("map-entries", "key-class");
    private static final String MAP_ENTRIES_VALUE_CLASS = CommonStructuresUtil.createPreficedString("map-entries", "value-class");
    private static final String MAP_ENTRY = "map-entry";
    private static final String LIST_ENTRIES = "list-entries";
    private static final String LIST_ENTRIES_VALUE_CLASS = CommonStructuresUtil.createPreficedString("list-entries", "value-class");

    public static DescriptionType createDescription(String prefix) {
        DescriptionType description = _facesConfigFactory.createDescriptionType();
        description.setTextContent(CommonStructuresUtil.createPreficedString(prefix, DESCRIPTION_VALUE));
        description.setId(CommonStructuresUtil.createPreficedString(prefix, ID));
        description.setLang(CommonStructuresUtil.createPreficedString(prefix, LANG));
        return description;
    }

    public static void assertMatchesDescription(String prefix, DescriptionType description) {
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, DESCRIPTION_VALUE), (String)description.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, ID), (String)description.getId());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, LANG), (String)description.getLang());
    }

    public static DisplayNameType createDisplayName(String prefix) {
        DisplayNameType displayName = _facesConfigFactory.createDisplayNameType();
        displayName.setTextContent(CommonStructuresUtil.createPreficedString(prefix, DISPLAY_VALUE));
        displayName.setId(CommonStructuresUtil.createPreficedString(prefix, ID));
        displayName.setLang(CommonStructuresUtil.createPreficedString(prefix, LANG));
        return displayName;
    }

    public static void assertMatchesDisplayName(String prefix, DisplayNameType displayName) {
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, DISPLAY_VALUE), (String)displayName.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, ID), (String)displayName.getId());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, LANG), (String)displayName.getLang());
    }

    public static IconType createIcon(String prefix) {
        IconType iconType = _facesConfigFactory.createIconType();
        iconType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ICON, ID)));
        iconType.setLang(CommonStructuresUtil.createPreficedString(prefix, LANG));
        SmallIconType smallIconType = _facesConfigFactory.createSmallIconType();
        smallIconType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, SMALL_ICON));
        LargeIconType largeIconType = _facesConfigFactory.createLargeIconType();
        largeIconType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, LARGE_ICON));
        iconType.setSmallIcon(smallIconType);
        iconType.setLargeIcon(largeIconType);
        return iconType;
    }

    public static void assertMatchesIcon(String prefix, IconType iconType) {
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ICON, ID)), (String)iconType.getId());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, LANG), (String)iconType.getLang());
        SmallIconType smallIconType = iconType.getSmallIcon();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, SMALL_ICON), (String)smallIconType.getTextContent());
        LargeIconType largeIconType = iconType.getLargeIcon();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, LARGE_ICON), (String)largeIconType.getTextContent());
    }

    public static AttributeType createAttribute(String prefix) {
        String ATTRIBUTE_PREFIX = CommonStructuresUtil.createPreficedString(prefix, ATTRIBUTE);
        AttributeType attrType = _facesConfigFactory.createAttributeType();
        attrType.getDescription().add((Object)CommonStructuresUtil.createDescription(ATTRIBUTE_PREFIX));
        attrType.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(ATTRIBUTE_PREFIX));
        attrType.getIcon().add((Object)CommonStructuresUtil.createIcon(ATTRIBUTE_PREFIX));
        AttributeNameType attributeNameType = _facesConfigFactory.createAttributeNameType();
        attributeNameType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, ATTRIBUTE_NAME));
        attributeNameType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE_NAME, ID)));
        attrType.setAttributeName(attributeNameType);
        AttributeClassType attributeClassType = _facesConfigFactory.createAttributeClassType();
        attributeClassType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, ATTRIBUTE_CLASS));
        attributeClassType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE_CLASS, ID)));
        attrType.setAttributeClass(attributeClassType);
        DefaultValueType defaultValueType = _facesConfigFactory.createDefaultValueType();
        defaultValueType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, DEFAULT_VALUE)));
        defaultValueType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, CommonStructuresUtil.createPreficedString(DEFAULT_VALUE, ID))));
        attrType.setDefaultValue(defaultValueType);
        SuggestedValueType suggestedValueType = _facesConfigFactory.createSuggestedValueType();
        suggestedValueType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, SUGGESTED_VALUE)));
        suggestedValueType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, CommonStructuresUtil.createPreficedString(SUGGESTED_VALUE, ID))));
        attrType.setSuggestedValue(suggestedValueType);
        attrType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, ID)));
        return attrType;
    }

    public static void assertMatchAttribute(String prefix, AttributeType attrType) {
        String ATTRIBUTE_PREFIX = CommonStructuresUtil.createPreficedString(prefix, ATTRIBUTE);
        CommonStructuresUtil.assertEquals((int)1, (int)attrType.getDescription().size());
        CommonStructuresUtil.assertMatchesDescription(ATTRIBUTE_PREFIX, (DescriptionType)attrType.getDescription().get(0));
        CommonStructuresUtil.assertEquals((int)1, (int)attrType.getDisplayName().size());
        CommonStructuresUtil.assertMatchesDisplayName(ATTRIBUTE_PREFIX, (DisplayNameType)attrType.getDisplayName().get(0));
        CommonStructuresUtil.assertEquals((int)1, (int)attrType.getIcon().size());
        CommonStructuresUtil.assertMatchesIcon(ATTRIBUTE_PREFIX, (IconType)attrType.getIcon().get(0));
        AttributeNameType attributeNameType = attrType.getAttributeName();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, ATTRIBUTE_NAME), (String)attributeNameType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE_NAME, ID)), (String)attributeNameType.getId());
        AttributeClassType attributeClassType = attrType.getAttributeClass();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, ATTRIBUTE_CLASS), (String)attributeClassType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE_CLASS, ID)), (String)attributeClassType.getId());
        DefaultValueType defaultValueType = attrType.getDefaultValue();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, DEFAULT_VALUE)), (String)defaultValueType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, CommonStructuresUtil.createPreficedString(DEFAULT_VALUE, ID))), (String)defaultValueType.getId());
        SuggestedValueType suggestedValueType = attrType.getSuggestedValue();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, SUGGESTED_VALUE)), (String)suggestedValueType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, CommonStructuresUtil.createPreficedString(SUGGESTED_VALUE, ID))), (String)suggestedValueType.getId());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(ATTRIBUTE, ID)), (String)attrType.getId());
    }

    public static PropertyType createProperty(String prefix) {
        String PROPERTY_PREFIX = CommonStructuresUtil.createPreficedString(prefix, PROPERTY);
        PropertyType propertyType = _facesConfigFactory.createPropertyType();
        propertyType.getDescription().add((Object)CommonStructuresUtil.createDescription(PROPERTY_PREFIX));
        propertyType.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(PROPERTY_PREFIX));
        propertyType.getIcon().add((Object)CommonStructuresUtil.createIcon(PROPERTY_PREFIX));
        PropertyNameType propertyNameType = _facesConfigFactory.createPropertyNameType();
        propertyNameType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, PROPERTY_NAME));
        propertyNameType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY_NAME, ID)));
        propertyType.setPropertyName(propertyNameType);
        PropertyClassType propertyClassType = _facesConfigFactory.createPropertyClassType();
        propertyClassType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, PROPERTY_CLASS));
        propertyClassType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY_CLASS, ID)));
        propertyType.setPropertyClass(propertyClassType);
        DefaultValueType defaultValueType = _facesConfigFactory.createDefaultValueType();
        defaultValueType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, DEFAULT_VALUE)));
        defaultValueType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, CommonStructuresUtil.createPreficedString(DEFAULT_VALUE, ID))));
        propertyType.setDefaultValue(defaultValueType);
        SuggestedValueType suggestedValueType = _facesConfigFactory.createSuggestedValueType();
        suggestedValueType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, SUGGESTED_VALUE)));
        suggestedValueType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, CommonStructuresUtil.createPreficedString(SUGGESTED_VALUE, ID))));
        propertyType.setSuggestedValue(suggestedValueType);
        propertyType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, ID)));
        return propertyType;
    }

    public static void assertMatchProperty(String prefix, PropertyType property) {
        String PROPERTY_PREFIX = CommonStructuresUtil.createPreficedString(prefix, PROPERTY);
        CommonStructuresUtil.assertEquals((int)1, (int)property.getDescription().size());
        CommonStructuresUtil.assertMatchesDescription(PROPERTY_PREFIX, (DescriptionType)property.getDescription().get(0));
        CommonStructuresUtil.assertEquals((int)1, (int)property.getDisplayName().size());
        CommonStructuresUtil.assertMatchesDisplayName(PROPERTY_PREFIX, (DisplayNameType)property.getDisplayName().get(0));
        CommonStructuresUtil.assertEquals((int)1, (int)property.getIcon().size());
        CommonStructuresUtil.assertMatchesIcon(PROPERTY_PREFIX, (IconType)property.getIcon().get(0));
        PropertyNameType propertyNameType = property.getPropertyName();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, PROPERTY_NAME), (String)propertyNameType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY_NAME, ID)), (String)propertyNameType.getId());
        PropertyClassType propertyClassType = property.getPropertyClass();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, PROPERTY_CLASS), (String)propertyClassType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY_CLASS, ID)), (String)propertyClassType.getId());
        DefaultValueType defaultValueType = property.getDefaultValue();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, DEFAULT_VALUE)), (String)defaultValueType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, CommonStructuresUtil.createPreficedString(DEFAULT_VALUE, ID))), (String)defaultValueType.getId());
        SuggestedValueType suggestedValueType = property.getSuggestedValue();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, SUGGESTED_VALUE)), (String)suggestedValueType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, CommonStructuresUtil.createPreficedString(SUGGESTED_VALUE, ID))), (String)suggestedValueType.getId());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY, ID)), (String)property.getId());
    }

    public static FacetType createFacet(String prefix) {
        String FACET_PREFIX = CommonStructuresUtil.createPreficedString(prefix, FACET);
        FacetType facet = _facesConfigFactory.createFacetType();
        facet.getDescription().add((Object)CommonStructuresUtil.createDescription(FACET_PREFIX));
        facet.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(FACET_PREFIX));
        facet.getIcon().add((Object)CommonStructuresUtil.createIcon(FACET_PREFIX));
        FacetNameType facetNameType = _facesConfigFactory.createFacetNameType();
        facetNameType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, FACET_NAME));
        facetNameType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(FACET_NAME, ID)));
        facet.setFacetName(facetNameType);
        facet.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(FACET, ID)));
        return facet;
    }

    public static void assertMatchFacet(String prefix, FacetType facet) {
        String FACET_PREFIX = CommonStructuresUtil.createPreficedString(prefix, FACET);
        CommonStructuresUtil.assertEquals((int)1, (int)facet.getDescription().size());
        CommonStructuresUtil.assertMatchesDescription(FACET_PREFIX, (DescriptionType)facet.getDescription().get(0));
        CommonStructuresUtil.assertEquals((int)1, (int)facet.getDisplayName().size());
        CommonStructuresUtil.assertMatchesDisplayName(FACET_PREFIX, (DisplayNameType)facet.getDisplayName().get(0));
        CommonStructuresUtil.assertEquals((int)1, (int)facet.getIcon().size());
        CommonStructuresUtil.assertMatchesIcon(FACET_PREFIX, (IconType)facet.getIcon().get(0));
        FacetNameType propertyNameType = facet.getFacetName();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, FACET_NAME), (String)propertyNameType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(FACET_NAME, ID)), (String)propertyNameType.getId());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(FACET, ID)), (String)facet.getId());
    }

    public static ManagedPropertyType createManagedPropertyBase(String prefix) {
        String MANAGED_PROPERTY_PREFIX = CommonStructuresUtil.createPreficedString(prefix, MANAGED_PROPERTY);
        ManagedPropertyType managedProperty = _facesConfigFactory.createManagedPropertyType();
        managedProperty.getDescription().add((Object)CommonStructuresUtil.createDescription(MANAGED_PROPERTY_PREFIX));
        managedProperty.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(MANAGED_PROPERTY_PREFIX));
        managedProperty.getIcon().add((Object)CommonStructuresUtil.createIcon(MANAGED_PROPERTY_PREFIX));
        PropertyNameType propertyNameType = _facesConfigFactory.createPropertyNameType();
        propertyNameType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, PROPERTY_NAME));
        propertyNameType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY_NAME, ID)));
        managedProperty.setPropertyName(propertyNameType);
        PropertyClassType propertyClassType = _facesConfigFactory.createPropertyClassType();
        propertyClassType.setTextContent(CommonStructuresUtil.createPreficedString(prefix, PROPERTY_CLASS));
        propertyClassType.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY_CLASS, ID)));
        managedProperty.setPropertyClass(propertyClassType);
        return managedProperty;
    }

    public static void assertMatchManagedPropertyBase(String prefix, ManagedPropertyType managedProperty) {
        String MANAGED_PROPERTY_PREFIX = CommonStructuresUtil.createPreficedString(prefix, MANAGED_PROPERTY);
        CommonStructuresUtil.assertEquals((int)1, (int)managedProperty.getDescription().size());
        CommonStructuresUtil.assertMatchesDescription(MANAGED_PROPERTY_PREFIX, (DescriptionType)managedProperty.getDescription().get(0));
        CommonStructuresUtil.assertEquals((int)1, (int)managedProperty.getDisplayName().size());
        CommonStructuresUtil.assertMatchesDisplayName(MANAGED_PROPERTY_PREFIX, (DisplayNameType)managedProperty.getDisplayName().get(0));
        CommonStructuresUtil.assertEquals((int)1, (int)managedProperty.getIcon().size());
        CommonStructuresUtil.assertMatchesIcon(MANAGED_PROPERTY_PREFIX, (IconType)managedProperty.getIcon().get(0));
        PropertyNameType propertyNameType = managedProperty.getPropertyName();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, PROPERTY_NAME), (String)propertyNameType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY_NAME, ID)), (String)propertyNameType.getId());
        PropertyClassType propertyClassType = managedProperty.getPropertyClass();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, PROPERTY_CLASS), (String)propertyClassType.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(PROPERTY_CLASS, ID)), (String)propertyClassType.getId());
    }

    public static ValueType createValue(String prefix) {
        String VALUE_PREFIX = CommonStructuresUtil.createPreficedString(prefix, VALUE);
        ValueType value = _facesConfigFactory.createValueType();
        value.setTextContent(VALUE_PREFIX);
        value.setId(CommonStructuresUtil.createPreficedString(VALUE_PREFIX, ID));
        return value;
    }

    public static void assertMatchValue(String prefix, ValueType value) {
        String VALUE_PREFIX = CommonStructuresUtil.createPreficedString(prefix, VALUE);
        CommonStructuresUtil.assertEquals((String)VALUE_PREFIX, (String)value.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(VALUE_PREFIX, ID), (String)value.getId());
    }

    public static MapEntriesType createMapEntries(String prefix) {
        String MAP_ENTRIES_PREFIX = CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(MANAGED_PROPERTY, MAP_ENTRIES));
        MapEntriesType mapEntries = _facesConfigFactory.createMapEntriesType();
        KeyClassType keyClass = _facesConfigFactory.createKeyClassType();
        keyClass.setTextContent(CommonStructuresUtil.createPreficedString(prefix, MAP_ENTRIES_KEY_CLASS));
        keyClass.setId(CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(MAP_ENTRIES_KEY_CLASS, ID)));
        mapEntries.setKeyClass(keyClass);
        ValueClassType valueClass = _facesConfigFactory.createValueClassType();
        valueClass.setTextContent(MAP_ENTRIES_VALUE_CLASS);
        valueClass.setId(CommonStructuresUtil.createPreficedString(MAP_ENTRIES_VALUE_CLASS, ID));
        mapEntries.setValueClass(valueClass);
        MapEntryType mapEntry = _facesConfigFactory.createMapEntryType();
        mapEntry.setId(CommonStructuresUtil.createPreficedString(MAP_ENTRY, ID));
        KeyType keyType = _facesConfigFactory.createKeyType();
        keyType.setId(CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString(MAP_ENTRY, ID), KEY));
        keyType.setTextContent(CommonStructuresUtil.createPreficedString(MAP_ENTRY, KEY));
        mapEntry.setKey(keyType);
        mapEntry.setValue(CommonStructuresUtil.createValue(MAP_ENTRIES_PREFIX));
        mapEntries.getMapEntry().add((Object)mapEntry);
        mapEntry = _facesConfigFactory.createMapEntryType();
        mapEntry.setId(CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString(MAP_ENTRY, ID), "2"));
        keyType = _facesConfigFactory.createKeyType();
        keyType.setId(CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString(MAP_ENTRY, ID), KEY), "2"));
        keyType.setTextContent(CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString(MAP_ENTRY, KEY), "2"));
        mapEntry.setKey(keyType);
        NullValueType nullValue = _facesConfigFactory.createNullValueType();
        nullValue.setId(CommonStructuresUtil.createPreficedString("null", MAP_ENTRY));
        mapEntry.setNullValue(nullValue);
        mapEntries.getMapEntry().add((Object)mapEntry);
        mapEntries.setId(CommonStructuresUtil.createPreficedString(MAP_ENTRIES_PREFIX, ID));
        return mapEntries;
    }

    public static void assertMatchMapEntries(String prefix, MapEntriesType mapEntries) {
        String MAP_ENTRIES_PREFIX = CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(MANAGED_PROPERTY, MAP_ENTRIES));
        KeyClassType keyClass = mapEntries.getKeyClass();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, MAP_ENTRIES_KEY_CLASS), (String)keyClass.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(MAP_ENTRIES_KEY_CLASS, ID)), (String)keyClass.getId());
        ValueClassType valueClass = mapEntries.getValueClass();
        CommonStructuresUtil.assertEquals((String)MAP_ENTRIES_VALUE_CLASS, (String)valueClass.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(MAP_ENTRIES_VALUE_CLASS, ID), (String)valueClass.getId());
        CommonStructuresUtil.assertEquals((int)2, (int)mapEntries.getMapEntry().size());
        MapEntryType mapEntry = (MapEntryType)mapEntries.getMapEntry().get(0);
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(MAP_ENTRY, ID), (String)mapEntry.getId());
        KeyType keyType = mapEntry.getKey();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString(MAP_ENTRY, ID), KEY), (String)keyType.getId());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(MAP_ENTRY, KEY), (String)keyType.getTextContent());
        CommonStructuresUtil.assertMatchValue(MAP_ENTRIES_PREFIX, mapEntry.getValue());
        mapEntry = (MapEntryType)mapEntries.getMapEntry().get(1);
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString(MAP_ENTRY, ID), "2"), (String)mapEntry.getId());
        keyType = mapEntry.getKey();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString(MAP_ENTRY, ID), KEY), "2"), (String)keyType.getId());
        NullValueType nullValue = mapEntry.getNullValue();
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString("null", MAP_ENTRY), (String)nullValue.getId());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(MAP_ENTRIES_PREFIX, ID), (String)mapEntries.getId());
    }

    public static ListEntriesType createListEntries(String prefix) {
        String LIST_ENTRIES_PREFIX = CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(MANAGED_PROPERTY, LIST_ENTRIES));
        ListEntriesType listEntries = _facesConfigFactory.createListEntriesType();
        ValueClassType valueClass = _facesConfigFactory.createValueClassType();
        valueClass.setTextContent(LIST_ENTRIES_VALUE_CLASS);
        valueClass.setId(CommonStructuresUtil.createPreficedString(LIST_ENTRIES_VALUE_CLASS, ID));
        listEntries.setValueClass(valueClass);
        listEntries.getValue().add((Object)CommonStructuresUtil.createValue(LIST_ENTRIES_PREFIX));
        listEntries.setId(CommonStructuresUtil.createPreficedString(LIST_ENTRIES_PREFIX, ID));
        return listEntries;
    }

    public static void assertMatchListEntries(String prefix, ListEntriesType listEntries) {
        String LIST_ENTRIES_PREFIX = CommonStructuresUtil.createPreficedString(prefix, CommonStructuresUtil.createPreficedString(MANAGED_PROPERTY, LIST_ENTRIES));
        ValueClassType valueClass = listEntries.getValueClass();
        CommonStructuresUtil.assertEquals((String)LIST_ENTRIES_VALUE_CLASS, (String)valueClass.getTextContent());
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(LIST_ENTRIES_VALUE_CLASS, ID), (String)valueClass.getId());
        CommonStructuresUtil.assertEquals((int)1, (int)listEntries.getValue().size());
        ValueType value = (ValueType)listEntries.getValue().get(0);
        CommonStructuresUtil.assertMatchValue(LIST_ENTRIES_PREFIX, value);
        CommonStructuresUtil.assertEquals((String)CommonStructuresUtil.createPreficedString(LIST_ENTRIES_PREFIX, ID), (String)listEntries.getId());
    }

    public static String createPreficedString(String prefix, String value) {
        return prefix + "-" + value;
    }

    public void testSanity() {
        CommonStructuresUtil.assertMatchesDescription(TEST_SANITY, CommonStructuresUtil.createDescription(TEST_SANITY));
        CommonStructuresUtil.assertMatchesDisplayName(TEST_SANITY, CommonStructuresUtil.createDisplayName(TEST_SANITY));
        CommonStructuresUtil.assertMatchesIcon(TEST_SANITY, CommonStructuresUtil.createIcon(TEST_SANITY));
        CommonStructuresUtil.assertMatchAttribute(TEST_SANITY, CommonStructuresUtil.createAttribute(TEST_SANITY));
        CommonStructuresUtil.assertMatchProperty(TEST_SANITY, CommonStructuresUtil.createProperty(TEST_SANITY));
        CommonStructuresUtil.assertMatchFacet(TEST_SANITY, CommonStructuresUtil.createFacet(TEST_SANITY));
        CommonStructuresUtil.assertMatchManagedPropertyBase(TEST_SANITY, CommonStructuresUtil.createManagedPropertyBase(TEST_SANITY));
        CommonStructuresUtil.assertMatchValue(TEST_SANITY, CommonStructuresUtil.createValue(TEST_SANITY));
        CommonStructuresUtil.assertMatchMapEntries(TEST_SANITY, CommonStructuresUtil.createMapEntries(TEST_SANITY));
        CommonStructuresUtil.assertMatchListEntries(TEST_SANITY, CommonStructuresUtil.createListEntries(TEST_SANITY));
    }
}

