/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;

public class TestSumAvg
extends AbstractPsychoPathTest {
    public void testEmpty() throws Exception {
        this.assertXPathEvalation("sum( () )", "0");
        this.assertXPathEvalation("sum( (), 99 )", "99");
        this.assertXPathEvalation("avg( () )", "");
    }

    public void testYMDMinMax() throws Exception {
        this.assertXPathEvalation("sum( (xs:yearMonthDuration('P0Y1M'), xs:yearMonthDuration('P1Y1M'), xs:yearMonthDuration('P1Y0M')) )", "P2Y2M");
        this.assertXPathEvalation("avg( (xs:yearMonthDuration('P0Y1M'), xs:yearMonthDuration('P1Y2M'), xs:yearMonthDuration('P1Y0M')) )", "P9M");
    }

    public void testDTDMax() throws Exception {
        this.assertXPathEvalation("sum( (xs:dayTimeDuration('P1DT2H'), xs:dayTimeDuration('P1D'), xs:dayTimeDuration('PT22H')) )", "P3D");
        this.assertXPathEvalation("avg( (xs:dayTimeDuration('P1DT2H'), xs:dayTimeDuration('P1D'), xs:dayTimeDuration('PT22H')) )", "P1D");
    }

    public void testAtomic() throws Exception {
        this.assertXPathEvalation("sum( (xs:untypedAtomic('1'), 0.9, xs:untypedAtomic('2.1'),0 ) )", "4");
        this.assertXPathEvalation("avg( (xs:untypedAtomic('1'), 0.9, xs:untypedAtomic('2.1'),0 ) )", "1");
    }

    public void testMixed() throws Exception {
        this.assertDynamicError("sum( ('a', 1.2, 1) )", "FORG0006");
        this.assertDynamicError("avg( ('a', 1.2, 1) )", "FORG0006");
        this.assertDynamicError("sum( (xs:dayTimeDuration('P1DT2H'), 123) )", "FORG0006");
        this.assertDynamicError("avg( (xs:dayTimeDuration('P1DT2H'), 123) )", "FORG0006");
        this.assertDynamicError("sum( (xs:untypedAtomic('1'), 1.2, '2.1') )", "FORG0006");
        this.assertDynamicError("avg( (xs:untypedAtomic('1'), 1.2, '2.1') )", "FORG0006");
    }

    private void assertXPathEvalation(String xpath, String expectedResult) throws XPathParserException, StaticError, DynamicError {
        this.setupDynamicContext(null);
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        String resultValue = this.buildResultString(rs);
        TestSumAvg.assertEquals((String)expectedResult, (String)resultValue);
    }

    private void assertDynamicError(String xpath, String errorCode) throws XPathParserException, StaticError {
        this.setupDynamicContext(null);
        this.compileXPath(xpath);
        try {
            this.evaluate(null);
            TestSumAvg.fail((String)("Error " + errorCode + " expected here"));
        }
        catch (DynamicError de) {
            TestSumAvg.assertEquals((String)"Wrong error code", (String)errorCode, (String)de.code());
        }
        catch (Throwable t) {
            TestSumAvg.fail((String)("Unexpected error: " + t.getMessage()));
        }
    }
}

