/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.tests.viewer;

import junit.framework.TestCase;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.tests.Logger;

public class TestViewerConfiguration
extends TestCase {
    private StructuredTextViewerConfiguration fConfig = null;
    private boolean fDisplayExists = true;
    private StructuredTextViewer fViewer = null;
    private boolean isSetup = false;

    public TestViewerConfiguration() {
        super("TestViewerConfiguration");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.setUpViewerConfiguration();
            this.isSetup = true;
        }
    }

    private void setUpViewerConfiguration() {
        if (Display.getCurrent() != null) {
            Shell shell = null;
            Composite parent = null;
            shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
            parent = new Composite((Composite)shell, 0);
            this.fViewer = new StructuredTextViewer(parent, null, null, false, 0);
            this.fConfig = new StructuredTextViewerConfiguration();
        } else {
            this.fDisplayExists = false;
            Logger.log(1, "Remember, viewer configuration tests are not run because workbench is not open (normal on build machine)");
        }
    }

    public void testGetAnnotationHover() {
        if (!this.fDisplayExists) {
            return;
        }
        IAnnotationHover hover = this.fConfig.getAnnotationHover((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"AnnotationHover is null", (Object)hover);
    }

    public void testGetAutoEditStrategies() {
        if (!this.fDisplayExists) {
            return;
        }
        IAutoEditStrategy[] strategies = this.fConfig.getAutoEditStrategies((ISourceViewer)this.fViewer, "org.eclipse.wst.sse.ST_DEFAULT");
        TestViewerConfiguration.assertNotNull((Object)strategies);
        TestViewerConfiguration.assertTrue((String)"there are no auto edit strategies", (strategies.length > 0 ? 1 : 0) != 0);
    }

    public void testGetConfiguredContentTypes() {
        if (!this.fDisplayExists) {
            return;
        }
        String[] configuredContentTypes = this.fConfig.getConfiguredContentTypes((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((Object)configuredContentTypes);
        TestViewerConfiguration.assertTrue((configuredContentTypes.length == 1 ? 1 : 0) != 0);
    }

    public void testGetConfiguredDocumentPartitioning() {
        if (!this.fDisplayExists) {
            return;
        }
        String partitioning = this.fConfig.getConfiguredDocumentPartitioning((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertEquals((String)"org.eclipse.wst.sse.core.default_structured_text_partitioning", (String)partitioning);
    }

    public void testGetConfiguredTextHoverStateMasks() {
        if (!this.fDisplayExists) {
            return;
        }
        int[] masks = this.fConfig.getConfiguredTextHoverStateMasks((ISourceViewer)this.fViewer, "org.eclipse.wst.sse.ST_DEFAULT");
        TestViewerConfiguration.assertEquals((int)2, (int)masks.length);
    }

    public void testGetContentAssistant() {
        if (!this.fDisplayExists) {
            return;
        }
        IContentAssistant ca = this.fConfig.getContentAssistant((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"there is no content assistant", (Object)ca);
    }

    public void testGetContentFormatter() {
        if (!this.fDisplayExists) {
            return;
        }
        IContentFormatter cf = this.fConfig.getContentFormatter((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNull((String)"there is a content formatter", (Object)cf);
    }

    public void testGetDoubleClickStrategy() {
        if (!this.fDisplayExists) {
            return;
        }
        String[] contentTypes = this.fConfig.getConfiguredContentTypes((ISourceViewer)this.fViewer);
        int i = 0;
        while (i < contentTypes.length) {
            ITextDoubleClickStrategy strategy = this.fConfig.getDoubleClickStrategy((ISourceViewer)this.fViewer, contentTypes[i]);
            if (strategy != null) {
                return;
            }
            ++i;
        }
        TestViewerConfiguration.assertTrue((String)"there are no configured double click strategies", (boolean)false);
    }

    public void testGetHyperlinkDetectors() {
        if (!this.fDisplayExists) {
            return;
        }
        IHyperlinkDetector[] detectors = this.fConfig.getHyperlinkDetectors((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"there are no hyperlink detectors", (Object)detectors);
        TestViewerConfiguration.assertTrue((String)"there are no hyperlink detectors", (detectors.length > 0 ? 1 : 0) != 0);
    }

    public void testGetHyperlinkPresenter() {
        if (!this.fDisplayExists) {
            return;
        }
        IHyperlinkPresenter presenter = this.fConfig.getHyperlinkPresenter((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"hyperlink presenter shouldn't be null", (Object)presenter);
    }

    public void testGetInformationControlCreator() {
        if (!this.fDisplayExists) {
            return;
        }
        IInformationControlCreator infoControlCreator = this.fConfig.getInformationControlCreator((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"info control creator was null", (Object)infoControlCreator);
    }

    public void testGetInformationPresenter() {
        if (!this.fDisplayExists) {
            return;
        }
        IInformationPresenter presenter = this.fConfig.getInformationPresenter((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"InformationPresenter was null", (Object)presenter);
    }

    public void testGetLineStyleProviders() {
        if (!this.fDisplayExists) {
            return;
        }
        String[] contentTypes = this.fConfig.getConfiguredContentTypes((ISourceViewer)this.fViewer);
        int i = 0;
        while (i < contentTypes.length) {
            LineStyleProvider[] providers = this.fConfig.getLineStyleProviders((ISourceViewer)this.fViewer, contentTypes[i]);
            TestViewerConfiguration.assertNull((String)"line style providers is not null", (Object)providers);
            ++i;
        }
    }

    public void testGetOverviewRulerAnnotationHover() {
        if (!this.fDisplayExists) {
            return;
        }
        IAnnotationHover annotationHover = this.fConfig.getOverviewRulerAnnotationHover((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"annotation hover was null", (Object)annotationHover);
    }

    public void testGetPresentationReconciler() {
        if (!this.fDisplayExists) {
            return;
        }
        IPresentationReconciler presentationReconciler = this.fConfig.getPresentationReconciler((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"presentation reconciler was null", (Object)presentationReconciler);
    }

    public void testGetReconciler() {
        if (!this.fDisplayExists) {
            return;
        }
        IReconciler r = this.fConfig.getReconciler((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"Reconciler was null", (Object)r);
    }

    public void testGetUndoManager() {
        if (!this.fDisplayExists) {
            return;
        }
        IUndoManager undoManager = this.fConfig.getUndoManager((ISourceViewer)this.fViewer);
        TestViewerConfiguration.assertNotNull((String)"undo manager was null", (Object)undoManager);
    }
}

