/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.jst.ws.internal.consumption.datamodel.wsdlmodel;

import java.util.Enumeration;
import org.eclipse.wst.ws.internal.datamodel.BasicElement;


public class DefinitionElement extends BasicElement
{

  // Copyright
  public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";


  public static String REL_SERVICES = "services";
  public static String REL_WSDL = "wsdl";
  
  public DefinitionElement (WSDLElement wsdlElement,String name)
  {
    super(name,wsdlElement,REL_WSDL,WSDLElement.REL_DEFINITIONS);
  }

  public Enumeration getWSDL()
  {
    return getElements(REL_WSDL);
  }

  public Enumeration getServices()
  {
    return getElements(REL_SERVICES);
  }

  public int getNumberOfServices()
  {
    return getNumberOfElements(REL_SERVICES);
  }
}

