/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.invoker;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import org.eclipse.wst.xsl.jaxp.debug.invoker.IProcessorInvoker;
import org.eclipse.wst.xsl.jaxp.debug.invoker.Messages;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TransformDefinition;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TypedValue;
import org.eclipse.wst.xsl.jaxp.debug.invoker.internal.ConfigurationException;
import org.eclipse.wst.xsl.jaxp.debug.invoker.internal.CreationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PipelineDefinition {
    private String sourceURL;
    private String targetFile;
    private final List<TransformDefinition> transformDefs = new ArrayList<TransformDefinition>();
    private final Set<TypedValue> attributes = new HashSet<TypedValue>();
    private boolean useEmbedded;

    public PipelineDefinition() {
    }

    public PipelineDefinition(File launchFile) throws SAXException, IOException, ParserConfigurationException {
        this(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new BufferedInputStream(new FileInputStream(launchFile))));
    }

    public PipelineDefinition(Document doc) {
        Element rootEl = doc.getDocumentElement();
        Element attributesEl = (Element)rootEl.getElementsByTagName("Attributes").item(0);
        NodeList attributeEls = attributesEl.getElementsByTagName("Attribute");
        int i = 0;
        while (i < attributeEls.getLength()) {
            Element attributeEl = (Element)attributeEls.item(i);
            String name = attributeEl.getAttribute("name");
            String type = attributeEl.getAttribute("type");
            String value = attributeEl.getAttribute("value");
            this.addAttribute(new TypedValue(name, type, value));
            ++i;
        }
        Element transformsEl = (Element)rootEl.getElementsByTagName("Transforms").item(0);
        String useEmbedded = transformsEl.getAttribute("useEmbedded");
        boolean embedded = Boolean.getBoolean(useEmbedded);
        this.setUseEmbedded(embedded);
        if (!embedded) {
            NodeList transformEls = transformsEl.getElementsByTagName("Transform");
            int i2 = 0;
            while (i2 < transformEls.getLength()) {
                Element transformEl = (Element)transformEls.item(i2);
                TransformDefinition tdef = TransformDefinition.fromXML(transformEl);
                this.addTransformDef(tdef);
                ++i2;
            }
        }
    }

    public void configure(IProcessorInvoker invoker) throws ConfigurationException {
        ConcurrentHashMap<String, Object> attVals = new ConcurrentHashMap<String, Object>();
        for (TypedValue att : this.attributes) {
            Object value;
            try {
                value = att.createValue();
            }
            catch (CreationException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            attVals.put(att.name, value);
        }
        invoker.setAttributes(attVals);
        for (TransformDefinition tdef : this.transformDefs) {
            Map<String, Object> params = this.setParams(tdef);
            URL url = this.getStyleSheetURL(tdef);
            Properties properties = tdef.getOutputProperties();
            URIResolver resolver = this.getResolver(tdef);
            this.addStyleSheet(invoker, tdef, params, url, properties, resolver);
        }
    }

    private void addStyleSheet(IProcessorInvoker invoker, TransformDefinition tdef, Map<String, Object> params, URL url, Properties properties, URIResolver resolver) throws ConfigurationException {
        try {
            invoker.addStylesheet(url, params, properties, resolver);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new ConfigurationException(String.valueOf(Messages.getString("PipelineDefinition.10")) + tdef.getStylesheetURL(), null);
        }
    }

    private URIResolver getResolver(TransformDefinition tdef) throws ConfigurationException {
        URIResolver resolver = null;
        if (tdef.getResolverClass() != null) {
            try {
                Class<?> resolverClass = Class.forName(tdef.getResolverClass());
                resolver = (URIResolver)resolverClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ConfigurationException(String.valueOf(Messages.getString("PipelineDefinition.10")) + tdef.getResolverClass(), null);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return resolver;
    }

    private URL getStyleSheetURL(TransformDefinition tdef) throws ConfigurationException {
        URL url = null;
        try {
            url = new URL(tdef.getStylesheetURL());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(String.valueOf(Messages.getString("PipelineDefinition.9")) + tdef.getStylesheetURL(), e);
        }
        return url;
    }

    private Map<String, Object> setParams(TransformDefinition tdef) throws ConfigurationException {
        Map<String, Object> params = null;
        try {
            params = tdef.getParametersAsMap();
        }
        catch (CreationException e) {
            throw new ConfigurationException(Messages.getString("PipelineDefinition.8"), e);
        }
        return params;
    }

    public Set<TypedValue> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(TypedValue attribute) {
        this.attributes.add(attribute);
    }

    public void removeAttribute(TypedValue attribute) {
        this.attributes.remove(attribute);
    }

    public List<TransformDefinition> getTransformDefs() {
        return this.transformDefs;
    }

    public void addTransformDef(TransformDefinition tdef) {
        this.transformDefs.add(tdef);
    }

    public void removeTransformDef(TransformDefinition tdef) {
        this.transformDefs.remove(tdef);
    }

    public void setUseEmbedded(boolean embedded) {
        this.useEmbedded = embedded;
    }

    public boolean useEmbedded() {
        return this.useEmbedded;
    }

    public Document toXML() throws ParserConfigurationException {
        Document doc = PipelineDefinition.newDocument();
        Element rootEl = doc.createElement("Pipeline");
        rootEl.setAttribute("source", this.sourceURL);
        rootEl.setAttribute("target", this.targetFile);
        doc.appendChild(rootEl);
        Element attributesEl = doc.createElement("Attributes");
        rootEl.appendChild(attributesEl);
        for (TypedValue attribute : this.attributes) {
            Element attributeEl = doc.createElement("Attribute");
            attributeEl.setAttribute("name", attribute.name);
            attributeEl.setAttribute("type", attribute.type);
            attributeEl.setAttribute("value", attribute.value);
            attributesEl.appendChild(attributeEl);
        }
        rootEl.setAttribute("useEmbedded", String.valueOf(this.useEmbedded));
        if (!this.useEmbedded) {
            Element transformsEl = doc.createElement("Transforms");
            rootEl.appendChild(transformsEl);
            for (TransformDefinition tdef : this.transformDefs) {
                Element tdefEl = tdef.asXML(doc);
                transformsEl.appendChild(tdefEl);
            }
        }
        return doc;
    }

    private static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }
}

