/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.ui.libprov;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetInstallConfig;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderFrameworkUi;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

public abstract class LibraryFacetInstallPage
extends AbstractFacetWizardPage {
    private LibraryFacetInstallConfig config = null;
    private LibraryInstallDelegate libraryInstallDelegate = null;
    private Composite rootComposite = null;

    public LibraryFacetInstallPage(String name) {
        super(name);
    }

    public void setConfig(Object config) {
        this.config = (LibraryFacetInstallConfig)config;
        this.libraryInstallDelegate = this.config.getLibraryInstallDelegate();
    }

    protected LibraryInstallDelegate getLibraryInstallDelegate() {
        return this.libraryInstallDelegate;
    }

    public final void createControl(Composite parent) {
        this.rootComposite = new Composite(parent, 0);
        this.rootComposite.setLayout((Layout)GridLayoutUtil.gl((int)1));
        Control control = this.createPageContents(this.rootComposite);
        control.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.updateValidation();
        this.setControl((Control)this.rootComposite);
    }

    protected Control createPageContents(Composite parent) {
        final IPropertyChangeListener delegateListener = new IPropertyChangeListener(){

            public void propertyChanged(String property, Object oldValue, Object newValue) {
                LibraryFacetInstallPage.this.updateValidation();
            }
        };
        this.libraryInstallDelegate.addListener(delegateListener, new String[0]);
        this.rootComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                LibraryFacetInstallPage.this.getLibraryInstallDelegate().removeListener(delegateListener);
            }
        });
        return LibraryProviderFrameworkUi.createInstallLibraryPanel(parent, this.libraryInstallDelegate);
    }

    protected final void updateValidation() {
        if (this.rootComposite.isDisposed()) {
            return;
        }
        if (this.rootComposite.getDisplay().getThread() != Thread.currentThread()) {
            this.rootComposite.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LibraryFacetInstallPage.this.updateValidation();
                }
            });
            return;
        }
        IStatus st = this.performValidation();
        int severity = st.getSeverity();
        if (severity == 4) {
            this.setMessage(st.getMessage(), 3);
            this.setPageComplete(false);
        } else {
            if (severity == 2) {
                this.setMessage(st.getMessage(), 2);
            } else if (severity == 1) {
                this.setMessage(st.getMessage(), 1);
            } else {
                this.setMessage(null);
            }
            this.setPageComplete(true);
        }
    }

    protected IStatus performValidation() {
        if (this.config != null) {
            return this.config.validate();
        }
        return Status.OK_STATUS;
    }
}

