/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.io.File;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class UtilTest
extends AbstractRegressionTest {
    StringBuffer camelCaseErrors;

    public UtilTest(String name) {
        super(name);
    }

    void assertCamelCase(String pattern, String name, boolean match) {
        boolean camelCase = CharOperation.camelCaseMatch((char[])(pattern == null ? null : pattern.toCharArray()), (char[])(name == null ? null : name.toCharArray()));
        if (match != camelCase) {
            StringBuffer line = new StringBuffer("'");
            line.append(name);
            line.append("' SHOULD");
            if (!match) {
                line.append(" NOT");
            }
            line.append(" match pattern '");
            line.append(pattern);
            line.append("', but it DOES");
            if (!camelCase) {
                line.append(" NOT");
            }
            if (this.camelCaseErrors.length() == 0) {
                System.out.println("Invalid results in test " + this.getName() + ":");
            }
            System.out.println("\t- " + line);
            this.camelCaseErrors.append('\n');
            this.camelCaseErrors.append(line);
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.camelCaseErrors = new StringBuffer();
    }

    public boolean checkPathMatch(char[] pattern, char[] path, boolean isCaseSensitive) {
        CharOperation.replace((char[])pattern, (char)'/', (char)File.separatorChar);
        CharOperation.replace((char[])pattern, (char)'\\', (char)File.separatorChar);
        CharOperation.replace((char[])path, (char)'/', (char)File.separatorChar);
        CharOperation.replace((char[])path, (char)'\\', (char)File.separatorChar);
        boolean result = CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)isCaseSensitive, (char)File.separatorChar);
        return result;
    }

    public void test01() {
        UtilTest.assertTrue((String)"Pattern matching failure", (!CharOperation.match((char[])"X".toCharArray(), (char[])"Xyz".toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void test02() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"X*".toCharArray(), (char[])"Xyz".toCharArray(), (boolean)true));
    }

    public void test03() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"X".toCharArray(), (char[])"X".toCharArray(), (boolean)true));
    }

    public void test04() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"X*X".toCharArray(), (char[])"XYX".toCharArray(), (boolean)true));
    }

    public void test05() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"XY*".toCharArray(), (char[])"XYZ".toCharArray(), (boolean)true));
    }

    public void test06() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"*XY*".toCharArray(), (char[])"XYZ".toCharArray(), (boolean)true));
    }

    public void test07() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"*".toCharArray(), (char[])"XYZ".toCharArray(), (boolean)true));
    }

    public void test08() {
        UtilTest.assertTrue((String)"Pattern matching failure", (!CharOperation.match((char[])"a*".toCharArray(), (char[])"XYZ".toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void test09() {
        UtilTest.assertTrue((String)"Pattern matching failure", (!CharOperation.match((char[])"abc".toCharArray(), (char[])"XYZ".toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void test10() {
        UtilTest.assertTrue((String)"Pattern matching failure", (!CharOperation.match((char[])"ab*c".toCharArray(), (char[])"abX".toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void test11() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"a*b*c".toCharArray(), (char[])"aXXbYYc".toCharArray(), (boolean)true));
    }

    public void test12() {
        UtilTest.assertTrue((String)"Pattern matching failure", (!CharOperation.match((char[])"*a*bc".toCharArray(), (char[])"aXXbYYc".toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void test13() {
        UtilTest.assertTrue((String)"Pattern matching failure", (!CharOperation.match((char[])"*foo*bar".toCharArray(), (char[])"".toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void test14() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"*foo*bar".toCharArray(), (char[])"ffoobabar".toCharArray(), (boolean)true));
    }

    public void test15() {
        UtilTest.assertTrue((String)"Pattern matching failure", (!CharOperation.match((char[])"*fol*bar".toCharArray(), (char[])"ffoobabar".toCharArray(), (boolean)true) ? 1 : 0) != 0);
    }

    public void test16() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"*X*Y*".toCharArray(), (char[])"XY".toCharArray(), (boolean)true));
    }

    public void test17() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"*X*Y*".toCharArray(), (char[])"XYZ".toCharArray(), (boolean)true));
    }

    public void test18() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"main(*)".toCharArray(), (char[])"main(argv)".toCharArray(), (boolean)true));
    }

    public void test19() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"*rr*".toCharArray(), (char[])"ARRAY".toCharArray(), (boolean)false));
    }

    public void test20() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"hello*World".toCharArray(), (char[])"helloWorld".toCharArray(), (boolean)true));
    }

    public void test21() {
        UtilTest.assertEquals("Trim failure", "hello", new String(CharOperation.trim((char[])"hello".toCharArray())));
    }

    public void test22() {
        UtilTest.assertEquals("Trim failure", "hello", new String(CharOperation.trim((char[])"   hello".toCharArray())));
    }

    public void test23() {
        UtilTest.assertEquals("Trim failure", "hello", new String(CharOperation.trim((char[])"   hello   ".toCharArray())));
    }

    public void test24() {
        UtilTest.assertEquals("Trim failure", "hello", new String(CharOperation.trim((char[])"hello   ".toCharArray())));
    }

    public void test25() {
        UtilTest.assertEquals("Trim failure", "", new String(CharOperation.trim((char[])"   ".toCharArray())));
    }

    public void test26() {
        UtilTest.assertEquals("Trim failure", "hello world", new String(CharOperation.trim((char[])" hello world  ".toCharArray())));
    }

    public void test27() {
        char[][] tokens = CharOperation.splitAndTrimOn((char)',', (char[])" hello,world".toCharArray());
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            buffer.append('[').append(tokens[i]).append(']');
            ++i;
        }
        UtilTest.assertEquals("SplitTrim failure", "[hello][world]", buffer.toString());
    }

    public void test28() {
        char[][] tokens = CharOperation.splitAndTrimOn((char)',', (char[])" hello , world".toCharArray());
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            buffer.append('[').append(tokens[i]).append(']');
            ++i;
        }
        UtilTest.assertEquals("SplitTrim failure", "[hello][world]", buffer.toString());
    }

    public void test29() {
        char[][] tokens = CharOperation.splitAndTrimOn((char)',', (char[])" hello, world   ".toCharArray());
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            buffer.append('[').append(tokens[i]).append(']');
            ++i;
        }
        UtilTest.assertEquals("SplitTrim failure", "[hello][world]", buffer.toString());
    }

    public void test30() {
        char[][] tokens = CharOperation.splitAndTrimOn((char)',', (char[])" hello, world   ,zork/, aaa bbb".toCharArray());
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            buffer.append('[').append(tokens[i]).append(']');
            ++i;
        }
        UtilTest.assertEquals("SplitTrim failure", "[hello][world][zork/][aaa bbb]", buffer.toString());
    }

    public void test31() {
        char[][] tokens = CharOperation.splitAndTrimOn((char)',', (char[])"  ,  ".toCharArray());
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            buffer.append('[').append(tokens[i]).append(']');
            ++i;
        }
        UtilTest.assertEquals("SplitTrim failure", "[][]", buffer.toString());
    }

    public void test32() {
        char[][] tokens = CharOperation.splitAndTrimOn((char)',', (char[])"   ".toCharArray());
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            buffer.append('[').append(tokens[i]).append(']');
            ++i;
        }
        UtilTest.assertEquals("SplitTrim failure", "[]", buffer.toString());
    }

    public void test33() {
        char[][] tokens = CharOperation.splitAndTrimOn((char)',', (char[])"  , hello  ".toCharArray());
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            buffer.append('[').append(tokens[i]).append(']');
            ++i;
        }
        UtilTest.assertEquals("SplitTrim failure", "[][hello]", buffer.toString());
    }

    public void test34() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("hello/*/World".toCharArray(), "hello/zzz/World".toCharArray(), true));
    }

    public void test35() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("hello/**/World".toCharArray(), "hello/x/y/z/World".toCharArray(), true));
    }

    public void test36() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("hello/**/World/**/*.java".toCharArray(), "hello/x/y/z/World/X.java".toCharArray(), true));
    }

    public void test37() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("**/World/**/*.java".toCharArray(), "hello/x/y/z/World/X.java".toCharArray(), true));
    }

    public void test38() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (!this.checkPathMatch("/*.java".toCharArray(), "/hello/x/y/z/World/X.java".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test39() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (boolean)this.checkPathMatch("**/CVS/*".toCharArray(), "CVS/Repository".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (boolean)this.checkPathMatch("**/CVS/*".toCharArray(), "org/apache/CVS/Entries".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-3", (boolean)this.checkPathMatch("**/CVS/*".toCharArray(), "org/apache/jakarta/tools/ant/CVS/Entries".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-4", (!this.checkPathMatch("**/CVS/*".toCharArray(), "org/apache/CVS/foo/bar/Entries".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test40() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (boolean)this.checkPathMatch("org/apache/jakarta/**".toCharArray(), "org/apache/jakarta/tools/ant/docs/index.html".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (boolean)this.checkPathMatch("org/apache/jakarta/**".toCharArray(), "org/apache/jakarta/test.xml".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-3", (!this.checkPathMatch("org/apache/jakarta/**".toCharArray(), "org/apache/xyz.java".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test41() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (boolean)this.checkPathMatch("org/apache/**/CVS/*".toCharArray(), "org/apache/CVS/Entries".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (boolean)this.checkPathMatch("org/apache/**/CVS/*".toCharArray(), "org/apache/jakarta/tools/ant/CVS/Entries".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-3", (!this.checkPathMatch("org/apache/**/CVS/*".toCharArray(), "org/apache/CVS/foo/bar/Entries".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test42() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (boolean)this.checkPathMatch("**/test/**".toCharArray(), "org/apache/test/CVS/Entries".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (boolean)this.checkPathMatch("**/test/**".toCharArray(), "test".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-3", (boolean)this.checkPathMatch("**/test/**".toCharArray(), "a/test".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-4", (boolean)this.checkPathMatch("**/test/**".toCharArray(), "test/a.js".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-5", (!this.checkPathMatch("**/test/**".toCharArray(), "org/apache/test.js".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test43() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (boolean)this.checkPathMatch("/test/".toCharArray(), "/test/CVS/Entries".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (boolean)this.checkPathMatch("/test/**".toCharArray(), "/test/CVS/Entries".toCharArray(), true));
    }

    public void test44() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (!this.checkPathMatch("test".toCharArray(), "test/CVS/Entries".toCharArray(), true) ? 1 : 0) != 0);
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (!this.checkPathMatch("**/test".toCharArray(), "test/CVS/Entries".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test45() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (boolean)this.checkPathMatch("/test/test1/".toCharArray(), "/test/test1/test/test1".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (!this.checkPathMatch("/test/test1".toCharArray(), "/test/test1/test/test1".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test46() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("hello/**/World".toCharArray(), "hello/World".toCharArray(), true));
    }

    public void test47() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"*x".toCharArray(), (char[])"x.X".toCharArray(), (boolean)false));
    }

    public void test48() {
        UtilTest.assertTrue((String)"Pattern matching failure", (boolean)CharOperation.match((char[])"*a*".toCharArray(), (char[])"abcd".toCharArray(), (boolean)false));
    }

    public void test49() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("**/hello".toCharArray(), "hello/hello".toCharArray(), true));
    }

    public void test50() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("**/hello/**".toCharArray(), "hello/hello".toCharArray(), true));
    }

    public void test51() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("**/hello/".toCharArray(), "hello/hello".toCharArray(), true));
    }

    public void test52() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("hello/".toCharArray(), "hello/hello".toCharArray(), true));
    }

    public void test53() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (!this.checkPathMatch("/".toCharArray(), "hello/hello".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test54() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (!this.checkPathMatch("x/".toCharArray(), "hello/x".toCharArray(), true) ? 1 : 0) != 0);
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (boolean)this.checkPathMatch("**/x/".toCharArray(), "hello/x".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-3", (!this.checkPathMatch("/x/".toCharArray(), "hello/x".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test56() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (!this.checkPathMatch("/**".toCharArray(), "hello/hello".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test57() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("/".toCharArray(), "/hello/hello".toCharArray(), true));
    }

    public void test58() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (boolean)this.checkPathMatch("/**".toCharArray(), "/hello/hello".toCharArray(), true));
    }

    public void test59() {
        UtilTest.assertTrue((String)"Path pattern matching failure", (!this.checkPathMatch("**".toCharArray(), "/hello/hello".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test60() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (!this.checkPathMatch("/P/src".toCharArray(), "/P/src/X".toCharArray(), true) ? 1 : 0) != 0);
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (!this.checkPathMatch("/P/**/src".toCharArray(), "/P/src/X".toCharArray(), true) ? 1 : 0) != 0);
        UtilTest.assertTrue((String)"Path pattern matching failure-3", (boolean)this.checkPathMatch("/P/src".toCharArray(), "/P/src".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-4", (!this.checkPathMatch("A.java".toCharArray(), "/P/src/A.java".toCharArray(), true) ? 1 : 0) != 0);
    }

    public void test61() {
        UtilTest.assertTrue((String)"Path pattern matching failure-1", (boolean)this.checkPathMatch("/P/src/**/CVS".toCharArray(), "/P/src/CVS".toCharArray(), true));
        UtilTest.assertTrue((String)"Path pattern matching failure-2", (boolean)this.checkPathMatch("/P/src/**/CVS/".toCharArray(), "/P/src/CVS".toCharArray(), true));
    }

    public void test62() {
        this.assertCamelCase("NPE", "NullPointerException", true);
        this.assertCamelCase("NPExc", "NullPointerException", true);
        this.assertCamelCase("NPoE", "NullPointerException", true);
        this.assertCamelCase("NuPExc", "NullPointerException", true);
        UtilTest.assertTrue((String)this.camelCaseErrors.toString(), (this.camelCaseErrors.length() == 0 ? 1 : 0) != 0);
    }

    public void test63() {
        this.assertCamelCase("NPEX", "NullPointerException", false);
        this.assertCamelCase("NPex", "NullPointerException", false);
        this.assertCamelCase("npe", "NullPointerException", false);
        this.assertCamelCase("npe", "NPException", false);
        this.assertCamelCase("NPointerE", "NullPointerException", true);
        UtilTest.assertTrue((String)this.camelCaseErrors.toString(), (this.camelCaseErrors.length() == 0 ? 1 : 0) != 0);
    }

    public void test64() {
        this.assertCamelCase("IAE", "IgnoreAllErrorHandler", true);
        this.assertCamelCase("IAE", "IAnchorElement", true);
        this.assertCamelCase("IAnchorEleme", "IAnchorElement", true);
        this.assertCamelCase("", "IAnchorElement", false);
        this.assertCamelCase(null, "IAnchorElement", true);
        this.assertCamelCase("", "", true);
        this.assertCamelCase("IAnchor", null, false);
        UtilTest.assertTrue((String)this.camelCaseErrors.toString(), (this.camelCaseErrors.length() == 0 ? 1 : 0) != 0);
    }

    public void test65() {
        this.assertCamelCase("iSCDCo", "invokeStringConcatenationDefaultConstructor", true);
        this.assertCamelCase("inVOke", "invokeStringConcatenationDefaultConstructor", false);
        this.assertCamelCase("i", "invokeStringConcatenationDefaultConstructor", true);
        this.assertCamelCase("I", "invokeStringConcatenationDefaultConstructor", false);
        this.assertCamelCase("iStringCD", "invokeStringConcatenationDefaultConstructor", true);
        this.assertCamelCase("NPE", "NullPointerException/java.lang", true);
        this.assertCamelCase("NPE", "NullPointer/lang.Exception", false);
        this.assertCamelCase("NPE", "Null_Pointer$Exception", true);
        this.assertCamelCase("NPE", "Null1Pointer2Exception", true);
        this.assertCamelCase("NPE", "Null.Pointer.Exception", false);
        this.assertCamelCase("NPE", "aNullPointerException", false);
        this.assertCamelCase("nullP", "nullPointerException", true);
        this.assertCamelCase("nP", "nullPointerException", true);
        UtilTest.assertTrue((String)this.camelCaseErrors.toString(), (this.camelCaseErrors.length() == 0 ? 1 : 0) != 0);
    }

    public void test66() {
        String[][] MATCHES = new String[][]{{"TZ", "TimeZone"}, {"TiZ", "TimeZone"}, {"TiZon", "TimeZone"}, {"TZon", "TimeZone"}, {"TZone", "TimeZone"}, {"TimeZone", "TimeZone"}, {"TimeZ", "TimeZ"}, {"TZ", "TimeZ"}, {"T", "TimeZ"}, {"T", "TimeZone"}, {"TZ", "TZ"}, {"aT", "aTimeZone"}, {"aTi", "aTimeZone"}, {"aTiZ", "aTimeZone"}, {"aTZ", "aTimeZone"}, {"aT", "artTimeZone"}, {"aTi", "artTimeZone"}, {"aTiZ", "artTimeZone"}, {"aTZ", "artTimeZone"}};
        int i = 0;
        while (i < MATCHES.length) {
            String[] match = MATCHES[i];
            this.assertCamelCase(match[0], match[1], true);
            ++i;
        }
        String[][] MIS_MATCHES = new String[][]{{"TZ", "Timezone"}, {"aTZ", "TimeZone"}, {"aTZ", "TZ"}, {"arT", "aTimeZone"}, {"arTi", "aTimeZone"}, {"arTiZ", "aTimeZone"}, {"arTZ", "aTimeZone"}, {"aT", "atimeZone"}};
        int i2 = 0;
        while (i2 < MIS_MATCHES.length) {
            String[] match = MIS_MATCHES[i2];
            this.assertCamelCase(match[0], match[1], false);
            ++i2;
        }
        UtilTest.assertTrue((String)this.camelCaseErrors.toString(), (this.camelCaseErrors.length() == 0 ? 1 : 0) != 0);
    }

    public void test67() {
        this.assertCamelCase("runtimeEx", "RuntimeException", false);
        this.assertCamelCase("Runtimeex", "RuntimeException", false);
        this.assertCamelCase("runtimeexception", "RuntimeException", false);
        this.assertCamelCase("Runtimexception", "RuntimeException", false);
        this.assertCamelCase("illegalMSException", "IllegalMonitorStateException", false);
        this.assertCamelCase("illegalMsException", "IllegalMonitorStateException", false);
        this.assertCamelCase("IllegalMSException", "IllegalMonitorStateException", true);
        this.assertCamelCase("IllegalMsException", "IllegalMonitorStateException", false);
        this.assertCamelCase("clonenotsupportedex", "CloneNotSupportedException", false);
        this.assertCamelCase("CloneNotSupportedEx", "CloneNotSupportedException", true);
        this.assertCamelCase("cloneNotsupportedEx", "CloneNotSupportedException", false);
        this.assertCamelCase("ClonenotSupportedexc", "CloneNotSupportedException", false);
        this.assertCamelCase("cloneNotSupportedExcep", "CloneNotSupportedException", false);
        this.assertCamelCase("Clonenotsupportedexception", "CloneNotSupportedException", false);
        this.assertCamelCase("CloneNotSupportedException", "CloneNotSupportedException", true);
        UtilTest.assertTrue((String)this.camelCaseErrors.toString(), (this.camelCaseErrors.length() == 0 ? 1 : 0) != 0);
    }

    public void test68() {
        this.assertCamelCase("aMe", "aMethod", true);
        this.assertCamelCase("ame", "aMethod", false);
        this.assertCamelCase("longNOM", "longNameOfMethod", true);
        this.assertCamelCase("longNOMeth", "longNameOfMethod", true);
        this.assertCamelCase("longNOMethod", "longNameOfMethod", true);
        this.assertCamelCase("longNoMethod", "longNameOfMethod", false);
        UtilTest.assertTrue((String)this.camelCaseErrors.toString(), (this.camelCaseErrors.length() == 0 ? 1 : 0) != 0);
    }

    public void test69() {
        this.assertCamelCase("aa", "AxxAyy", false);
        this.assertCamelCase("Aa", "AxxAyy", false);
        this.assertCamelCase("aA", "AxxAyy", false);
        this.assertCamelCase("AA", "AxxAyy", true);
        this.assertCamelCase("aa", "AbcdAbcdefAbcAbcdefghAbAAzzzzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnAbcAbcdefghijklm", false);
        this.assertCamelCase("AA", "AbcdAbcdefAbcAbcdefghAbAAzzzzAbcdefghijklmnopqrstuvwxyzAbcdefghijklmnAbcAbcdefghijklm", true);
        UtilTest.assertTrue((String)this.camelCaseErrors.toString(), (this.camelCaseErrors.length() == 0 ? 1 : 0) != 0);
    }

    public static Class testClass() {
        return UtilTest.class;
    }
}

