/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.versionchecker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class DependencyChecker
implements IApplication {
    private static final String CONSERVATIVE_DIRECTIVE = "-conservative";
    private static final String FILTER_DIRECTIVE = "-filter";
    private static final String WORKSPACEROOT_DIRECTIVE = "-workspaceRoot";
    private static final String REQUIRE_BUNDLE = "Require-Bundle:";
    private static final String EOL = System.getProperty("line.separator");
    private boolean conservative = false;
    private String workspaceroot;

    public Object run(Object o) throws Exception {
        String[] args = o instanceof String[] ? (String[])o : Platform.getApplicationArgs();
        String filter = null;
        int nArgs = 0;
        while (nArgs < args.length) {
            if (args[nArgs].equals(FILTER_DIRECTIVE) && nArgs + 1 < args.length) {
                filter = args[nArgs + 1];
            } else if (args[nArgs].equals(CONSERVATIVE_DIRECTIVE)) {
                this.conservative = true;
            } else if (args[nArgs].equals(WORKSPACEROOT_DIRECTIVE) && nArgs + 1 < args.length) {
                this.workspaceroot = args[nArgs + 1];
            }
            ++nArgs;
        }
        BundleDescription[] bundles = Platform.getPlatformAdmin().getState().getBundles();
        int i = 0;
        while (i < bundles.length) {
            String bundleName = bundles[i].getSymbolicName();
            if (filter == null || bundleName.matches(filter)) {
                BundleSpecification[] req = bundles[i].getRequiredBundles();
                ArrayList<String> bundleSpecStrings = new ArrayList<String>();
                int j = 0;
                while (j < req.length) {
                    BundleDescription required;
                    BundleSpecification currentBundle = req[j];
                    VersionRange specifiedRange = currentBundle.getVersionRange();
                    if (specifiedRange == VersionRange.emptyRange && (required = Platform.getPlatformAdmin().getState().getBundle(currentBundle.getName(), null)) != null) {
                        Version reqVersion = required.getVersion();
                        Version minVersion = new Version(reqVersion.getMajor(), reqVersion.getMinor(), reqVersion.getMicro());
                        Version maxVersion = null;
                        maxVersion = this.conservative ? new Version(minVersion.getMajor(), minVersion.getMinor() + 1, 0) : new Version(minVersion.getMajor() + 1, 0, 0);
                        String name = currentBundle.getName();
                        String exported = "";
                        if (currentBundle.isExported()) {
                            exported = ";visibility:=reexport";
                        }
                        String optional = "";
                        if (currentBundle.isOptional()) {
                            exported = ";resolution:=optional";
                        }
                        String requiredRange = ";bundle-version=\"" + new VersionRange(minVersion, true, maxVersion, false) + "\"";
                        String spec = new String(" " + name + exported + optional + requiredRange);
                        bundleSpecStrings.add(spec);
                    }
                    ++j;
                }
                if (bundleSpecStrings.size() > 0) {
                    System.out.println();
                    System.out.println("bundle " + bundleName);
                    StringBuffer sb = this.formStringBuffer(bundleSpecStrings);
                    System.out.println(sb);
                    if (this.workspaceroot != null) {
                        this.rewriteManifest(bundleName, sb);
                    }
                }
            }
            ++i;
        }
        return IApplication.EXIT_OK;
    }

    private void rewriteManifest(String bundleName, StringBuffer sb) throws IOException {
        try {
            FileReader reader = new FileReader(String.valueOf(this.workspaceroot) + bundleName + "/META-INF/MANIFEST.MF");
            BufferedReader bufferedReader = new BufferedReader(reader);
            ArrayList<String> initialLines = new ArrayList<String>();
            ArrayList<String> finalLines = new ArrayList<String>();
            String inline = null;
            inline = bufferedReader.readLine();
            while (inline != null && !inline.startsWith(REQUIRE_BUNDLE)) {
                initialLines.add(new String(inline));
                inline = bufferedReader.readLine();
            }
            if (inline != null) {
                inline = bufferedReader.readLine();
                while (inline != null && inline.startsWith(" ")) {
                    inline = bufferedReader.readLine();
                }
            }
            while (inline != null) {
                finalLines.add(new String(inline));
                inline = bufferedReader.readLine();
            }
            bufferedReader.close();
            FileWriter writer = new FileWriter(String.valueOf(this.workspaceroot) + bundleName + "/META-INF/MANIFEST.MF");
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            int lines = 0;
            while (lines < initialLines.size()) {
                bufferedWriter.write(initialLines.get(lines) + EOL);
                ++lines;
            }
            bufferedWriter.write(sb.toString());
            lines = 0;
            while (lines < finalLines.size()) {
                bufferedWriter.write(finalLines.get(lines) + EOL);
                ++lines;
            }
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    private StringBuffer formStringBuffer(ArrayList bundleSpecStrings) {
        StringBuffer sb = new StringBuffer();
        sb.append(REQUIRE_BUNDLE);
        int k = 0;
        while (k < bundleSpecStrings.size()) {
            sb.append(bundleSpecStrings.get(k));
            String COMMA = "";
            if (k < bundleSpecStrings.size() - 1) {
                COMMA = ",";
            }
            sb.append(String.valueOf(COMMA) + EOL);
            ++k;
        }
        return sb;
    }

    public Object start(IApplicationContext context) throws Exception {
        return this.run(context.getArguments().get("application.args"));
    }

    public void stop() {
    }
}

