/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IModelElementSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.AbstractMethodSynchronizer;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;

public class WSMethodSynchronizer
extends AbstractMethodSynchronizer {
    public WSMethodSynchronizer(IModelElementSynchronizer parent) {
        super(parent);
    }

    @Override
    protected void visitExposableMethods(AbstractMethodSynchronizer.IMethodVisitor visitor, ITypeHierarchy hierarchy, IAnnotationInspector inspector) throws JavaModelException {
        this.visitRecursively(visitor, hierarchy.getType(), hierarchy, inspector);
    }

    private void visitRecursively(AbstractMethodSynchronizer.IMethodVisitor visitor, IType type, ITypeHierarchy hierarchy, IAnnotationInspector inspector) throws JavaModelException {
        if (type == null) {
            return;
        }
        assert (type.isClass());
        boolean isWebService = inspector.inspectType("javax.jws.WebService") != null;
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (!method.isConstructor()) {
                boolean isExcludedWithAnnotation;
                IAnnotation wmAnnotation = inspector.inspectMethod(method, "javax.jws.WebMethod");
                boolean bl = isExcludedWithAnnotation = wmAnnotation == null ? false : "true".equals(wmAnnotation.getPropertyValue("exclude"));
                if (Modifier.isPublic((int)method.getFlags()) && !isExcludedWithAnnotation && (isWebService || wmAnnotation != null)) {
                    visitor.visit(method, inspector);
                }
            }
            ++n2;
        }
        IType superType = hierarchy.getSuperclass(type);
        if (superType != null) {
            this.visitRecursively(visitor, superType, hierarchy, this.resource().newAnnotationInspector(superType));
        }
    }
}

