/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.reference.AbstractIntReference;
import org.eclipse.jpt.common.utility.reference.ModifiableIntReference;

public abstract class AbstractModifiableIntReference
extends AbstractIntReference
implements ModifiableIntReference {
    protected AbstractModifiableIntReference() {
    }

    @Override
    public int setZero() {
        return this.setValue(0);
    }

    @Override
    public int increment() {
        int v = this.getValue();
        this.setValue(++v);
        return v;
    }

    @Override
    public int incrementExact() {
        int v = this.getValue();
        v = Math.incrementExact(v);
        this.setValue(v);
        return v;
    }

    @Override
    public int decrement() {
        int v = this.getValue();
        this.setValue(--v);
        return v;
    }

    @Override
    public int decrementExact() {
        int v = this.getValue();
        v = Math.decrementExact(v);
        this.setValue(v);
        return v;
    }

    @Override
    public int halve() {
        int v = this.getValue();
        v = BitTools.half(v);
        this.setValue(v);
        return v;
    }

    @Override
    public int twice() {
        int v = this.getValue();
        v = BitTools.twice(v);
        this.setValue(v);
        return v;
    }

    @Override
    public int twiceExact() {
        int v = this.getValue();
        v = Math.multiplyExact(v, 2);
        this.setValue(v);
        return v;
    }

    @Override
    public int abs() {
        int v = this.getValue();
        v = Math.abs(v);
        this.setValue(v);
        return v;
    }

    @Override
    public int negate() {
        int v = this.getValue();
        v = -v;
        this.setValue(v);
        return v;
    }

    @Override
    public int negateExact() {
        int v = this.getValue();
        v = Math.negateExact(v);
        this.setValue(v);
        return v;
    }

    @Override
    public int add(int i) {
        int v = this.getValue();
        this.setValue(v += i);
        return v;
    }

    @Override
    public int addExact(int i) {
        int v = this.getValue();
        v = Math.addExact(v, i);
        this.setValue(v);
        return v;
    }

    @Override
    public int subtract(int i) {
        int v = this.getValue();
        this.setValue(v -= i);
        return v;
    }

    @Override
    public int subtractExact(int i) {
        int v = this.getValue();
        v = Math.subtractExact(v, i);
        this.setValue(v);
        return v;
    }

    @Override
    public int multiply(int i) {
        int v = this.getValue();
        this.setValue(v *= i);
        return v;
    }

    @Override
    public int multiplyExact(int i) {
        int v = this.getValue();
        v = Math.multiplyExact(v, i);
        this.setValue(v);
        return v;
    }

    @Override
    public int divide(int i) {
        int v = this.getValue();
        this.setValue(v /= i);
        return v;
    }

    @Override
    public int floorDivide(int i) {
        int v = this.getValue();
        v = Math.floorDiv(v, i);
        this.setValue(v);
        return v;
    }

    @Override
    public int remainder(int i) {
        int v = this.getValue();
        this.setValue(v %= i);
        return v;
    }

    @Override
    public int floorRemainder(int i) {
        int v = this.getValue();
        v = Math.floorMod(v, i);
        this.setValue(v);
        return v;
    }

    @Override
    public int min(int i) {
        int v = this.getValue();
        v = Math.min(v, i);
        this.setValue(v);
        return v;
    }

    @Override
    public int max(int i) {
        int v = this.getValue();
        v = Math.max(v, i);
        this.setValue(v);
        return v;
    }

    @Override
    public boolean commit(int newValue, int expectedValue) {
        if (this.getValue() == expectedValue) {
            this.setValue(newValue);
            return true;
        }
        return false;
    }

    @Override
    public int swap(ModifiableIntReference other) {
        if (other == this) {
            return this.getValue();
        }
        int otherValue = other.getValue();
        if (otherValue == this.getValue()) {
            return this.getValue();
        }
        other.setValue(this.getValue());
        this.setValue(otherValue);
        return otherValue;
    }
}

