/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.xsd.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.axis.model.ecore.EAttribute;
import org.apache.axis.model.ecore.EClass;
import org.apache.axis.model.ecore.InternalEObject;
import org.apache.axis.model.ecore.impl.ENotificationImpl;
import org.apache.axis.model.ecore.util.EObjectEList;
import org.apache.axis.model.ecore.xml.type.util.XMLTypeUtil;
import org.apache.axis.model.xsd.XSDComplexTypeDefinition;
import org.apache.axis.model.xsd.XSDConcreteComponent;
import org.apache.axis.model.xsd.XSDNamedComponent;
import org.apache.axis.model.xsd.XSDPackage;
import org.apache.axis.model.xsd.XSDPlugin;
import org.apache.axis.model.xsd.XSDSchema;
import org.apache.axis.model.xsd.XSDSimpleTypeDefinition;
import org.apache.axis.model.xsd.impl.XSDComponentImpl;
import org.apache.axis.model.xsd.impl.XSDSchemaImpl;
import org.apache.axis.model.xsd.util.XSDConstants;
import org.w3c.dom.Element;

public abstract class XSDNamedComponentImpl
extends XSDComponentImpl
implements XSDNamedComponent {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String TARGET_NAMESPACE_EDEFAULT = null;
    protected String targetNamespace = TARGET_NAMESPACE_EDEFAULT;
    protected static final String ALIAS_NAME_EDEFAULT = null;
    protected static final String URI_EDEFAULT = null;
    protected static final String ALIAS_URI_EDEFAULT = null;
    protected static final String QNAME_EDEFAULT = null;

    public static List sortNamedComponents(Collection xsdNamedComponents) {
        Object[] objects = xsdNamedComponents.toArray();
        Arrays.sort(objects, Comparator.getInstance());
        return Arrays.asList(objects);
    }

    public static void addToSortedList(List xsdNamedComponents, XSDNamedComponent xsdNamedComponent) {
        int index = Collections.binarySearch(xsdNamedComponents, xsdNamedComponent, Comparator.getInstance());
        if (index < 0) {
            xsdNamedComponents.add(-(index + 1), xsdNamedComponent);
        } else if (xsdNamedComponents.get(index) != xsdNamedComponent) {
            xsdNamedComponents.add(index, xsdNamedComponent);
        }
    }

    public static XSDNamedComponent findInSortedList(List xsdNamedComponents, String targetNamespace, String localName) {
        if (xsdNamedComponents instanceof XSDNamedComponentList) {
            return ((XSDNamedComponentList)xsdNamedComponents).get(targetNamespace, localName);
        }
        int index = Collections.binarySearch(xsdNamedComponents, new String[]{targetNamespace, localName}, StringPairComparator.getInstance());
        if (index < 0) {
            return null;
        }
        return (XSDNamedComponent)xsdNamedComponents.get(index);
    }

    public static void mergeToSortedList(List xsdNamedComponentsTarget, List xsdNamedComponentsSource) {
        Iterator sourceComponents = xsdNamedComponentsSource.iterator();
        if (sourceComponents.hasNext()) {
            Comparator comparator = Comparator.getInstance();
            Object sourceComponent = sourceComponents.next();
            ListIterator targetComponents = xsdNamedComponentsTarget.listIterator();
            while (targetComponents.hasNext()) {
                Object targetComponent = targetComponents.next();
                if (targetComponent != sourceComponent) {
                    if (comparator.compare(sourceComponent, targetComponent) >= 0) continue;
                    targetComponents.previous();
                    targetComponents.add(sourceComponent);
                }
                if (sourceComponents.hasNext()) {
                    sourceComponent = sourceComponents.next();
                    continue;
                }
                sourceComponent = null;
                break;
            }
            if (sourceComponent != null) {
                xsdNamedComponentsTarget.add(sourceComponent);
                while (sourceComponents.hasNext()) {
                    sourceComponent = sourceComponents.next();
                    xsdNamedComponentsTarget.add(sourceComponent);
                }
            }
        }
    }

    protected XSDNamedComponentImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_NAMED_COMPONENT;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldName, (Object)this.name));
        }
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String newTargetNamespace) {
        String oldTargetNamespace = this.targetNamespace;
        this.targetNamespace = newTargetNamespace;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldTargetNamespace, (Object)this.targetNamespace));
        }
    }

    protected String getURIReferenceLabel() {
        return this.getName();
    }

    public String getAliasName() {
        XSDConcreteComponent container;
        String result = this.getName();
        if (result == null && (container = this.getContainer()) instanceof XSDNamedComponent) {
            XSDNamedComponent xsdNamedComponent = (XSDNamedComponent)container;
            String baseName = xsdNamedComponent.getAliasName();
            if (container instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)container;
                switch (xsdSimpleTypeDefinition.getVariety().getValue()) {
                    case 0: {
                        result = String.valueOf(baseName) + "_._base";
                        break;
                    }
                    case 1: {
                        result = String.valueOf(baseName) + (XSDConstants.isURType(xsdSimpleTypeDefinition.getBaseTypeDefinition()) ? "_._item" : "_._base");
                        break;
                    }
                    case 2: {
                        result = String.valueOf(baseName) + (XSDConstants.isURType(xsdSimpleTypeDefinition.getBaseTypeDefinition()) ? "_._member_._" + xsdSimpleTypeDefinition.getMemberTypeDefinitions().indexOf(this) : "_._base");
                    }
                }
            } else {
                result = container instanceof XSDComplexTypeDefinition ? String.valueOf(baseName) + "_._base" : String.valueOf(baseName) + "_._type";
            }
        }
        return result;
    }

    public String getURI() {
        String theName;
        String theTargetNamespace = this.getTargetNamespace();
        if (theTargetNamespace == null) {
            theTargetNamespace = "";
        }
        if ((theName = this.getName()) == null) {
            theName = this.getAliasName();
        }
        return String.valueOf(theTargetNamespace) + "#" + theName;
    }

    public String getAliasURI() {
        String theName;
        String theTargetNamespace;
        XSDSchema xsdSchema = this.getSchema();
        String string = theTargetNamespace = xsdSchema == null ? this.getTargetNamespace() : xsdSchema.getTargetNamespace();
        if (theTargetNamespace == null) {
            theTargetNamespace = "";
        }
        if ((theName = this.getAliasName()) == null) {
            theName = this.getAliasName();
        }
        return String.valueOf(theTargetNamespace) + "#" + theName;
    }

    public String getQName(XSDConcreteComponent relativeToComponent) {
        String qualifier;
        Element theElement;
        String theName = this.getName();
        if (theName != null && relativeToComponent != null && (theElement = relativeToComponent.getElement()) != null && (qualifier = XSDConstants.lookupQualifier(theElement, this.getTargetNamespace())) != null && qualifier.length() != 0) {
            return String.valueOf(qualifier) + ":" + theName;
        }
        return theName;
    }

    public String getQName() {
        return this.getQName(this);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getTargetNamespace();
            }
            case 7: {
                return this.getAliasName();
            }
            case 8: {
                return this.getURI();
            }
            case 9: {
                return this.getAliasURI();
            }
            case 10: {
                return this.getQName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setTargetNamespace((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setTargetNamespace(TARGET_NAMESPACE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 6: {
                return TARGET_NAMESPACE_EDEFAULT == null ? this.targetNamespace != null : !TARGET_NAMESPACE_EDEFAULT.equals(this.targetNamespace);
            }
            case 7: {
                return ALIAS_NAME_EDEFAULT == null ? this.getAliasName() != null : !ALIAS_NAME_EDEFAULT.equals(this.getAliasName());
            }
            case 8: {
                return URI_EDEFAULT == null ? this.getURI() != null : !URI_EDEFAULT.equals(this.getURI());
            }
            case 9: {
                return ALIAS_URI_EDEFAULT == null ? this.getAliasURI() != null : !ALIAS_URI_EDEFAULT.equals(this.getAliasURI());
            }
            case 10: {
                return QNAME_EDEFAULT == null ? this.getQName() != null : !QNAME_EDEFAULT.equals(this.getQName());
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", targetNamespace: ");
        result.append(this.targetNamespace);
        result.append(')');
        return result.toString();
    }

    protected void patch() {
        this.patchTargetNamespaceAttribute();
        super.patch();
    }

    protected void patchTargetNamespaceAttribute() {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            this.patchTargetNamespaceAttribute(xsdSchema);
        }
    }

    protected void patchTargetNamespaceAttribute(XSDSchema xsdSchema) {
        String newTargetNamespace = xsdSchema.getTargetNamespace();
        if (newTargetNamespace == null ? this.getTargetNamespace() != null : !newTargetNamespace.equals(this.getTargetNamespace())) {
            this.setTargetNamespace(newTargetNamespace);
        }
    }

    protected void adoptBy(XSDSchema xsdSchema) {
        this.patchTargetNamespaceAttribute(xsdSchema);
        super.adoptBy(xsdSchema);
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            this.reconcileNameAttribute();
        }
    }

    protected void reconcileNameAttribute() {
        Element theElement = this.getElement();
        if (theElement.hasAttributeNS(null, "name")) {
            String newName = XMLTypeUtil.normalize(theElement.getAttributeNS(null, "name"), true);
            if (!newName.equals(this.getName())) {
                this.setName(newName);
            }
        } else if (this.getName() != null) {
            this.setName(null);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (!(this.isNamedComponentReference() || eAttribute != null && eAttribute != XSDPackage.Literals.XSD_NAMED_COMPONENT__NAME)) {
            Element theElement;
            XSDSchemaImpl xsdSchema;
            if (eAttribute != null && (xsdSchema = (XSDSchemaImpl)this.getSchema()) != null) {
                xsdSchema.updateSortedList(this);
            }
            if ((theElement = this.getElement()) != null) {
                this.niceSetAttribute(theElement, "name", this.getName());
            }
            if (eAttribute != null) {
                this.traverseToRootForPatching();
            }
        }
    }

    public boolean isNamedComponentReference() {
        return false;
    }

    public XSDNamedComponent getResolvedNamedComponent() {
        return this;
    }

    public boolean hasSameNameAndTargetNamespace(XSDNamedComponent xsdNamedComponent) {
        return (this.getTargetNamespace() == null ? xsdNamedComponent.getTargetNamespace() == null : this.getTargetNamespace().equals(xsdNamedComponent.getTargetNamespace())) && (this.getName() == null ? xsdNamedComponent.getName() == null : this.getName().equals(xsdNamedComponent.getName()));
    }

    public boolean hasNameAndTargetNamespace(String name, String targetNamespace) {
        return (targetNamespace == null ? this.getTargetNamespace() == null : targetNamespace.equals(this.getTargetNamespace())) && (name == null ? this.getName() == null : name.equals(this.getName()));
    }

    public boolean hasURI(String uri) {
        String theName;
        String theTargetNamespace = this.getTargetNamespace();
        if (theTargetNamespace == null) {
            theTargetNamespace = "";
        }
        if ((theName = this.getName()) == null) {
            theName = "";
        }
        return uri.startsWith(theTargetNamespace) && uri.endsWith(theName) && uri.length() == theName.length() + theTargetNamespace.length() + 1;
    }

    public static class XSDNamedComponentList
    extends EObjectEList {
        protected Map map;
        protected XSDSchemaImpl xsdSchema;

        public XSDNamedComponentList(Class dataClass, XSDSchemaImpl owner, int featureID) {
            super(dataClass, owner, featureID);
            this.xsdSchema = owner;
        }

        protected boolean isFromThisNamespace(XSDNamedComponent xsdNamedComponent) {
            String targetNamespace = xsdNamedComponent.getTargetNamespace();
            return targetNamespace == null ? this.xsdSchema.getTargetNamespace() == null : targetNamespace.equals(this.xsdSchema.getTargetNamespace());
        }

        protected void didAdd(int index, Object newObject) {
            XSDNamedComponent xsdNamedComponent = (XSDNamedComponent)newObject;
            if (this.isFromThisNamespace(xsdNamedComponent)) {
                if (this.map == null) {
                    this.map = new HashMap();
                }
                this.map.put(xsdNamedComponent.getName(), xsdNamedComponent);
            }
        }

        protected void didClear(int size, Object[] oldObjects) {
            this.map = null;
        }

        protected void didRemove(int index, Object oldObject) {
            XSDNamedComponent xsdNamedComponent;
            if (this.map != null && this.isFromThisNamespace(xsdNamedComponent = (XSDNamedComponent)oldObject)) {
                this.map.values().remove(xsdNamedComponent);
            }
        }

        protected void didSet(int index, Object newObject, Object oldObject) {
            this.didRemove(index, oldObject);
            this.didAdd(index, newObject);
        }

        public XSDNamedComponent get(String targetNamespace, String localName) {
            if (this.isEmpty()) {
                return null;
            }
            if (targetNamespace == null ? this.xsdSchema.getTargetNamespace() == null : targetNamespace.equals(this.xsdSchema.getTargetNamespace())) {
                if (this.map == null) {
                    return null;
                }
                XSDNamedComponent result = (XSDNamedComponent)this.map.get(localName);
                return result;
            }
            int index = Collections.binarySearch(this, new String[]{targetNamespace, localName}, StringPairComparator.getInstance());
            if (index < 0) {
                return null;
            }
            return (XSDNamedComponent)this.get(index);
        }
    }

    public static class Comparator
    implements java.util.Comparator {
        protected static Comparator instance = new Comparator();
        protected XSDPlugin.StringComparator collator = XSDPlugin.INSTANCE.getComparator();

        public static Comparator getInstance() {
            if (instance == null) {
                instance = new Comparator();
            }
            return instance;
        }

        public boolean equals(Object that) {
            return this == that;
        }

        public int compare(Object o1, Object o2) {
            XSDNamedComponent xsdNamedComponent1 = (XSDNamedComponent)o1;
            XSDNamedComponent xsdNamedComponent2 = (XSDNamedComponent)o2;
            String name1 = xsdNamedComponent1.getName();
            String name2 = xsdNamedComponent2.getName();
            if (name1 == null && name2 == null) {
                return xsdNamedComponent1.hashCode() - xsdNamedComponent2.hashCode();
            }
            if (name1 == null) {
                return 1;
            }
            if (name2 == null) {
                return -1;
            }
            int result = this.collator.compare(name1, name2);
            if (result == 0) {
                String namespace1 = xsdNamedComponent1.getTargetNamespace();
                String namespace2 = xsdNamedComponent2.getTargetNamespace();
                if (namespace1 == null && namespace2 == null) {
                    return xsdNamedComponent1.hashCode() - xsdNamedComponent2.hashCode();
                }
                if (namespace1 == null) {
                    return 1;
                }
                if (namespace2 == null) {
                    return -1;
                }
                result = this.collator.compare(namespace1, namespace2);
                if (result == 0) {
                    result = xsdNamedComponent1.hashCode() - xsdNamedComponent2.hashCode();
                }
                return result;
            }
            return result;
        }
    }

    public static class StringPairComparator
    implements java.util.Comparator {
        protected static StringPairComparator instance = new StringPairComparator();
        protected XSDPlugin.StringComparator collator = XSDPlugin.INSTANCE.getComparator();

        public static StringPairComparator getInstance() {
            if (instance == null) {
                instance = new StringPairComparator();
            }
            return instance;
        }

        public boolean equals(Object that) {
            return this == that;
        }

        public int compare(Object o1, Object o2) {
            XSDNamedComponent xsdNamedComponent = (XSDNamedComponent)o1;
            String[] strings = (String[])o2;
            String name1 = xsdNamedComponent.getName();
            String name2 = strings[1];
            if (name1 == null && name2 == null) {
                return 0;
            }
            if (name1 == null) {
                return 1;
            }
            if (name2 == null) {
                return -1;
            }
            int result = this.collator.compare(name1, name2);
            if (result == 0) {
                String namespace1 = xsdNamedComponent.getTargetNamespace();
                String namespace2 = strings[0];
                if (namespace1 == null && namespace2 == null) {
                    return 0;
                }
                if (namespace1 == null) {
                    return 1;
                }
                if (namespace2 == null) {
                    return -1;
                }
                return this.collator.compare(namespace1, namespace2);
            }
            return result;
        }
    }
}

