/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ModuleKind;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;

public class ModuleType
implements IModuleType {
    protected String id;
    protected String version;
    private static List<ModuleKind> moduleKinds;
    private static List<ModuleType> moduleTypes;

    public ModuleType(String id, String version) {
        this.id = id;
        this.version = version;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        ModuleKind mt = ModuleType.findModuleType(this.id);
        if (mt != null) {
            return mt.getName();
        }
        return Messages.moduleTypeUnknown;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public static synchronized ModuleType getModuleType(String id, String version) {
        ModuleType mt2;
        if (moduleTypes == null) {
            moduleTypes = new ArrayList<ModuleType>();
        }
        for (ModuleType mt2 : moduleTypes) {
            if ((id != null || mt2.id != null) && (id == null || !id.equals(mt2.id)) || (version != null || mt2.version != null) && (version == null || !version.equals(mt2.version))) continue;
            return mt2;
        }
        mt2 = new ModuleType(id, version);
        moduleTypes.add(mt2);
        return mt2;
    }

    private static ModuleKind findModuleType(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (moduleKinds == null) {
            ModuleType.loadModuleTypes();
        }
        for (ModuleKind moduleType : moduleKinds) {
            if (!id.equals(moduleType.getId())) continue;
            return moduleType;
        }
        return null;
    }

    private static synchronized void loadModuleTypes() {
        if (moduleKinds != null) {
            return;
        }
        if (Trace.EXTENSION_POINT) {
            Trace.trace("/extension_point", "->- Loading .moduleTypes extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", "moduleTypes");
        int size = cf.length;
        moduleKinds = new ArrayList<ModuleKind>(size);
        int i = 0;
        while (i < size) {
            block7: {
                try {
                    ModuleKind moduleType = new ModuleKind(cf[i]);
                    moduleKinds.add(moduleType);
                    if (Trace.EXTENSION_POINT) {
                        Trace.trace("/extension_point", "  Loaded moduleType: " + cf[i].getAttribute("id"));
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block7;
                    Trace.trace("/severe", "  Could not load moduleType: " + cf[i].getAttribute("id"), t);
                }
            }
            ++i;
        }
        if (Trace.EXTENSION_POINT) {
            Trace.trace("/extension_point", "-<- Done loading .moduleTypes extension point -<-");
        }
    }

    public int hashCode() {
        int hash = 17;
        if (this.id != null) {
            hash += this.id.hashCode();
        }
        if (this.version != null) {
            hash += this.version.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModuleType)) {
            return false;
        }
        ModuleType mt = (ModuleType)obj;
        if (!ServerPlugin.matches(this.id, mt.id)) {
            return false;
        }
        return ServerPlugin.matches(this.version, mt.version);
    }

    public String toString() {
        return "ModuleType[" + this.id + ", " + this.version + "]";
    }
}

