/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.wst.jsdt.chromium.CallFrame;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.ExceptionData;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugElementImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StackFrame;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StackFrameBase;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Variable;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class JavascriptThread
extends DebugElementImpl.WithConnected
implements IThread,
IAdaptable {
    private final RemoteEventListener remoteEventListener = new RemoteEventListener();
    private volatile StepState currentStepState = new RunningState(ResumeReason.UNSPECIFIED);
    private final Object currentStepStateMonitor = new Object();
    private volatile SuspendReason expectedSuspendReason = SuspendReason.UNSPECIFIED;
    private final ISuspendResume suspendResumeAspect = new ISuspendResume(){

        public boolean canResume() {
            return !this.isDisconnected() && this.isSuspended();
        }

        public boolean isSuspended() {
            return !this.isDisconnected() && JavascriptThread.this.currentStepState.isSuspended();
        }

        public void resume() throws DebugException {
            JavascriptThread.this.currentStepState.resume();
        }

        public boolean canSuspend() {
            return !this.isDisconnected() && JavascriptThread.this.currentStepState.canSuspend();
        }

        public void suspend() throws DebugException {
            JavascriptThread.this.currentStepState.suspend();
        }

        private boolean isDisconnected() {
            return JavascriptThread.this.getConnectedData().isDisconnected();
        }
    };
    private static final StackFrame[] EMPTY_FRAMES = new StackFrame[0];
    private static final IBreakpoint[] EMPTY_BREAKPOINTS = new IBreakpoint[0];

    public JavascriptThread(ConnectedTargetData connectedTargetData) {
        super(connectedTargetData);
    }

    RemoteEventListener getRemoteEventListener() {
        return this.remoteEventListener;
    }

    ISuspendResume getSuspendResumeAspect() {
        return this.suspendResumeAspect;
    }

    public StackFrameBase[] getStackFrames() throws DebugException {
        return this.currentStepState.getStackFrames();
    }

    public <R> R describeState(StateVisitor<R> visitor) {
        return this.currentStepState.describeState(visitor);
    }

    private static StackFrameBase[] wrapStackFrames(SuspendedState threadState) {
        DebugContext debugContext = threadState.getDebugContext();
        List jsFrames = debugContext.getCallFrames();
        ArrayList<StackFrameBase> result = new ArrayList<StackFrameBase>(jsFrames.size() + 1);
        ExceptionData exceptionData = debugContext.getExceptionData();
        if (exceptionData != null) {
            EvaluateContext evaluateContext = new EvaluateContext(debugContext.getGlobalEvaluateContext(), threadState);
            result.add(new ExceptionStackFrame(evaluateContext, exceptionData));
        }
        for (CallFrame jsFrame : jsFrames) {
            result.add(new StackFrame(threadState, jsFrame));
        }
        return (StackFrameBase[])BasicUtil.toArray(result, StackFrameBase.class);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        StackFrameBase[] frames = this.getStackFrames();
        if (frames.length == 0) {
            return null;
        }
        if (frames[0].isRegularFrame()) {
            return frames[0];
        }
        if (frames.length == 1) {
            return null;
        }
        return frames[1];
    }

    public String getName() throws DebugException {
        return this.getDebugTarget().getLabelProvider().getThreadLabel(this);
    }

    public IBreakpoint[] getBreakpoints() {
        return this.currentStepState.getBreakpoints();
    }

    public boolean canResume() {
        return this.suspendResumeAspect.canResume();
    }

    public boolean canSuspend() {
        return this.suspendResumeAspect.canSuspend();
    }

    public boolean isSuspended() {
        return this.suspendResumeAspect.isSuspended();
    }

    public void resume() throws DebugException {
        this.suspendResumeAspect.resume();
    }

    public void suspend() throws DebugException {
        this.suspendResumeAspect.suspend();
    }

    public boolean canStepInto() {
        return this.currentStepState.canStep();
    }

    public boolean canStepOver() {
        return this.currentStepState.canStep();
    }

    public boolean canStepReturn() {
        return this.currentStepState.canStep();
    }

    public boolean isStepping() {
        return this.currentStepState.isStepping();
    }

    public void stepInto() throws DebugException {
        this.currentStepState.step(DebugContext.StepAction.IN, ResumeReason.STEP_INTO);
    }

    public void stepOver() throws DebugException {
        this.currentStepState.step(DebugContext.StepAction.OVER, ResumeReason.STEP_OVER);
    }

    public void stepReturn() throws DebugException {
        this.currentStepState.step(DebugContext.StepAction.OUT, ResumeReason.STEP_RETURN);
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    EvaluateContext getEvaluateContext() {
        return this.currentStepState.getEvaluateContext();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == EvaluateContext.class) {
            return this.getEvaluateContext();
        }
        return super.getAdapter(adapter);
    }

    private static class ExceptionStackFrame
    extends StackFrameBase {
        private final IVariable[] variables;
        private final ExceptionData exceptionData;

        private ExceptionStackFrame(EvaluateContext evaluateContext, ExceptionData exceptionData) {
            super(evaluateContext);
            this.exceptionData = exceptionData;
            Variable variable = Variable.forException(evaluateContext, exceptionData.getExceptionValue());
            this.variables = new IVariable[]{variable};
        }

        public IVariable[] getVariables() throws DebugException {
            return this.variables;
        }

        public boolean hasVariables() throws DebugException {
            return this.variables.length > 0;
        }

        public int getLineNumber() throws DebugException {
            return -1;
        }

        public int getCharStart() throws DebugException {
            return -1;
        }

        public int getCharEnd() throws DebugException {
            return this.getCharStart();
        }

        public String getName() throws DebugException {
            return "<throwing exception>";
        }

        @Override
        Object getObjectForEquals() {
            return this.exceptionData;
        }

        @Override
        boolean isRegularFrame() {
            return false;
        }
    }

    class RemoteEventListener {
        RemoteEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void suspended(DebugContext context) {
            SuspendReason suspendedReason;
            Collection<? extends IBreakpoint> uiBreakpointsHit;
            SuspendedStateImpl suspendedState;
            Object object = JavascriptThread.this.currentStepStateMonitor;
            synchronized (object) {
                if (JavascriptThread.this.currentStepState.isSuspended()) {
                    throw new IllegalStateException("Already in suspended state");
                }
                suspendedState = new SuspendedStateImpl(context);
                JavascriptThread.this.currentStepState = suspendedState;
            }
            WorkspaceBridge workspaceRelations = JavascriptThread.this.getConnectedData().getWorkspaceRelations();
            if (context.getState() == DebugContext.State.EXCEPTION) {
                uiBreakpointsHit = workspaceRelations.getBreakpointHandler().exceptionBreakpointHit(context.getExceptionData().isUncaught());
                suspendedReason = SuspendReason.BREAKPOINT;
            } else {
                Collection sdkBreakpointsHit = context.getBreakpointsHit();
                uiBreakpointsHit = workspaceRelations.getBreakpointHandler().breakpointsHit(sdkBreakpointsHit);
                suspendedReason = sdkBreakpointsHit.isEmpty() ? JavascriptThread.this.expectedSuspendReason : SuspendReason.BREAKPOINT;
            }
            suspendedState.setBreakpoints(uiBreakpointsHit);
            int suspendedDetail = suspendedReason == null ? 0 : suspendedReason.detailCode;
            JavascriptThread.this.getConnectedData().fireSuspendEvent(suspendedDetail);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resumed(ResumeReason resumeReason) {
            Object object = JavascriptThread.this.currentStepStateMonitor;
            synchronized (object) {
                if (!JavascriptThread.this.currentStepState.isSuspended()) {
                    return;
                }
                if (resumeReason == null) {
                    resumeReason = ResumeReason.UNSPECIFIED;
                }
                JavascriptThread.this.currentStepState.dismiss();
                JavascriptThread.this.currentStepState = new RunningState(resumeReason);
            }
            JavascriptThread.this.getConnectedData().fireResumeEvent(resumeReason.detailCode);
        }
    }

    static enum ResumeReason {
        STEP_INTO(1, true),
        STEP_OVER(2, true),
        STEP_RETURN(4, true),
        CLIENT_REQUEST(32, false),
        UNSPECIFIED(0, false);

        private final int detailCode;
        private final boolean isStepping;

        private ResumeReason(int detailCode, boolean isStepping) {
            this.detailCode = detailCode;
            this.isStepping = isStepping;
        }
    }

    private class RunningState
    extends StepState {
        private final ResumeReason resumeReason;

        RunningState(ResumeReason resumeReason) {
            this.resumeReason = resumeReason;
        }

        @Override
        boolean isSuspended() {
            return false;
        }

        @Override
        boolean canSuspend() {
            return true;
        }

        @Override
        void suspend() {
            JavascriptThread.this.expectedSuspendReason = SuspendReason.CLIENT_REQUEST;
            JavascriptThread.this.getConnectedData().getJavascriptVm().suspend(null);
        }

        @Override
        StackFrameBase[] getStackFrames() {
            return EMPTY_FRAMES;
        }

        @Override
        IBreakpoint[] getBreakpoints() {
            return EMPTY_BREAKPOINTS;
        }

        @Override
        boolean isStepping() {
            return this.resumeReason.isStepping;
        }

        @Override
        boolean canStep() {
            return false;
        }

        @Override
        void step(DebugContext.StepAction stepAction, ResumeReason resumeReason) {
        }

        @Override
        void resume() {
        }

        @Override
        EvaluateContext getEvaluateContext() {
            return null;
        }

        @Override
        void dismiss() {
        }

        @Override
        <R> R describeState(StateVisitor<R> visitor) {
            return visitor.visitResumed(this.resumeReason);
        }
    }

    public static interface StateVisitor<R> {
        public R visitResumed(ResumeReason var1);

        public R visitSuspended(IBreakpoint[] var1, ExceptionData var2);
    }

    private static abstract class StepState {
        private StepState() {
        }

        abstract EvaluateContext getEvaluateContext();

        abstract IBreakpoint[] getBreakpoints();

        abstract StackFrameBase[] getStackFrames();

        abstract boolean isSuspended();

        abstract void resume();

        abstract boolean canSuspend();

        abstract void suspend();

        abstract boolean isStepping();

        abstract void step(DebugContext.StepAction var1, ResumeReason var2);

        abstract boolean canStep();

        abstract <R> R describeState(StateVisitor<R> var1);

        abstract void dismiss();
    }

    private static enum SuspendReason {
        STEP_END(8),
        CLIENT_REQUEST(32),
        BREAKPOINT(16),
        UNSPECIFIED(0);

        final int detailCode;

        private SuspendReason(int detailCode) {
            this.detailCode = detailCode;
        }
    }

    public static interface SuspendedState {
        public JavascriptThread getThread();

        public DebugContext getDebugContext();

        public boolean isDismissed();
    }

    private class SuspendedStateImpl
    extends StepState
    implements SuspendedState {
        private final DebugContext context;
        private volatile boolean isDismissed = false;
        private volatile IBreakpoint[] breakpoints = JavascriptThread.access$7();
        private final AtomicReference<StackFrameBase[]> stackFrames = new AtomicReference<Object>(null);

        SuspendedStateImpl(DebugContext context) {
            this.context = context;
        }

        @Override
        public JavascriptThread getThread() {
            return JavascriptThread.this;
        }

        @Override
        public DebugContext getDebugContext() {
            return this.context;
        }

        @Override
        void dismiss() {
            this.isDismissed = true;
        }

        @Override
        public boolean isDismissed() {
            return this.isDismissed;
        }

        void setBreakpoints(Collection<? extends IBreakpoint> uiBreakpoints) {
            this.breakpoints = (IBreakpoint[])BasicUtil.toArray(uiBreakpoints, IBreakpoint.class);
        }

        @Override
        boolean isSuspended() {
            return true;
        }

        @Override
        boolean canSuspend() {
            return false;
        }

        @Override
        void suspend() {
        }

        @Override
        boolean canStep() {
            return true;
        }

        @Override
        void resume() {
            this.continueVm(DebugContext.StepAction.CONTINUE, ResumeReason.CLIENT_REQUEST, SuspendReason.UNSPECIFIED);
        }

        @Override
        void step(DebugContext.StepAction stepAction, ResumeReason resumeReason) {
            this.continueVm(stepAction, resumeReason, SuspendReason.STEP_END);
        }

        private void continueVm(DebugContext.StepAction stepAction, final ResumeReason resumeReason, SuspendReason futureSuspendReason) {
            JavascriptThread.this.expectedSuspendReason = futureSuspendReason;
            DebugContext.ContinueCallback callback = new DebugContext.ContinueCallback(){

                public void success() {
                    JavascriptThread.this.remoteEventListener.resumed(resumeReason);
                }

                public void failure(String errorMessage) {
                    ChromiumDebugPlugin.log(new Exception("Failed to resume: " + errorMessage));
                }
            };
            this.context.continueVm(stepAction, 1, callback);
        }

        @Override
        StackFrameBase[] getStackFrames() {
            StackFrameBase[] result = this.stackFrames.get();
            if (result == null) {
                result = JavascriptThread.wrapStackFrames(this);
                this.stackFrames.compareAndSet(null, result);
                result = this.stackFrames.get();
            }
            return result;
        }

        @Override
        IBreakpoint[] getBreakpoints() {
            return this.breakpoints;
        }

        @Override
        boolean isStepping() {
            return false;
        }

        @Override
        EvaluateContext getEvaluateContext() {
            return new EvaluateContext(this.context.getGlobalEvaluateContext(), this);
        }

        @Override
        <R> R describeState(StateVisitor<R> visitor) {
            return visitor.visitSuspended(this.breakpoints, this.context.getExceptionData());
        }
    }
}

