/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValidationResultSummary;

public final class ValOperation {
    private final ValidationState _state = new ValidationState();
    private final ValidationResult _result = new ValidationResult();
    private final Map<IProject, Set<String>> _suspended = new HashMap<IProject, Set<String>>(40);
    private final long _started = System.currentTimeMillis();
    private final boolean _multiProject;
    private final Map<String, Set<IResource>> _validated = new HashMap<String, Set<IResource>>(20);
    private final Set<IResource> _validatedProjects = new HashSet<IResource>(20);

    public ValOperation() {
        this._multiProject = false;
    }

    public ValOperation(boolean multiProject) {
        this._multiProject = multiProject;
    }

    public ValidationState getState() {
        return this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResultSummary getResult() {
        ValidationResult validationResult = this._result;
        synchronized (validationResult) {
            ValidationResultSummary vrs = new ValidationResultSummary(this._result.getSeverityError(), this._result.getSeverityWarning(), this._result.getSeverityInfo());
            return vrs;
        }
    }

    public ValidationResults getResults() {
        return new ValidationResults(this._result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidated(String id, IResource resource) {
        Map<String, Set<IResource>> map = this._validated;
        synchronized (map) {
            Set<IResource> set = this._validated.get(id);
            if (set == null) {
                set = new HashSet<IResource>(20);
                this._validated.put(id, set);
            }
            set.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidatedProject(IResource resource) {
        Set<IResource> set = this._validatedProjects;
        synchronized (set) {
            if (resource != null) {
                this._validatedProjects.add(resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidated(String id, IResource resource) {
        Map<String, Set<IResource>> map = this._validated;
        synchronized (map) {
            Set<IResource> set;
            block4: {
                set = this._validated.get(id);
                if (set != null) break block4;
                return false;
            }
            return set.contains(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidatedProject(IResource resource) {
        Set<IResource> set = this._validatedProjects;
        synchronized (set) {
            return this._validatedProjects.contains(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended(Validator val, IProject project) {
        if (project == null) {
            return false;
        }
        Map<IProject, Set<String>> map = this._suspended;
        synchronized (map) {
            Set<String> set = this.getSuspended(project);
            return set.contains(val.getId());
        }
    }

    private Set<String> getSuspended(IProject project) {
        Set<String> set = this._suspended.get(project);
        if (set == null) {
            set = new HashSet<String>(5);
            this._suspended.put(project, set);
        }
        return set;
    }

    void suspendValidation(IProject project, Validator validator) {
        if (project == null) {
            return;
        }
        if (validator == null) {
            return;
        }
        this.getSuspended(project).add(validator.getId());
    }

    public long getStarted() {
        return this._started;
    }

    public boolean isMultiProject() {
        return this._multiProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanceled(boolean canceled) {
        ValidationResult validationResult = this._result;
        synchronized (validationResult) {
            this._result.setCanceled(canceled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        ValidationResult validationResult = this._result;
        synchronized (validationResult) {
            return this._result.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeResults(ValidationResult vr) {
        ValidationResult validationResult = this._result;
        synchronized (validationResult) {
            this._result.mergeResults(vr);
        }
    }
}

