/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class PreferencesAccess {
    public static PreferencesAccess getOriginalPreferences() {
        return new PreferencesAccess();
    }

    public static PreferencesAccess getWorkingCopyPreferences(IWorkingCopyManager workingCopyManager) {
        return new WorkingCopyPreferencesAccess(workingCopyManager);
    }

    private PreferencesAccess() {
    }

    public IScopeContext getDefaultScope() {
        return new DefaultScope();
    }

    public IScopeContext getInstanceScope() {
        return new InstanceScope();
    }

    public IScopeContext getProjectScope(IProject project) {
        return new ProjectScope(project);
    }

    public void applyChanges() throws BackingStoreException {
    }

    /* synthetic */ PreferencesAccess(PreferencesAccess preferencesAccess) {
        this();
    }

    private static class WorkingCopyPreferencesAccess
    extends PreferencesAccess {
        private final IWorkingCopyManager fWorkingCopyManager;

        private WorkingCopyPreferencesAccess(IWorkingCopyManager workingCopyManager) {
            super(null);
            this.fWorkingCopyManager = workingCopyManager;
        }

        private final IScopeContext getWorkingCopyScopeContext(IScopeContext original) {
            return new WorkingCopyScopeContext(this.fWorkingCopyManager, original);
        }

        @Override
        public IScopeContext getDefaultScope() {
            return this.getWorkingCopyScopeContext(super.getDefaultScope());
        }

        @Override
        public IScopeContext getInstanceScope() {
            return this.getWorkingCopyScopeContext(super.getInstanceScope());
        }

        @Override
        public IScopeContext getProjectScope(IProject project) {
            return this.getWorkingCopyScopeContext(super.getProjectScope(project));
        }

        @Override
        public void applyChanges() throws BackingStoreException {
            this.fWorkingCopyManager.applyChanges();
        }
    }

    private static class WorkingCopyScopeContext
    implements IScopeContext {
        private final IWorkingCopyManager fWorkingCopyManager;
        private final IScopeContext fOriginal;

        public WorkingCopyScopeContext(IWorkingCopyManager workingCopyManager, IScopeContext original) {
            this.fWorkingCopyManager = workingCopyManager;
            this.fOriginal = original;
        }

        public String getName() {
            return this.fOriginal.getName();
        }

        public IEclipsePreferences getNode(String qualifier) {
            return this.fWorkingCopyManager.getWorkingCopy(this.fOriginal.getNode(qualifier));
        }

        public IPath getLocation() {
            return this.fOriginal.getLocation();
        }
    }
}

